/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.identity.FeatureId;
import org.w3c.dom.Document;

public class Transaction3DTest
extends WFSTestSupport {
    static final QName FULL3D = new QName(SystemTestData.CITE_URI, "full3d", SystemTestData.CITE_PREFIX);
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private XpathEngine xpath;
    private WKTReader wkt = new WKTReader();

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void setupXPathEngine() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    @Before
    public void revert() throws Exception {
        ((SystemTestData)this.getTestData()).addVectorLayer(FULL3D, Collections.emptyMap(), ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testInsert3DPoint() throws Exception {
        Document insertDom = this.postRequest("insertPoint3d.xml", new String[0]);
        this.print(insertDom);
        String fid = this.assertSuccesfulInsert(insertDom);
        Document featureDom = this.getFeature(fid);
        this.print(featureDom);
        Assert.assertEquals((Object)"New point", (Object)this.xpath.evaluate("//cite:full3d/gml:name", featureDom));
        Assert.assertEquals((Object)"3", (Object)this.xpath.evaluate("//cite:full3d/cite:geom/gml:Point/@srsDimension", featureDom));
        Assert.assertEquals((Object)"204330 491816 16", (Object)this.xpath.evaluate("//cite:full3d/cite:geom/gml:Point/gml:pos", featureDom));
        SimpleFeature feature = this.getFeatureFromStore(fid);
        Geometry g = (Geometry)feature.getDefaultGeometry();
        this.assertEqualND(g, this.wkt.read("POINT(204330 491816 16)"));
    }

    @Test
    public void testInsert3DLinestring() throws Exception {
        Document insertDom = this.postRequest("insertLinestring3d.xml", new String[0]);
        String fid = this.assertSuccesfulInsert(insertDom);
        Document featureDom = this.getFeature(fid);
        Assert.assertEquals((Object)"New line", (Object)this.xpath.evaluate("//cite:full3d/gml:name", featureDom));
        Assert.assertEquals((Object)"3", (Object)this.xpath.evaluate("//cite:full3d/cite:geom/gml:LineString/@srsDimension", featureDom));
        Assert.assertEquals((Object)"204330 491816 16 204319 491814 16", (Object)this.xpath.evaluate("//cite:full3d/cite:geom/gml:LineString/gml:posList", featureDom));
        SimpleFeature feature = this.getFeatureFromStore(fid);
        Geometry g = (Geometry)feature.getDefaultGeometry();
        this.assertEqualND(g, this.wkt.read("LINESTRING(204330 491816 16, 204319 491814 16)"));
    }

    @Test
    public void testInsert3DPolygon() throws Exception {
        Document insertDom = this.postRequest("insertPolygon3d.xml", new String[0]);
        String fid = this.assertSuccesfulInsert(insertDom);
        Document featureDom = this.getFeature(fid);
        Assert.assertEquals((Object)"New polygon", (Object)this.xpath.evaluate("//cite:full3d/gml:name", featureDom));
        Assert.assertEquals((Object)"3", (Object)this.xpath.evaluate("//cite:full3d/cite:geom/gml:Polygon/@srsDimension", featureDom));
        Assert.assertEquals((Object)"94000 471000 10 94001 471000 11 94001 471001 12 94000 471001 13 94000 471000 10", (Object)this.xpath.evaluate("//cite:full3d/cite:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", featureDom));
        SimpleFeature feature = this.getFeatureFromStore(fid);
        Geometry g = (Geometry)feature.getDefaultGeometry();
        this.assertEqualND(g, this.wkt.read("POLYGON((94000 471000 10, 94001 471000 11, 94001 471001 12, 94000 471001 13, 94000 471000 10))"));
    }

    @Test
    public void testDelete3DPoint() throws Exception {
        Document deleteDom = this.postRequest("delete3d.xml", "${id}", "full3d.point");
        this.assertSuccesfulDelete(deleteDom);
        Assert.assertNull((Object)this.getFeatureFromStore("full3d.point"));
        Assert.assertEquals((long)2L, (long)this.getCountFromStore((Filter)Filter.INCLUDE));
    }

    @Test
    public void testDelete3DLineString() throws Exception {
        Document deleteDom = this.postRequest("delete3d.xml", "${id}", "full3d.ls");
        this.assertSuccesfulDelete(deleteDom);
        Assert.assertNull((Object)this.getFeatureFromStore("full3d.ls"));
        Assert.assertEquals((long)2L, (long)this.getCountFromStore((Filter)Filter.INCLUDE));
    }

    @Test
    public void testDelete3DPolygon() throws Exception {
        Document deleteDom = this.postRequest("delete3d.xml", "${id}", "full3d.poly");
        this.assertSuccesfulDelete(deleteDom);
        Assert.assertNull((Object)this.getFeatureFromStore("full3d.poly"));
        Assert.assertEquals((long)2L, (long)this.getCountFromStore((Filter)Filter.INCLUDE));
    }

    @Test
    public void testUpdate3DPoint() throws Exception {
        Document updateDom = this.postRequest("updatePoint3d.xml", new String[0]);
        this.assertSuccesfulUpdate(updateDom);
        SimpleFeature feature = this.getFeatureFromStore("full3d.point");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        this.assertEqualND(g, this.wkt.read("POINT(204330 491816 16)"));
        Assert.assertEquals((long)3L, (long)this.getCountFromStore((Filter)Filter.INCLUDE));
    }

    @Test
    public void testUpdate3DLinestring() throws Exception {
        Document updateDom = this.postRequest("updateLinestring3d.xml", new String[0]);
        this.assertSuccesfulUpdate(updateDom);
        SimpleFeature feature = this.getFeatureFromStore("full3d.ls");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        this.assertEqualND(g, this.wkt.read("LINESTRING(204330 491816 16, 204319 491814 16)"));
        Assert.assertEquals((long)3L, (long)this.getCountFromStore((Filter)Filter.INCLUDE));
    }

    @Test
    public void testUpdate3DPolygon() throws Exception {
        Document updateDom = this.postRequest("updatePolygon3d.xml", new String[0]);
        this.assertSuccesfulUpdate(updateDom);
        SimpleFeature feature = this.getFeatureFromStore("full3d.poly");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        this.assertEqualND(g, this.wkt.read("POLYGON((94000 471000 10, 94001 471000 11, 94001 471001 12, 94000 471001 13, 94000 471000 10))"));
        Assert.assertEquals((long)3L, (long)this.getCountFromStore((Filter)Filter.INCLUDE));
    }

    private String assertSuccesfulInsert(Document dom) throws XpathException {
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("/wfs:TransactionResponse/wfs:TransactionSummary/wfs:totalInserted", dom));
        return this.xpath.evaluate("/wfs:TransactionResponse/wfs:InsertResults/wfs:Feature/ogc:FeatureId/@fid", dom);
    }

    private void assertSuccesfulDelete(Document dom) throws XpathException {
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("/wfs:TransactionResponse/wfs:TransactionSummary/wfs:totalDeleted", dom));
    }

    private void assertSuccesfulUpdate(Document dom) throws XpathException {
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("/wfs:TransactionResponse/wfs:TransactionSummary/wfs:totalUpdated", dom));
    }

    private void assertEqualND(Geometry test, Geometry expected) {
        WKTWriter writer = new WKTWriter(3);
        Assert.assertTrue((String)("Expected " + writer.write(expected) + " but got " + writer.write(test)), (boolean)CoordinateSequences.equalsND((Geometry)expected, (Geometry)test));
    }

    private Document postRequest(String requestFile, String ... variableMap) throws IOException, Exception {
        String xml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(requestFile));
        if (variableMap != null) {
            for (int i = 0; i < variableMap.length; i += 2) {
                String key = variableMap[i];
                String value = variableMap[i + 1];
                xml = xml.replace(key, value);
            }
        }
        Document dom = this.postAsDOM("wfs", xml);
        return dom;
    }

    private Document getFeature(String featureId) throws IOException, Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=" + this.getLayerId(FULL3D) + "&featureId=" + featureId);
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:full3d)", dom));
        return dom;
    }

    private SimpleFeature getFeatureFromStore(String fid) throws IOException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(this.getLayerId(FULL3D));
        SimpleFeatureSource featureSource = (SimpleFeatureSource)ftInfo.getFeatureSource(null, null);
        SimpleFeatureCollection fc = featureSource.getFeatures((Filter)FF.id(new FeatureId[]{FF.featureId(fid)}));
        SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        return first;
    }

    private int getCountFromStore(Filter filter) throws IOException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(this.getLayerId(FULL3D));
        SimpleFeatureSource featureSource = (SimpleFeatureSource)ftInfo.getFeatureSource(null, null);
        SimpleFeatureCollection fc = featureSource.getFeatures(filter);
        return fc.size();
    }
}

