/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.MockTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetCapabilitiesTest
extends WFSTestSupport {
    @Before
    public void revert() throws Exception {
        this.revertLayer(CiteTestData.UPDATES);
        this.revertLayer(CiteTestData.BUILDINGS);
        this.revertLayer(MockData.MPOLYGONS);
    }

    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        DataStoreInfo di = this.getCatalog().getDataStoreByName(CiteTestData.CITE_PREFIX);
        di.setEnabled(false);
        this.getCatalog().save((StoreInfo)di);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    @Test
    public void testGet() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=1.1.0");
        String docText = this.getAsString("wfs?service=WFS&request=GetCapabilities&version=1.1.0");
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1.1.0", (Object)doc.getDocumentElement().getAttribute("version"));
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//wfs:FeatureType", doc).getLength() > 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)docText, (boolean)docText.contains("xmlns:xml="));
    }

    @Test
    public void testNamespaceFilter() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities&namespace=sf");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[starts-with(., sf)]", doc).getLength() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[not(starts-with(., sf))]", doc).getLength());
        doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities&namespace=NotThere");
        e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wfs:FeatureType", doc).getLength());
    }

    @Test
    public void testPost() throws Exception {
        String xml = "<GetCapabilities service=\"WFS\" version='1.1.0' xmlns=\"http://www.opengis.net/wfs\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xmlns:ows=\"http://www.opengis.net/ows\"  xsi:schemaLocation=\"http://www.opengis.net/wfs  http://schemas.opengis.net/wfs/1.1.0/wfs.xsd\"><ows:AcceptVersions><ows:Version>1.1.0</ows:Version></ows:AcceptVersions></GetCapabilities>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1.1.0", (Object)doc.getDocumentElement().getAttribute("version"));
    }

    @Test
    public void testPostNoSchemaLocation() throws Exception {
        String xml = "<GetCapabilities service=\"WFS\" version='1.1.0' xmlns=\"http://www.opengis.net/wfs\"  xmlns:ows=\"http://www.opengis.net/ows\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ><ows:AcceptVersions><ows:Version>1.1.0</ows:Version></ows:AcceptVersions></GetCapabilities>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1.1.0", (Object)doc.getDocumentElement().getAttribute("version"));
    }

    @Test
    public void testOutputFormats() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=1.1.0");
        XpathEngine engine = XMLUnit.newXpathEngine();
        NodeList formats = engine.getMatchingNodes("//ows:Operation[@name=\"GetFeature\"]/ows:Parameter[@name=\"outputFormat\"]/ows:Value", doc);
        TreeSet<String> s1 = new TreeSet<String>();
        for (int i = 0; i < formats.getLength(); ++i) {
            String format = formats.item(i).getFirstChild().getNodeValue();
            s1.add(format);
        }
        List extensions = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class);
        TreeSet s2 = new TreeSet();
        for (WFSGetFeatureOutputFormat extension : extensions) {
            s2.addAll(extension.getOutputFormats());
        }
        Assert.assertEquals(s1, s2);
    }

    @Test
    public void testSupportedSpatialOperators() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=1.1.0");
        XpathEngine engine = XMLUnit.newXpathEngine();
        NodeList spatialOperators = engine.getMatchingNodes("//ogc:Spatial_Capabilities/ogc:SpatialOperators/ogc:SpatialOperator/@name", doc);
        TreeSet<String> ops = new TreeSet<String>();
        for (int i = 0; i < spatialOperators.getLength(); ++i) {
            String format = spatialOperators.item(i).getFirstChild().getNodeValue();
            ops.add(format);
        }
        List<String> expectedSpatialOperators = this.getSupportedSpatialOperatorsList(false);
        Assert.assertEquals((long)expectedSpatialOperators.size(), (long)ops.size());
        Assert.assertTrue((boolean)ops.containsAll(expectedSpatialOperators));
    }

    @Test
    public void testFunctionArgCount() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=1.1.0");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//ogc:FunctionName[text()=\"abs\"]/@nArgs", (Document)doc);
    }

    @Test
    public void testTypeNameCount() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        List enabledTypes = this.getCatalog().getFeatureTypes();
        Iterator it = enabledTypes.iterator();
        while (it.hasNext()) {
            FeatureTypeInfo ft = (FeatureTypeInfo)it.next();
            if (ft.enabled()) continue;
            it.remove();
        }
        int enabledCount = enabledTypes.size();
        Assert.assertEquals((long)enabledCount, (long)xpath.getMatchingNodes("/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType", doc).getLength());
    }

    @Test
    public void testTypeNames() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        List enabledTypes = this.getCatalog().getFeatureTypes();
        for (FeatureTypeInfo ft : enabledTypes) {
            if (!ft.enabled()) continue;
            String prefixedName = ft.prefixedName();
            String xpathExpr = "/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType/wfs:Name[text()=\"" + prefixedName + "\"]";
            XMLAssert.assertXpathExists((String)xpathExpr, (Document)doc);
        }
    }

    @Test
    public void testLayerQualified() throws Exception {
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wfs?service=WFS&version=1.1.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[starts-with(., sf)]", doc).getLength());
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[not(starts-with(., sf))]", doc).getLength());
        Assert.assertEquals((long)7L, (long)xpath.getMatchingNodes("//ows:Get[contains(@xlink:href,'sf/PrimitiveGeoFeature/wfs')]", doc).getLength());
        Assert.assertEquals((long)7L, (long)xpath.getMatchingNodes("//ows:Post[contains(@xlink:href,'sf/PrimitiveGeoFeature/wfs')]", doc).getLength());
    }

    @Test
    public void testMetadataLinks() throws Exception {
        FeatureTypeInfo mpolys = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockTestData.MPOLYGONS));
        MetadataLinkInfo ml1 = this.getCatalog().getFactory().createMetadataLink();
        ml1.setMetadataType("ISO19115:2003");
        ml1.setType("text/html");
        ml1.setContent("http://www.geoserver.org");
        mpolys.getMetadataLinks().add(ml1);
        MetadataLinkInfo ml2 = this.getCatalog().getFactory().createMetadataLink();
        ml2.setMetadataType("FGDC");
        ml2.setType("text/html");
        ml2.setContent("http://www.geoserver.org");
        mpolys.getMetadataLinks().add(ml2);
        MetadataLinkInfo ml3 = this.getCatalog().getFactory().createMetadataLink();
        ml3.setMetadataType("other");
        ml3.setType("text/html");
        ml3.setContent("http://www.geoserver.org");
        mpolys.getMetadataLinks().add(ml3);
        MetadataLinkInfo ml4 = this.getCatalog().getFactory().createMetadataLink();
        ml4.setMetadataType("FGDC");
        ml4.setType("application/zip");
        ml4.setContent("http://www.geoserver.org");
        mpolys.getMetadataLinks().add(ml4);
        this.getCatalog().save((ResourceInfo)mpolys);
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)2L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL", doc).getLength());
        Assert.assertEquals((long)2L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL[@format='text/html']", doc).getLength());
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL[@type='19115']", doc).getLength());
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL[@type='FGDC']", doc).getLength());
        Assert.assertEquals((long)2L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL[text() = 'http://www.geoserver.org']", doc).getLength());
    }

    @Test
    public void testMetadataLinksTransormToProxyBaseURL() throws Exception {
        FeatureTypeInfo mpolys = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockTestData.MPOLYGONS));
        MetadataLinkInfo ml1 = this.getCatalog().getFactory().createMetadataLink();
        ml1.setMetadataType("ISO19115:2003");
        ml1.setType("text/html");
        ml1.setContent("/metadata?key=value");
        mpolys.getMetadataLinks().add(ml1);
        MetadataLinkInfo ml2 = this.getCatalog().getFactory().createMetadataLink();
        ml2.setMetadataType("FGDC");
        ml2.setType("text/html");
        ml2.setContent("/metadata?key=value");
        mpolys.getMetadataLinks().add(ml2);
        MetadataLinkInfo ml3 = this.getCatalog().getFactory().createMetadataLink();
        ml3.setMetadataType("other");
        ml3.setType("text/html");
        ml3.setContent("/metadata?key=value");
        mpolys.getMetadataLinks().add(ml3);
        MetadataLinkInfo ml4 = this.getCatalog().getFactory().createMetadataLink();
        ml4.setMetadataType("FGDC");
        ml4.setType("application/zip");
        ml4.setContent("/metadata?key=value");
        mpolys.getMetadataLinks().add(ml4);
        this.getCatalog().save((ResourceInfo)mpolys);
        String proxyBaseUrl = this.getGeoServer().getGlobal().getSettings().getProxyBaseUrl();
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)2L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL", doc).getLength());
        Assert.assertEquals((long)2L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL[@format='text/html']", doc).getLength());
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL[@type='19115']", doc).getLength());
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL[@type='FGDC']", doc).getLength());
        Assert.assertEquals((long)2L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL[text() = '" + proxyBaseUrl + "/metadata?key=value']", doc).getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOtherSRS() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.getSRS().add("EPSG:4326");
        wfs.getSRS().add("EPSG:3857");
        wfs.getSRS().add("EPSG:3003");
        try {
            this.getGeoServer().save((ServiceInfo)wfs);
            Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities");
            List enabledTypes = this.getCatalog().getFeatureTypes();
            for (FeatureTypeInfo ft : enabledTypes) {
                if (!ft.enabled()) continue;
                String prefixedName = ft.prefixedName();
                String base = "/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType[wfs:Name =\"" + prefixedName + "\"]";
                XMLAssert.assertXpathExists((String)base, (Document)doc);
                boolean wgs84Native = "EPSG:4326".equals(ft.getSRS());
                if (wgs84Native) {
                    XMLAssert.assertXpathEvaluatesTo((String)"2", (String)("count(" + base + "/wfs:OtherSRS)"), (Document)doc);
                } else {
                    XMLAssert.assertXpathEvaluatesTo((String)"3", (String)("count(" + base + "/wfs:OtherSRS)"), (Document)doc);
                    XMLAssert.assertXpathExists((String)(base + "[wfs:OtherSRS = 'urn:x-ogc:def:crs:EPSG:4326']"), (Document)doc);
                }
                XMLAssert.assertXpathExists((String)(base + "[wfs:OtherSRS = 'urn:x-ogc:def:crs:EPSG:3003']"), (Document)doc);
                XMLAssert.assertXpathExists((String)(base + "[wfs:OtherSRS = 'urn:x-ogc:def:crs:EPSG:3857']"), (Document)doc);
            }
        }
        finally {
            wfs.getSRS().clear();
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOtherSRSSingleTypeOverride() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.getSRS().add("EPSG:4326");
        wfs.getSRS().add("EPSG:3857");
        wfs.getSRS().add("EPSG:3003");
        String polygonsName = this.getLayerId(MockData.POLYGONS);
        FeatureTypeInfo polygons = this.getCatalog().getFeatureTypeByName(polygonsName);
        polygons.getResponseSRS().add("EPSG:32632");
        polygons.setOverridingServiceSRS(true);
        try {
            this.getGeoServer().save((ServiceInfo)wfs);
            this.getCatalog().save((ResourceInfo)polygons);
            Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=getCapabilities");
            String base = "/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType[wfs:Name =\"" + polygonsName + "\"]";
            XMLAssert.assertXpathExists((String)base, (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(" + base + "/wfs:OtherSRS)"), (Document)doc);
            XMLAssert.assertXpathExists((String)(base + "[wfs:OtherSRS = 'urn:x-ogc:def:crs:EPSG:32632']"), (Document)doc);
        }
        finally {
            wfs.getSRS().clear();
            this.getGeoServer().save((ServiceInfo)wfs);
            polygons.setOverridingServiceSRS(false);
            polygons.getResponseSRS().clear();
            this.getCatalog().save((ResourceInfo)polygons);
        }
    }

    @Test
    public void testGetSections() throws Exception {
        this.testSections("", 1, 1, 1, 1, 1);
        this.testSections("All", 1, 1, 1, 1, 1);
        this.testSections("ServiceIdentification", 1, 0, 0, 0, 0);
        this.testSections("ServiceProvider", 0, 1, 0, 0, 0);
        this.testSections("OperationsMetadata", 0, 0, 1, 0, 0);
        this.testSections("FeatureTypeList", 0, 0, 0, 1, 0);
        this.testSections("Filter_Capabilities", 0, 0, 0, 0, 1);
        this.testSections("ServiceIdentification,Filter_Capabilities", 1, 0, 0, 0, 1);
        this.testSections("ServiceIdentification,Filter_Capabilities,All", 1, 1, 1, 1, 1);
        Document dom = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetCapabilities&sections=FooBar");
        this.checkOws10Exception(dom, "InvalidParameterValue", "sections");
    }

    public void testSections(String sections, int serviceIdentification, int serviceProvider, int operationsMetadata, int featureTypeList, int filterCapabilities) throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetCapabilities&sections=" + sections);
        XMLAssert.assertXpathEvaluatesTo((String)("" + serviceIdentification), (String)"count(//ows:ServiceIdentification)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + serviceProvider), (String)"count(//ows:ServiceProvider)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + operationsMetadata), (String)"count(//ows:OperationsMetadata)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + featureTypeList), (String)"count(//wfs:FeatureTypeList)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + filterCapabilities), (String)"count(//ogc:Filter_Capabilities)", (Document)dom);
    }
}

