/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.io.File;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.util.IOUtils;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescribeFeatureTypeTest
extends WFSTestSupport {
    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        DataStoreInfo di = this.getCatalog().getDataStoreByName(CiteTestData.CITE_PREFIX);
        di.setEnabled(false);
        this.getCatalog().save((StoreInfo)di);
        File root = dataDirectory.getDataDirectoryRoot();
        File otherDir = new File(root, "workspaces/cdf/cdf/Other");
        otherDir.mkdirs();
        File otherSchema = new File(otherDir, "schema.xsd");
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("others.xsd"), (File)otherSchema);
    }

    @Test
    public void testDateMappings() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:sf=\"" + CiteTestData.PRIMITIVEGEOFEATURE.getNamespaceURI() + "\"> <wfs:TypeName>sf:" + CiteTestData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName></wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        NodeList elements = doc.getElementsByTagName("xsd:element");
        boolean date = false;
        boolean dateTime = false;
        for (int i = 0; i < elements.getLength(); ++i) {
            Element e = (Element)elements.item(i);
            if ("dateProperty".equals(e.getAttribute("name"))) {
                date = "xsd:date".equals(e.getAttribute("type"));
            }
            if (!"dateTimeProperty".equals(e.getAttribute("name"))) continue;
            dateTime = "xsd:dateTime".equals(e.getAttribute("type"));
        }
        Assert.assertTrue((boolean)date);
        Assert.assertTrue((boolean)dateTime);
    }

    @Test
    public void testNoNamespaceDeclaration() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:TypeName>sf:" + CiteTestData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName></wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testMultipleTypesImport() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:sf=\"" + CiteTestData.PRIMITIVEGEOFEATURE.getNamespaceURI() + "\"><wfs:TypeName>sf:" + CiteTestData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName><wfs:TypeName>sf:" + CiteTestData.GENERICENTITY.getLocalPart() + "</wfs:TypeName></wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        boolean seenComplexType = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("xsd:complexType")) {
                seenComplexType = true;
                continue;
            }
            if (!seenComplexType || !node.getNodeName().equals("xsd:import")) continue;
            Assert.fail((String)"All xsd:import must occur before all xsd:complexType");
        }
    }

    @Test
    public void testUerSuppliedTypeNameNamespace() throws Exception {
        QName typeName = CiteTestData.POLYGONS;
        String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=myPrefix:" + typeName.getLocalPart() + "&namespace=xmlns(myPrefix%3D" + URLEncoder.encode(typeName.getNamespaceURI(), "UTF-8") + ")";
        Document doc = this.getAsDOM(path);
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testUerSuppliedTypeNameDefaultNamespace() throws Exception {
        QName typeName = CiteTestData.POLYGONS;
        String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=" + typeName.getLocalPart() + "&namespace=xmlns(" + URLEncoder.encode(typeName.getNamespaceURI(), "UTF-8") + ")";
        Document doc = this.getAsDOM(path);
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testMissingNameNamespacePrefix() throws Exception {
        QName typeName = CiteTestData.POLYGONS;
        String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=" + typeName.getLocalPart();
        Document doc = this.getAsDOM(path);
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCiteCompliance() throws Exception {
        QName typeName = CiteTestData.STREAMS;
        Catalog catalog = this.getCatalog();
        NamespaceInfo defaultNs = catalog.getDefaultNamespace();
        GeoServer geoServer = this.getGeoServer();
        WFSInfo service = (WFSInfo)geoServer.getService(WFSInfo.class);
        try {
            catalog.setDefaultNamespace(catalog.getNamespaceByURI(typeName.getNamespaceURI()));
            FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
            typeInfo.setEnabled(true);
            catalog.save((ResourceInfo)typeInfo);
            DataStoreInfo store = typeInfo.getStore();
            store.setEnabled(true);
            catalog.save((StoreInfo)store);
            String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=" + typeName.getLocalPart();
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
            Document doc = this.getAsDOM(path);
            Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
            service.setCiteCompliant(true);
            geoServer.save((ServiceInfo)service);
            doc = this.getAsDOM(path);
            Assert.assertEquals((Object)"ows:ExceptionReport", (Object)doc.getDocumentElement().getNodeName());
        }
        finally {
            catalog.setDefaultNamespace(defaultNs);
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrefixedGetStrictCite() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        WFSInfo service = (WFSInfo)geoServer.getService(WFSInfo.class);
        try {
            service.setCiteCompliant(true);
            geoServer.save((ServiceInfo)service);
            QName typeName = CiteTestData.POLYGONS;
            String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=" + this.getLayerId(typeName);
            Document doc = this.getAsDOM(path);
            Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        }
        finally {
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
        }
    }

    @Test
    public void testGML32OutputFormat() throws Exception {
        Document dom = this.getAsDOM("ows?service=WFS&version=1.1.0&request=DescribeFeatureType&outputFormat=text/xml;+subtype%3Dgml/3.2&typename=" + this.getLayerId(CiteTestData.POLYGONS));
        this.print(dom);
    }

    @Test
    public void testGMLAttributeMapping() throws Exception {
        WFSInfo wfs = this.getWFS();
        GMLInfo gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_11);
        gml.setOverrideGMLAttributes(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wfs);
        Document dom = this.getAsDOM("ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typename=" + this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathNotExists((String)"//xsd:element[@name = 'name']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//xsd:element[@name = 'description']", (Document)dom);
        wfs = this.getWFS();
        gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_11);
        gml.setOverrideGMLAttributes(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wfs);
        wfs = this.getWFS();
        gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_11);
        Assert.assertTrue((boolean)gml.getOverrideGMLAttributes());
        dom = this.getAsDOM("ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typename=" + this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'name']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'description']", (Document)dom);
    }

    @Test
    public void testCustomSchema() throws Exception {
        Document dom = this.getAsDOM("ows?request=DescribeFeatureType&version=1.1.0&service=WFS&typeName=cdf:Other");
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'pointProperty']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'string1']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'string2']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//xsd:element[@name = 'integers']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//xsd:element[@name = 'dataTime']", (Document)dom);
    }

    @Test
    public void testNoWfsSchemaImport() throws Exception {
        String typeName = CiteTestData.POLYGONS.getLocalPart();
        String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=" + typeName;
        Document doc = this.getAsDOM(path);
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)("//xsd:complexType[@name='" + typeName + "Type']"), (Document)doc);
        XMLAssert.assertXpathExists((String)("//xsd:element[@name='" + typeName + "']"), (Document)doc);
        XMLAssert.assertXpathExists((String)"//xsd:import[@namespace='http://www.opengis.net/gml']", (Document)doc);
        XMLAssert.assertXpathNotExists((String)"//xsd:import[@namespace='http://www.opengis.net/wfs']", (Document)doc);
    }
}

