/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs.GetCapabilitiesType;
import net.opengis.wfs.WfsFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.util.ErrorHandler;
import org.geoserver.util.ReaderUtils;
import org.geoserver.wfs.CapabilitiesTransformer;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

public class CapabilitiesTransformerTest
extends WFSTestSupport {
    static Logger logger = Logging.getLogger((String)"org.geoserver.wfs.test");

    GetCapabilitiesType request() {
        GetCapabilitiesType type = WfsFactory.eINSTANCE.createGetCapabilitiesType();
        type.setBaseUrl("http://localhost:8080/geoserver");
        return type;
    }

    @Test
    public void test() throws Exception {
        GetCapabilitiesType request = this.request();
        CapabilitiesTransformer.WFS1_1 tx = new CapabilitiesTransformer.WFS1_1(this.getWFS(), request.getBaseUrl(), this.getCatalog(), Collections.emptyList());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)request, (OutputStream)output);
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(output.toByteArray()));
        File f = new File("../web/src/main/webapp/schemas/wfs/1.1.0/wfs.xsd");
        if (!f.exists()) {
            return;
        }
        ErrorHandler handler = new ErrorHandler(logger, Level.WARNING);
        ReaderUtils.validate((Reader)reader, (DefaultHandler)handler, (String)"http://www.opengis.net/wfs", (String)"../web/src/main/webapp/schemas/wfs/1.1.0/wfs.xsd");
        Assert.assertTrue((boolean)handler.errors.isEmpty());
    }

    @Test
    public void testDefaultOutputFormat() throws Exception {
        GetCapabilitiesType request = this.request();
        CapabilitiesTransformer.WFS1_1 tx = new CapabilitiesTransformer.WFS1_1(this.getWFS(), request.getBaseUrl(), this.getCatalog(), Collections.emptyList());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)request, (OutputStream)output);
        Document dom = super.dom((InputStream)new ByteArrayInputStream(output.toByteArray()));
        String expected = "text/xml; subtype=gml/3.1.1";
        String xpathExpr = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Operation[@name='DescribeFeatureType']/ows:Parameter[@name='outputFormat']/ows:Value";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/3.1.1", (String)xpathExpr, (Document)dom);
        xpathExpr = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Operation[@name='GetFeature']/ows:Parameter[@name='outputFormat']/ows:Value";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/3.1.1", (String)xpathExpr, (Document)dom);
        xpathExpr = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Operation[@name='GetFeatureWithLock']/ows:Parameter[@name='outputFormat']/ows:Value";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/3.1.1", (String)xpathExpr, (Document)dom);
        xpathExpr = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Operation[@name='Transaction']/ows:Parameter[@name='inputFormat']/ows:Value";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/3.1.1", (String)xpathExpr, (Document)dom);
    }

    @Test
    public void testContactInfo() throws Exception {
        GetCapabilitiesType request = this.request();
        CapabilitiesTransformer.WFS1_1 tx = new CapabilitiesTransformer.WFS1_1(this.getWFS(), request.getBaseUrl(), this.getCatalog(), Collections.emptyList());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)request, (OutputStream)output);
        Document dom = super.dom((InputStream)new ByteArrayInputStream(output.toByteArray()));
        String xpathExpr = "//wfs:WFS_Capabilities/ows:ServiceProvider/ows:ServiceContact/ows:IndividualName";
        XMLAssert.assertXpathExists((String)xpathExpr, (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Andrea Aime", (String)xpathExpr, (Document)dom);
        xpathExpr = "//wfs:WFS_Capabilities/ows:ServiceProvider/ows:ServiceContact/ows:ContactInfo/ows:Address/ows:DeliveryPoint";
        XMLAssert.assertXpathExists((String)xpathExpr, (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1600 Pennsylvania Ave NW, Washington DC 20500, United States", (String)xpathExpr, (Document)dom);
        xpathExpr = "//wfs:WFS_Capabilities/ows:ServiceProvider/ows:ServiceContact/ows:ContactInfo/ows:Address/ows:ElectronicMailAddress";
        XMLAssert.assertXpathExists((String)xpathExpr, (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"andrea@geoserver.org", (String)xpathExpr, (Document)dom);
    }
}

