/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.util.Collections;
import javax.xml.namespace.QName;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class BoundingBox3DTest
extends WFSTestSupport {
    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(false);
        this.getGeoServer().save((ServiceInfo)wfs);
        dataDirectory.addVectorLayer(new QName(SystemTestData.SF_URI, "With3D", SystemTestData.SF_PREFIX), Collections.EMPTY_MAP, ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testBBoxFeature1() throws Exception {
        Document doc = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:With3D&bbox=-200,-200,0,200,200,50");
        NodeList features = doc.getElementsByTagName("sf:With3D");
        Assert.assertEquals((long)1L, (long)features.getLength());
        Assert.assertEquals((Object)features.item(0).getAttributes().getNamedItem("gml:id").getNodeValue(), (Object)"fid1");
    }

    @Test
    public void testBBoxFeature2() throws Exception {
        Document doc = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:With3D&bbox=-200,-200,50,200,200,100");
        NodeList features = doc.getElementsByTagName("sf:With3D");
        Assert.assertEquals((long)1L, (long)features.getLength());
        Assert.assertEquals((Object)features.item(0).getAttributes().getNamedItem("gml:id").getNodeValue(), (Object)"fid2");
    }

    @Test
    public void testBBoxOnly2DCoordinates() throws Exception {
        Document doc = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:With3D&bbox=-200,-200,200,200,EPSG:4979");
        NodeList features = doc.getElementsByTagName("sf:With3D");
        Assert.assertEquals((long)3L, (long)features.getLength());
    }

    @Test
    public void testBBox3DCoordinatesExplicitCRS() throws Exception {
        Document doc = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:With3D&bbox=-200,-200,0,200,200,200,EPSG:4979");
        NodeList features = doc.getElementsByTagName("sf:With3D");
        Assert.assertEquals((long)3L, (long)features.getLength());
    }
}

