/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.WfsFactory;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.util.IOUtils;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.response.ShapeZipOutputFormat;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.springframework.mock.web.MockHttpServletResponse;

public class ShapeZipTest
extends WFSTestSupport {
    private static final QName ALL_TYPES = new QName(SystemTestData.CITE_URI, "AllTypes", SystemTestData.CITE_PREFIX);
    private static final QName ALL_DOTS = new QName(SystemTestData.CITE_URI, "All.Types.Dots", SystemTestData.CITE_PREFIX);
    private static final QName GEOMMID = new QName(SystemTestData.CITE_URI, "geommid", SystemTestData.CITE_PREFIX);
    private static final QName LONGNAMES = new QName(SystemTestData.CITE_URI, "longnames", SystemTestData.CITE_PREFIX);
    private static final QName NULLGEOM = new QName(SystemTestData.CITE_URI, "nullgeom", SystemTestData.CITE_PREFIX);
    private static final QName DOTS = new QName(SystemTestData.CITE_URI, "dots.in.name", SystemTestData.CITE_PREFIX);
    private Operation op;
    private GetFeatureType gft;

    @Before
    public void init() throws Exception {
        this.gft = WfsFactory.eINSTANCE.createGetFeatureType();
        this.op = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{this.gft});
    }

    @Before
    public void cleanupTemplates() throws Exception {
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName(SystemTestData.BASIC_POLYGONS.getPrefix());
        File wsDir = this.getDataDirectory().findWorkspaceDir(ws);
        new File(wsDir, "shapezip.ftl").delete();
        this.setupESRIFormatByDefault(this.getGeoServer(), false);
    }

    @Before
    public void resetServiceConfiguration() throws Exception {
        GeoServerInfo gs = this.getGeoServer().getGlobal();
        gs.getSettings().setProxyBaseUrl(null);
        this.getGeoServer().save(gs);
    }

    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        HashMap<SystemTestData.LayerProperty, Integer> params = new HashMap<SystemTestData.LayerProperty, Integer>();
        params.put(SystemTestData.LayerProperty.SRS, 4326);
        dataDirectory.addVectorLayer(ALL_TYPES, params, ShapeZipTest.class, this.getCatalog());
        dataDirectory.addVectorLayer(ALL_DOTS, params, ShapeZipTest.class, this.getCatalog());
        dataDirectory.addVectorLayer(GEOMMID, params, ShapeZipTest.class, this.getCatalog());
        dataDirectory.addVectorLayer(NULLGEOM, params, ShapeZipTest.class, this.getCatalog());
        dataDirectory.addVectorLayer(DOTS, params, ShapeZipTest.class, this.getCatalog());
        dataDirectory.addVectorLayer(LONGNAMES, params, ShapeZipTest.class, this.getCatalog());
    }

    @Test
    public void testNoNativeProjection() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(SystemTestData.BASIC_POLYGONS).getFeatures());
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(zip));
    }

    @Test
    public void testCharset() throws Exception {
        SimpleFeatureSource fs = this.getFeatureSource(SystemTestData.BASIC_POLYGONS);
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(fs.getFeatures());
        HashMap<String, Charset> options = new HashMap<String, Charset>();
        options.put("CHARSET", Charset.forName("ISO-8859-15"));
        this.gft.setFormatOptions(options);
        zip.write(fct, (OutputStream)bos, this.op);
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(bos.toByteArray()));
        Assert.assertEquals((Object)"ISO-8859-15", (Object)this.getCharset(new ByteArrayInputStream(bos.toByteArray())));
    }

    @Test
    public void testRequestUrlNoProxy() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?service=WFS&version=1.0.0&request=GetFeature&typeName=" + this.getLayerId(SystemTestData.BASIC_POLYGONS) + "&outputFormat=SHAPE-ZIP");
        Assert.assertEquals((Object)"application/zip", (Object)response.getContentType());
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, this.getBinaryInputStream(response));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/wfs?service=WFS&version=1.0.0&request=GetFeature&typeName=cite:BasicPolygons&outputFormat=SHAPE-ZIP", (Object)this.getRequest(this.getBinaryInputStream(response)));
    }

    @Test
    public void testRequestUrlWithProxyBase() throws Exception {
        GeoServerInfo gs = this.getGeoServer().getGlobal();
        gs.getSettings().setProxyBaseUrl("https://www.geoserver.org/geoserver");
        this.getGeoServer().save(gs);
        MockHttpServletResponse response = this.getAsServletResponse("wfs?service=WFS&version=1.0.0&request=GetFeature&typeName=" + this.getLayerId(SystemTestData.BASIC_POLYGONS) + "&outputFormat=SHAPE-ZIP");
        Assert.assertEquals((Object)"application/zip", (Object)response.getContentType());
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, this.getBinaryInputStream(response));
        Assert.assertEquals((Object)"https://www.geoserver.org/geoserver/wfs?service=WFS&version=1.0.0&request=GetFeature&typeName=cite:BasicPolygons&outputFormat=SHAPE-ZIP", (Object)this.getRequest(this.getBinaryInputStream(response)));
    }

    @Test
    public void testMultiType() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(ALL_TYPES).getFeatures());
        String[] expectedTypes = new String[]{"AllTypesPoint", "AllTypesMPoint", "AllTypesPolygon", "AllTypesLine"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    @Test
    public void testSplitSize() throws Exception {
        ShapeZipOutputFormat of = (ShapeZipOutputFormat)applicationContext.getBean("shapezipOutputFormat");
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(SystemTestData.BASIC_POLYGONS).getFeatures(), 500L, 500L);
        String shapefileName = SystemTestData.BASIC_POLYGONS.getLocalPart();
        String[] expectedTypes = new String[]{shapefileName, shapefileName + "1", shapefileName + "2"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
    }

    @Test
    public void testMultiTypeDots() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(ALL_DOTS).getFeatures());
        String[] expectedTypes = new String[]{"All_Types_DotsPoint", "All_Types_DotsMPoint", "All_Types_DotsPolygon", "All_Types_DotsLine"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    @Test
    public void testGeometryInTheMiddle() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(GEOMMID).getFeatures());
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    @Test
    public void testNullGeometries() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(NULLGEOM).getFeatures());
        String[] expectedTypes = new String[]{"nullgeom"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
    }

    @Test
    public void testLongNames() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(LONGNAMES).getFeatures());
        SimpleFeatureType schema = this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
        this.checkLongNamesSchema(schema);
        zip = this.writeOut((FeatureCollection)this.getFeatureSource(LONGNAMES).getFeatures());
        schema = this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
        this.checkLongNamesSchema(schema);
    }

    void checkLongNamesSchema(SimpleFeatureType schema) {
        Assert.assertEquals((long)4L, (long)schema.getAttributeCount());
        Assert.assertEquals((Object)"the_geom", (Object)schema.getDescriptor(0).getName().getLocalPart());
        Assert.assertEquals(MultiPolygon.class, (Object)schema.getDescriptor(0).getType().getBinding());
        Assert.assertEquals((Object)"FID", (Object)schema.getDescriptor(1).getName().getLocalPart());
        Assert.assertEquals((Object)"VERYLONGNA", (Object)schema.getDescriptor(2).getName().getLocalPart());
        Assert.assertEquals((Object)"VERYLONGN0", (Object)schema.getDescriptor(3).getName().getLocalPart());
    }

    public void testDots() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(DOTS).getFeatures());
        String[] expectedTypes = new String[]{"dots_in_name"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    @Test
    public void testEmptyResult() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(SystemTestData.BASIC_POLYGONS).getFeatures((Filter)Filter.EXCLUDE));
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(zip));
    }

    @Test
    public void testEmptyResultMultiGeom() throws Exception {
        ZipEntry entry;
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(ALL_DOTS).getFeatures((Filter)Filter.EXCLUDE));
        boolean foundReadme = false;
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));
        while ((entry = zis.getNextEntry()) != null) {
            foundReadme |= entry.getName().equals("README.TXT");
        }
        Assert.assertTrue((String)"Did not find readme file", (boolean)foundReadme);
    }

    @Test
    public void testTemplateSingleType() throws Exception {
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName(SystemTestData.BASIC_POLYGONS.getPrefix());
        this.getDataDirectory().copyToWorkspaceDir(ws, ((Object)((Object)this)).getClass().getResourceAsStream("shapeziptest.ftl"), "shapezip.ftl");
        SimpleFeatureCollection fc = this.getFeatureSource(SystemTestData.BASIC_POLYGONS).getFeatures((Filter)Filter.INCLUDE);
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(fc);
        Assert.assertEquals((Object)"shapezip_BasicPolygons.zip", (Object)zip.getAttachmentFileName((Object)fct, this.op));
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] zipBytes = bos.toByteArray();
        this.checkShapefileIntegrity(new String[]{"theshape_BasicPolygons"}, new ByteArrayInputStream(zipBytes));
    }

    @Test
    public void testTemplateMultiType() throws Exception {
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName(SystemTestData.BASIC_POLYGONS.getPrefix());
        this.getDataDirectory().copyToWorkspaceDir(ws, ((Object)((Object)this)).getClass().getResourceAsStream("shapeziptest.ftl"), "shapezip.ftl");
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(this.getFeatureSource(SystemTestData.BASIC_POLYGONS).getFeatures((Filter)Filter.INCLUDE));
        fct.getFeature().add(this.getFeatureSource(SystemTestData.BRIDGES).getFeatures((Filter)Filter.INCLUDE));
        Assert.assertEquals((Object)"shapezip_BasicPolygons.zip", (Object)zip.getAttachmentFileName((Object)fct, this.op));
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] zipBytes = bos.toByteArray();
        this.checkShapefileIntegrity(new String[]{"theshape_BasicPolygons", "theshape_Bridges"}, new ByteArrayInputStream(zipBytes));
    }

    @Test
    public void testTemplateMultiGeomType() throws Exception {
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName(ALL_DOTS.getPrefix());
        this.getDataDirectory().copyToWorkspaceDir(ws, ((Object)((Object)this)).getClass().getResourceAsStream("shapeziptest.ftl"), "shapezip.ftl");
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(this.getFeatureSource(ALL_DOTS).getFeatures((Filter)Filter.INCLUDE));
        Assert.assertEquals((Object)"shapezip_All_Types_Dots.zip", (Object)zip.getAttachmentFileName((Object)fct, this.op));
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] zipBytes = bos.toByteArray();
        this.checkShapefileIntegrity(new String[]{"theshape_All_Types_DotsPoint", "theshape_All_Types_DotsMPoint", "theshape_All_Types_DotsPolygon", "theshape_All_Types_DotsLine"}, new ByteArrayInputStream(zipBytes));
    }

    @Test
    public void testTemplatePOSTRequest10() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" outputFormat=\"shape-zip\" > <wfs:Query typeName=\"cdf:Other\"> </wfs:Query> </wfs:GetFeature>";
        MockHttpServletResponse response = this.postAsServletResponse("wfs", xml);
        Assert.assertEquals((Object)"application/zip", (Object)response.getContentType());
    }

    @Test
    public void testOutputZipFileNameSpecifiedInFormatOptions() throws Exception {
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat(this.getGeoServer(), this.getCatalog(), this.getResourceLoader());
        FeatureCollectionResponse mockResult = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        mockResult.getFeature().add(this.getFeatureSource(ALL_DOTS).getFeatures((Filter)Filter.INCLUDE));
        GetFeatureType mockRequest = WfsFactory.eINSTANCE.createGetFeatureType();
        Operation mockOperation = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{mockRequest});
        Assert.assertEquals((Object)"All_Types_Dots.zip", (Object)zip.getAttachmentFileName((Object)mockResult, mockOperation));
        mockRequest.getFormatOptions().put("FILENAME", "REQUEST_SUPPLIED_FILENAME.zip");
        Assert.assertEquals((Object)"REQUEST_SUPPLIED_FILENAME.zip", (Object)zip.getAttachmentFileName((Object)mockResult, mockOperation));
    }

    @Test
    public void testTemplatePOSTRequest11() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<GetFeature xmlns=\"http://www.opengis.net/wfs\" xmlns:DigitalGlobe=\"http://www.digitalglobe.com\"\n    xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:gml=\"http://www.opengis.net/gml\" service=\"WFS\" version=\"1.1.0\"\nxmlns:cdf=\"http://www.opengis.net/cite/data\"     outputFormat=\"shape-zip\" maxFeatures=\"100\" handle=\"\">\n    <Query typeName=\"cdf:Other\" srsName=\"urn:ogc:def:crs:EPSG::4326\"></Query> </GetFeature>";
        MockHttpServletResponse response = this.postAsServletResponse("wfs", xml);
        Assert.assertEquals((Object)"application/zip", (Object)response.getContentType());
    }

    @Test
    public void testESRIFormat() throws Exception {
        this.setupESRIPropertyFile();
        SimpleFeatureSource fs = this.getFeatureSource(SystemTestData.BASIC_POLYGONS);
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat(this.getGeoServer(), this.getCatalog(), this.getResourceLoader());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(fs.getFeatures());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("PRJFILEFORMAT", "ESRI");
        this.gft.setFormatOptions(options);
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] byteArrayZip = bos.toByteArray();
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(byteArrayZip));
        this.checkFileContent("BasicPolygons.prj", new ByteArrayInputStream(byteArrayZip), this.get4326_ESRI_WKTContent());
    }

    @Test
    public void testESRIFormatMultiType() throws Exception {
        this.setupESRIPropertyFile();
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat(this.getGeoServer(), this.getCatalog(), this.getResourceLoader());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(this.getFeatureSource(ALL_TYPES).getFeatures());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("PRJFILEFORMAT", "ESRI");
        this.gft.setFormatOptions(options);
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] byteArrayZip = bos.toByteArray();
        String[] expectedTypes = new String[]{"AllTypesPoint", "AllTypesMPoint", "AllTypesPolygon", "AllTypesLine"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(byteArrayZip));
        for (String fileName : expectedTypes) {
            this.checkFileContent(fileName + ".prj", new ByteArrayInputStream(byteArrayZip), this.get4326_ESRI_WKTContent());
        }
    }

    @Test
    public void testESRIFormatFromDefaultValue() throws Exception {
        this.setupESRIPropertyFile();
        GeoServer geoServer = this.getGeoServer();
        this.setupESRIFormatByDefault(geoServer, true);
        SimpleFeatureSource fs = this.getFeatureSource(SystemTestData.BASIC_POLYGONS);
        Catalog catalog = this.getCatalog();
        GeoServerResourceLoader resourceLoader = this.getResourceLoader();
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat(geoServer, catalog, resourceLoader);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(fs.getFeatures());
        HashMap options = new HashMap();
        this.gft.setFormatOptions(options);
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] byteArrayZip = bos.toByteArray();
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(byteArrayZip));
        this.checkFileContent("BasicPolygons.prj", new ByteArrayInputStream(byteArrayZip), this.get4326_ESRI_WKTContent());
    }

    byte[] writeOut(FeatureCollection fc, long maxShpSize, long maxDbfSize) throws IOException {
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        zip.setMaxDbfSize(maxDbfSize);
        zip.setMaxShpSize(maxShpSize);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(fc);
        zip.write(fct, (OutputStream)bos, this.op);
        return bos.toByteArray();
    }

    byte[] writeOut(FeatureCollection fc) throws IOException {
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(fc);
        zip.write(fct, (OutputStream)bos, this.op);
        return bos.toByteArray();
    }

    private File createTempFolder(String prefix) throws IOException {
        File temp = File.createTempFile(prefix, null);
        temp.delete();
        temp.mkdir();
        return temp;
    }

    private void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        int count = 0;
        byte[] buf = new byte[8192];
        while ((count = inStream.read(buf, 0, 8192)) != -1) {
            outStream.write(buf, 0, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleFeatureType checkFieldsAreNotEmpty(InputStream in) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        File tempFolder = this.createTempFolder("shp_");
        String shapeFileName = "";
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            String outName = tempFolder.getAbsolutePath() + File.separatorChar + name;
            if (name.toLowerCase().endsWith("shp")) {
                shapeFileName = outName;
            }
            FileOutputStream outFile = new FileOutputStream(outName);
            this.copyStream(zis, outFile);
            outFile.close();
            zis.closeEntry();
        }
        zis.close();
        File shapeFile = new File(shapeFileName);
        ShapefileDataStore ds = new ShapefileDataStore(shapeFile.toURL());
        ContentFeatureSource fs = ds.getFeatureSource();
        SimpleFeatureCollection fc = fs.getFeatures();
        SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
        SimpleFeatureIterator iter = fc.features();
        try {
            while (iter.hasNext()) {
                SimpleFeature f = (SimpleFeature)iter.next();
                for (Object attrValue : f.getAttributes()) {
                    Assert.assertNotNull(attrValue);
                    if (Geometry.class.isAssignableFrom(attrValue.getClass())) {
                        Assert.assertFalse((String)"Empty geometry", (boolean)((Geometry)attrValue).isEmpty());
                        continue;
                    }
                    Assert.assertFalse((String)"Empty value for attribute", (boolean)attrValue.toString().trim().equals(""));
                }
            }
        }
        finally {
            iter.close();
            ds.dispose();
            FileUtils.deleteQuietly((File)tempFolder);
        }
        return schema;
    }

    private void setupESRIPropertyFile() throws IOException {
        String esri_properties = "4326=" + this.get4326_ESRI_WKTContent();
        ByteArrayInputStream input = new ByteArrayInputStream(esri_properties.getBytes());
        File directory = this.getResourceLoader().findOrCreateDirectory("user_projections");
        File file = new File(directory, "esri.properties");
        if (file.exists()) {
            file.delete();
        }
        IOUtils.copy((InputStream)input, (File)file);
    }

    private void setupESRIFormatByDefault(GeoServer geoServer, Boolean value) throws IOException {
        WFSInfo wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
        MetadataMap metadata = wfsInfo.getMetadata();
        metadata.put("SHAPE-ZIP_DEFAULT_PRJ_IS_ESRI", (Serializable)value);
        geoServer.save((ServiceInfo)wfsInfo);
    }

    private void checkShapefileIntegrity(String[] typeNames, InputStream in) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        String[] extensions = new String[]{".shp", ".shx", ".dbf", ".prj", ".cst"};
        HashSet<String> names = new HashSet<String>();
        for (String name : typeNames) {
            for (String extension : extensions) {
                names.add(name + extension);
            }
        }
        HashSet<String> found = new HashSet<String>();
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            found.add(name);
            if (name.toLowerCase().endsWith(".txt")) continue;
            Assert.assertTrue((String)("Unexpected " + name), (boolean)names.contains(name));
            names.remove(name);
            zis.closeEntry();
        }
        Assert.assertTrue((String)("Could not find all expected files, missing ones are: " + names + "\nFound in zip are: " + found), (boolean)names.isEmpty());
        zis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileContent(String fileName, InputStream zippedIn, String expectedContent) throws IOException {
        ZipEntry entry = null;
        try (ZipInputStream zis = new ZipInputStream(zippedIn);){
            while ((entry = zis.getNextEntry()) != null) {
                try {
                    String name = entry.getName();
                    if (!name.toLowerCase().endsWith(fileName.toLowerCase())) continue;
                    String unzippedFileContents = org.apache.commons.io.IOUtils.toString((InputStream)zis);
                    Assert.assertEquals((Object)expectedContent, (Object)unzippedFileContents);
                    return;
                }
                finally {
                    zis.closeEntry();
                }
            }
        }
        Assert.fail((String)(fileName + " was not found in the provided stream"));
    }

    private String getCharset(InputStream in) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        byte[] bytes = new byte[1024];
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().endsWith(".cst")) continue;
            zis.read(bytes);
        }
        zis.close();
        if (bytes == null) {
            return null;
        }
        return new String(bytes).trim();
    }

    private String getRequest(InputStream in) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        byte[] bytes = new byte[1024];
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().endsWith(".txt")) continue;
            zis.read(bytes);
        }
        zis.close();
        if (bytes == null) {
            return null;
        }
        return new String(bytes).trim();
    }

    private String get4326_ESRI_WKTContent() {
        return "GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]]";
    }

    @Test
    public void testPointZMShp() throws Exception {
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureType featureType = DataUtilities.createType((String)"pointmz", (String)"name:String,geom:Point:4326");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(featureType);
        fb.add((Object)"point1");
        fb.add((Object)gf.createPoint((Coordinate)new CoordinateXYZM(1.0, 2.0, 3.0, 4.0)));
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        features.add(fb.buildFeature("1"));
        SimpleFeatureCollection featureCollection = DataUtilities.collection(features);
        byte[] zipBytes = this.writeOut((FeatureCollection)featureCollection);
        byte[] resultBytes = this.getShpOnlyBytes(zipBytes);
        InputStream resource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/geoserver/wfs/response/pointZm.shp");
        byte[] expectedBytes = org.apache.commons.io.IOUtils.toByteArray((InputStream)resource);
        resource.close();
        Assert.assertTrue((boolean)Arrays.equals(resultBytes, expectedBytes));
    }

    @Test
    public void testMultiPointZMShp() throws Exception {
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureType featureType = DataUtilities.createType((String)"multipointmz", (String)"name:String,geom:MultiPoint:4326");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(featureType);
        fb.add((Object)"points1");
        fb.add((Object)gf.createMultiPoint(new Point[]{gf.createPoint((Coordinate)new CoordinateXYZM(1.0, 2.0, 3.0, 4.0)), gf.createPoint((Coordinate)new CoordinateXYZM(5.0, 6.0, 7.0, 8.0))}));
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        features.add(fb.buildFeature("1"));
        SimpleFeatureCollection featureCollection = DataUtilities.collection(features);
        byte[] zipBytes = this.writeOut((FeatureCollection)featureCollection);
        byte[] resultBytes = this.getShpOnlyBytes(zipBytes);
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/geoserver/wfs/response/multiPointZm.shp");
        byte[] expectedBytes = org.apache.commons.io.IOUtils.toByteArray((InputStream)in);
        in.close();
        Assert.assertTrue((boolean)Arrays.equals(resultBytes, expectedBytes));
    }

    @Test
    public void testMultiLineStringZMShp() throws Exception {
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureType featureType = DataUtilities.createType((String)"linestringmz", (String)"name:String,geom:MultiLineString:4326");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(featureType);
        fb.add((Object)"line1");
        fb.add((Object)gf.createMultiLineString(new LineString[]{gf.createLineString((Coordinate[])new CoordinateXYZM[]{new CoordinateXYZM(1.0, 2.0, 3.0, 4.0), new CoordinateXYZM(5.0, 6.0, 7.0, 8.0)})}));
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        features.add(fb.buildFeature("1"));
        SimpleFeatureCollection featureCollection = DataUtilities.collection(features);
        byte[] zipBytes = this.writeOut((FeatureCollection)featureCollection);
        byte[] resultBytes = this.getShpOnlyBytes(zipBytes);
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/geoserver/wfs/response/lineStringZm.shp");
        byte[] expectedBytes = org.apache.commons.io.IOUtils.toByteArray((InputStream)is);
        is.close();
        Assert.assertTrue((boolean)Arrays.equals(resultBytes, expectedBytes));
    }

    @Test
    public void testMultiPolygonZMShp() throws Exception {
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureType featureType = DataUtilities.createType((String)"polygonmz", (String)"name:String,geom:MultiPolygon:4326");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(featureType);
        fb.add((Object)"polygon1");
        fb.add((Object)gf.createMultiPolygon(new Polygon[]{gf.createPolygon((Coordinate[])new CoordinateXYZM[]{new CoordinateXYZM(0.0, 0.0, 3.0, 1.0), new CoordinateXYZM(1.0, 1.0, 7.0, 2.0), new CoordinateXYZM(1.0, 0.0, 7.0, 3.0), new CoordinateXYZM(0.0, 0.0, 3.0, 1.0)})}));
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        features.add(fb.buildFeature("1"));
        SimpleFeatureCollection featureCollection = DataUtilities.collection(features);
        byte[] zipBytes = this.writeOut((FeatureCollection)featureCollection);
        byte[] resultBytes = this.getShpOnlyBytes(zipBytes);
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/geoserver/wfs/response/polygonZm.shp");
        byte[] expectedBytes = org.apache.commons.io.IOUtils.toByteArray((InputStream)in);
        Assert.assertTrue((boolean)Arrays.equals(resultBytes, expectedBytes));
    }

    private byte[] getShpOnlyBytes(byte[] zipBytes) throws IOException {
        byte[] resultBytes = new byte[]{};
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zipBytes));
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            if (!name.toLowerCase().endsWith(".shp")) continue;
            resultBytes = org.apache.commons.io.IOUtils.toByteArray((InputStream)zis);
        }
        zis.close();
        return resultBytes;
    }
}

