/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.util.Collections;
import javax.xml.namespace.QName;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public final class GeoJsonOutputFormatTest
extends WFSTestSupport {
    private static final QName LINESTRING_ZM = new QName(MockData.DEFAULT_URI, "lineStringZm", MockData.DEFAULT_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(LINESTRING_ZM, Collections.emptyMap(), "lineStringZm.properties", GeoJsonOutputFormatTest.class, this.getCatalog());
    }

    @Before
    public void beforeTest() {
        GeoJsonOutputFormatTest.setMeasuresEncoding(this.getCatalog(), LINESTRING_ZM.getLocalPart(), false);
    }

    @Test
    public void testMeasuresEncoding() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetFeature&typenames=gs:lineStringZm&version=2.0.0&service=wfs&outputFormat=application/json");
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)"[[120,50,20],[90,80,35]]"));
        GeoJsonOutputFormatTest.setMeasuresEncoding(this.getCatalog(), LINESTRING_ZM.getLocalPart(), true);
        response = this.getAsServletResponse("wfs?request=GetFeature&typenames=gs:lineStringZm&version=2.0.0&service=wfs&outputFormat=application/json");
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)"[[120,50,20,15],[90,80,35,5]]"));
    }
}

