/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import au.com.bytecode.opencsv.CSVReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.response.CSVOutputFormat;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.DateUtil;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.springframework.mock.web.MockHttpServletResponse;

public class CSVOutputFormatTest
extends WFSTestSupport {
    @Test
    public void testFullRequest() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?version=1.1.0&request=GetFeature&typeName=sf:PrimitiveGeoFeature&outputFormat=csv", "");
        SimpleFeatureSource fs = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        Assert.assertEquals((Object)"text/csv", (Object)resp.getContentType());
        Assert.assertEquals((Object)"UTF-8", (Object)resp.getCharacterEncoding());
        Assert.assertEquals((Object)"attachment; filename=PrimitiveGeoFeature.csv", (Object)resp.getHeader("Content-Disposition"));
        List<String[]> lines = this.readLines(resp.getContentAsString());
        Assert.assertEquals((long)(fs.getCount(Query.ALL) + 1), (long)lines.size());
        for (String[] line : lines) {
            Assert.assertEquals((long)(fs.getSchema().getDescriptors().size() + 1), (long)line.length);
        }
    }

    @Test
    public void testEscapes() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("geom", Point.class);
        builder.add("label", String.class);
        builder.add("dtg", Date.class);
        builder.add("n", Integer.class);
        builder.add("d", Double.class);
        builder.setName("funnyLabels");
        SimpleFeatureType type = builder.buildFeatureType();
        Date d = new SimpleDateFormat("yyyy-MM-dd").parse("2016-01-01");
        GeometryFactory gf = new GeometryFactory();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 8.0)), "A label with \"quotes\"", d, 10, 100.0}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 4.0)), "A long label\nwith newlines", d, 10, 200.0}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 4.0)), "A long label\r\nwith windows\r\nnewlines", d, 10, 300.0}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f1);
        data.addFeature(f2);
        data.addFeature(f3);
        ContentFeatureSource fs = data.getFeatureSource("funnyLabels");
        GetFeatureType gft = WfsFactory.eINSTANCE.createGetFeatureType();
        Operation op = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{gft});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionResponse fct = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fct.getFeature().add(fs.getFeatures());
        CSVOutputFormat format = new CSVOutputFormat(this.getGeoServer());
        format.write(fct, (OutputStream)bos, op);
        List<String[]> lines = this.readLines(bos.toString());
        Assert.assertEquals((long)(fs.getCount(Query.ALL) + 1), (long)lines.size());
        for (String[] line : lines) {
            Assert.assertEquals((long)(((SimpleFeatureType)fs.getSchema()).getAttributeCount() + 1), (long)line.length);
        }
        Assert.assertEquals((Object)f1.getAttribute("label"), (Object)lines.get(1)[2]);
        Assert.assertEquals((Object)f2.getAttribute("label"), (Object)lines.get(2)[2]);
        Assert.assertEquals((Object)((String)f3.getAttribute("label")).replace("\r\n", "\n"), (Object)lines.get(3)[2]);
        Assert.assertEquals((Object)DateUtil.serializeDateTime((Date)((Date)f1.getAttribute("dtg"))), (Object)lines.get(1)[3]);
        Assert.assertEquals((Object)f1.getAttribute("n"), (Object)Integer.parseInt(lines.get(1)[4]));
        Assert.assertEquals((Object)f2.getAttribute("d"), (Object)Double.parseDouble(lines.get(2)[5]));
    }

    private List<String[]> readLines(String csvContent) throws IOException {
        String[] nextLine;
        CSVReader reader = new CSVReader((Reader)new StringReader(csvContent));
        ArrayList<String[]> result = new ArrayList<String[]>();
        while ((nextLine = reader.readNext()) != null) {
            result.add(nextLine);
        }
        return result;
    }
}

