/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.common.util.EList;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.kvp.GetFeatureKvpRequestReader;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;

public class GetFeatureKvpRequestReaderTest
extends GeoServerSystemTestSupport {
    private static GetFeatureKvpRequestReader reader;

    protected void onSetUp(SystemTestData data) throws Exception {
        reader = new GetFeatureKvpRequestReader(GetFeatureType.class, this.getGeoServer(), CommonFactoryFinder.getFilterFactory(null));
    }

    @Test
    public void testInvalidTypeNameBbox() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("bbox", "-80.4864795578115,25.6176257083275,-80.3401307394915,25.7002737069969");
        raw.put("typeName", "cite:InvalidTypeName");
        Map parsed = this.parseKvp(raw);
        try {
            reader.read((Object)WfsFactory.eINSTANCE.createGetFeatureType(), parsed, raw);
        }
        catch (WFSException e) {
            Assert.assertEquals((Object)"InvalidParameterValue", (Object)e.getCode());
            Assert.assertEquals((Object)"typeName", (Object)e.getLocator());
            System.out.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("cite:InvalidTypeName"));
        }
    }

    @Test
    public void testInvalidTypeName() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", "InvalidTypeName");
        try {
            Map parsed = this.parseKvp(raw);
            reader.read((Object)WfsFactory.eINSTANCE.createGetFeatureType(), parsed, raw);
        }
        catch (WFSException e) {
            Assert.assertEquals((Object)"InvalidParameterValue", (Object)e.getCode());
            Assert.assertEquals((Object)"typeName", (Object)e.getLocator());
            Assert.assertTrue((boolean)e.getMessage().contains("InvalidTypeName"));
        }
    }

    @Test
    public void testUserProvidedNamespace() throws Exception {
        String localPart = SystemTestData.MLINES.getLocalPart();
        String namespace = SystemTestData.MLINES.getNamespaceURI();
        String alternamePrefix = "ex";
        String alternameTypeName = "ex:" + localPart;
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", alternameTypeName);
        raw.put("namespace", "xmlns(ex=" + namespace + ")");
        Map parsed = this.parseKvp(raw);
        GetFeatureType req = WfsFactory.eINSTANCE.createGetFeatureType();
        Object read = reader.read((Object)req, parsed, raw);
        GetFeatureType parsedReq = (GetFeatureType)read;
        QueryType query = (QueryType)parsedReq.getQuery().get(0);
        List typeNames = query.getTypeName();
        Assert.assertEquals((long)1L, (long)typeNames.size());
        Assert.assertEquals((Object)SystemTestData.MLINES, typeNames.get(0));
    }

    @Test
    public void testUserProvidedDefaultNamespace() throws Exception {
        QName qName = SystemTestData.STREAMS;
        String typeName = qName.getLocalPart();
        String defaultNamespace = qName.getNamespaceURI();
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", typeName);
        raw.put("namespace", "xmlns(" + defaultNamespace + ")");
        Map parsed = this.parseKvp(raw);
        GetFeatureType req = WfsFactory.eINSTANCE.createGetFeatureType();
        Object read = reader.read((Object)req, parsed, raw);
        GetFeatureType parsedReq = (GetFeatureType)read;
        QueryType query = (QueryType)parsedReq.getQuery().get(0);
        List typeNames = query.getTypeName();
        Assert.assertEquals((long)1L, (long)typeNames.size());
        Assert.assertEquals((Object)qName, typeNames.get(0));
    }

    @Test
    public void testViewParams() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", this.getLayerId(SystemTestData.STREAMS));
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD");
        Map parsed = this.parseKvp(raw);
        GetFeatureType req = WfsFactory.eINSTANCE.createGetFeatureType();
        Object read = reader.read((Object)req, parsed, raw);
        GetFeatureType parsedReq = (GetFeatureType)read;
        Assert.assertEquals((long)1L, (long)parsedReq.getViewParams().size());
        EList viewParams = parsedReq.getViewParams();
        Assert.assertEquals((long)1L, (long)viewParams.size());
        Map vp1 = (Map)viewParams.get(0);
        Assert.assertEquals((Object)"WHERE PERSONS > 1000000", vp1.get("where"));
        Assert.assertEquals((Object)"ABCD", vp1.get("str"));
    }

    @Test
    public void testViewParamsMulti() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", this.getLayerId(SystemTestData.STREAMS) + "," + this.getLayerId(SystemTestData.BASIC_POLYGONS));
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD,where:WHERE PERSONS > 10;str:FOO");
        Map parsed = this.parseKvp(raw);
        GetFeatureType req = WfsFactory.eINSTANCE.createGetFeatureType();
        Object read = reader.read((Object)req, parsed, raw);
        GetFeatureType parsedReq = (GetFeatureType)read;
        EList viewParams = parsedReq.getViewParams();
        Assert.assertEquals((long)2L, (long)viewParams.size());
        Map vp1 = (Map)viewParams.get(0);
        Assert.assertEquals((Object)"WHERE PERSONS > 1000000", vp1.get("where"));
        Assert.assertEquals((Object)"ABCD", vp1.get("str"));
        Map vp2 = (Map)viewParams.get(1);
        Assert.assertEquals((Object)"WHERE PERSONS > 10", vp2.get("where"));
        Assert.assertEquals((Object)"FOO", vp2.get("str"));
    }

    @Test
    public void testViewParamsFanOut() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", this.getLayerId(SystemTestData.STREAMS) + "," + this.getLayerId(SystemTestData.BASIC_POLYGONS));
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD");
        Map parsed = this.parseKvp(raw);
        GetFeatureType req = WfsFactory.eINSTANCE.createGetFeatureType();
        Object read = reader.read((Object)req, parsed, raw);
        GetFeatureType parsedReq = (GetFeatureType)read;
        EList viewParams = parsedReq.getViewParams();
        Assert.assertEquals((long)2L, (long)viewParams.size());
        Map vp1 = (Map)viewParams.get(0);
        Assert.assertEquals((Object)"WHERE PERSONS > 1000000", vp1.get("where"));
        Assert.assertEquals((Object)"ABCD", vp1.get("str"));
        Map vp2 = (Map)viewParams.get(1);
        Assert.assertEquals((Object)"WHERE PERSONS > 1000000", vp2.get("where"));
        Assert.assertEquals((Object)"ABCD", vp2.get("str"));
    }
}

