/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.util.HashMap;
import junit.framework.TestCase;
import org.geoserver.wfs.json.JSONType;
import org.junit.Test;

public class JSONTypeTest
extends TestCase {
    @Test
    public void testMimeType() {
        JSONTypeTest.assertNotSame((Object)"application/json", (Object)"text/javascript");
        JSONTypeTest.assertTrue((boolean)JSONType.isJsonMimeType((String)"application/json"));
        JSONType.setJsonpEnabled((boolean)true);
        JSONTypeTest.assertTrue((boolean)JSONType.useJsonp((String)"text/javascript"));
        JSONType.setJsonpEnabled((boolean)false);
        JSONTypeTest.assertFalse((boolean)JSONType.useJsonp((String)"text/javascript"));
    }

    @Test
    public void testJSONType() {
        JSONType json = JSONType.JSON;
        JSONTypeTest.assertEquals((Object)JSONType.JSON, (Object)json);
        JSONType jsonp = JSONType.JSONP;
        JSONTypeTest.assertEquals((Object)JSONType.JSONP, (Object)jsonp);
        JSONTypeTest.assertEquals((Object)JSONType.JSON, (Object)JSONType.getJSONType((String)"application/json"));
        JSONTypeTest.assertEquals((Object)JSONType.JSONP, (Object)JSONType.getJSONType((String)"text/javascript"));
    }

    @Test
    public void testCallbackFunction() {
        HashMap kvp = new HashMap();
        JSONTypeTest.assertEquals((String)"parseResponse", (String)JSONType.getCallbackFunction(kvp));
        HashMap<String, String> formatOpts = new HashMap<String, String>();
        kvp.put("FORMAT_OPTIONS", formatOpts);
        JSONTypeTest.assertEquals((String)"parseResponse", (String)JSONType.getCallbackFunction(kvp));
        formatOpts.put("callback", "functionName");
        JSONTypeTest.assertEquals((String)"functionName", (String)JSONType.getCallbackFunction(kvp));
    }
}

