/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.util.IOUtils;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.json.JSONType;
import org.geotools.referencing.CRS;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.mock.web.MockHttpServletResponse;

public class GeoJSONTest
extends WFSTestSupport {
    public static QName LINE3D = new QName(SystemTestData.CITE_URI, "Line3D", SystemTestData.CITE_PREFIX);
    public static QName POINT_LATLON = new QName(SystemTestData.CITE_URI, "PointLatLon", SystemTestData.CITE_PREFIX);
    public static QName POINT_LONLAT = new QName(SystemTestData.CITE_URI, "PointLonLat", SystemTestData.CITE_PREFIX);
    public static QName MULTI_GEOMETRIES_WITH_NULL = new QName(SystemTestData.CITE_URI, "MultiGeometriesWithNull", SystemTestData.CITE_PREFIX);
    public static QName POINT_REDUCED = new QName(SystemTestData.CITE_URI, "PointReduced", SystemTestData.CITE_PREFIX);

    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        super.setUpInternal(data);
        File security = new File(((SystemTestData)this.getTestData()).getDataDirectoryRoot(), "security");
        security.mkdir();
        File layers = new File(security, "layers.properties");
        IOUtils.copy((InputStream)GeoJSONTest.class.getResourceAsStream("layers_ro.properties"), (File)layers);
        data.addVectorLayer(LINE3D, Collections.EMPTY_MAP, ((Object)((Object)this)).getClass(), this.getCatalog());
        data.addVectorLayer(POINT_LATLON, Collections.EMPTY_MAP, ((Object)((Object)this)).getClass(), this.getCatalog());
        CoordinateReferenceSystem crsLatLon = CRS.decode((String)"urn:ogc:def:crs:EPSG::4326");
        FeatureTypeInfo pointLatLon = this.getCatalog().getFeatureTypeByName(POINT_LATLON.getPrefix(), POINT_LATLON.getLocalPart());
        pointLatLon.setNativeCRS(crsLatLon);
        pointLatLon.setSRS("urn:ogc:def:crs:EPSG::4326");
        pointLatLon.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        this.getCatalog().save((ResourceInfo)pointLatLon);
        data.addVectorLayer(POINT_LONLAT, Collections.EMPTY_MAP, ((Object)((Object)this)).getClass(), this.getCatalog());
        CoordinateReferenceSystem crsLonLat = CRS.decode((String)"EPSG:4326", (boolean)true);
        FeatureTypeInfo pointLonLat = this.getCatalog().getFeatureTypeByName(POINT_LONLAT.getPrefix(), POINT_LONLAT.getLocalPart());
        pointLatLon.setNativeCRS(crsLonLat);
        pointLatLon.setSRS("EPSG:4326");
        pointLatLon.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        this.getCatalog().save((ResourceInfo)pointLonLat);
        data.addVectorLayer(MULTI_GEOMETRIES_WITH_NULL, Collections.EMPTY_MAP, ((Object)((Object)this)).getClass(), this.getCatalog());
        data.addVectorLayer(POINT_REDUCED, Collections.EMPTY_MAP, ((Object)((Object)this)).getClass(), this.getCatalog());
        FeatureTypeInfo pointReduced = this.getCatalog().getFeatureTypeByName(POINT_REDUCED.getPrefix(), POINT_REDUCED.getLocalPart());
        pointReduced.setNativeCRS(crsLatLon);
        pointReduced.setSRS("EPSG:4326");
        pointReduced.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        pointReduced.setNumDecimals(2);
        this.getCatalog().save((ResourceInfo)pointReduced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureBoundingDisabledCollection() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = this.getWFS();
        boolean before = wfs.isFeatureBounding();
        wfs.setFeatureBounding(false);
        try {
            gs.save((ServiceInfo)wfs);
            String out = this.getAsString("wfs?request=GetFeature&version=1.0.0&typename=sf:AggregateGeoFeature&maxfeatures=3&outputformat=application/json");
            JSONObject rootObject = JSONObject.fromObject((Object)out);
            JSONObject bbox = rootObject.getJSONObject("bbox");
            Assert.assertEquals((Object)JSONNull.getInstance(), (Object)bbox);
        }
        finally {
            wfs.setFeatureBounding(before);
            gs.save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testGet() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=1&outputformat=application/json");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        String out = response.getContentAsString();
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"surfaceProperty");
        String timeStamp = rootObject.getString("timeStamp");
        Assert.assertNotNull((Object)timeStamp);
        Assert.assertTrue((boolean)timeStamp.matches("(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2})\\:(\\d{2})\\:(\\d{2})\\.(\\d{3})Z"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSkipCounting() throws Exception {
        FeatureTypeInfo primitive;
        Catalog catalog = this.getCatalog();
        try {
            primitive = catalog.getFeatureTypeByName(this.getLayerId(MockData.PRIMITIVEGEOFEATURE));
            primitive.setSkipNumberMatched(true);
            catalog.save((ResourceInfo)primitive);
            MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetFeature&version=2.0.0&typename=sf:PrimitiveGeoFeature&outputformat=application/json");
            Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
            String out = response.getContentAsString();
            JSONObject rootObject = JSONObject.fromObject((Object)out);
            Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
            JSONArray featureCol = rootObject.getJSONArray("features");
            JSONObject aFeature = featureCol.getJSONObject(0);
            Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"surfaceProperty");
        }
        finally {
            primitive = catalog.getFeatureTypeByName(this.getLayerId(MockData.PRIMITIVEGEOFEATURE));
            primitive.setSkipNumberMatched(false);
            catalog.save((ResourceInfo)primitive);
        }
    }

    @Test
    public void testGetSimpleJson() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=1&outputformat=json", "");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((Object)"UTF-8", (Object)response.getCharacterEncoding());
        String out = response.getContentAsString();
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"surfaceProperty");
    }

    @Test
    public void testGetJsonIdPolicyTrue() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=1&outputformat=json&format_options=id_policy:true");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        String out = response.getContentAsString();
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertTrue((String)"id", (boolean)aFeature.containsKey((Object)"id"));
        Object id = aFeature.get("id");
        Assert.assertNotNull((String)"id", (Object)id);
        Assert.assertEquals((Object)"PrimitiveGeoFeature.f001", (Object)id);
    }

    @Test
    public void testGetJsonIdPolicyFalse() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=1&outputformat=json&format_options=id_policy:false");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        String out = response.getContentAsString();
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertFalse((String)"supress id", (boolean)aFeature.containsKey((Object)"id"));
    }

    @Test
    public void testGetJsonIdPolicyAttribute() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=1&outputformat=json&format_options=id_policy:name");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        String out = response.getContentAsString();
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertTrue((String)"id", (boolean)aFeature.containsKey((Object)"id"));
        Object id = aFeature.get("id");
        Assert.assertNotNull((String)"id", (Object)id);
        Assert.assertEquals((Object)"name-f001", (Object)id);
        JSONObject properties = aFeature.getJSONObject("properties");
        Assert.assertFalse((boolean)properties.containsKey((Object)"name"));
    }

    @Test
    public void testPost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" outputFormat=\"application/json\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\"> </wfs:Query> </wfs:GetFeature>";
        String out = this.postAsServletResponse("wfs", xml).getContentAsString();
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"surfaceProperty");
    }

    @Test
    public void testGeometryCollection() throws Exception {
        String out = this.getAsString("wfs?request=GetFeature&version=1.0.0&typename=sf:AggregateGeoFeature&maxfeatures=3&outputformat=application/json");
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(1);
        JSONObject aPropeties = aFeature.getJSONObject("properties");
        JSONObject aGeometry = aPropeties.getJSONObject("multiCurveProperty");
        Assert.assertEquals((Object)aGeometry.getString("type"), (Object)"MultiLineString");
        JSONArray geomArray = aGeometry.getJSONArray("coordinates");
        geomArray = geomArray.getJSONArray(0);
        geomArray = geomArray.getJSONArray(0);
        Assert.assertEquals((Object)geomArray.getString(0), (Object)"55.174");
        CoordinateReferenceSystem expectedCrs = this.getCatalog().getLayerByName(this.getLayerId(SystemTestData.AGGREGATEGEOFEATURE)).getResource().getCRS();
        JSONObject aCRS = rootObject.getJSONObject("crs");
        Assert.assertThat((Object)aCRS.getString("type"), (Matcher)Matchers.equalTo((Object)"name"));
        Assert.assertThat((Object)aCRS, this.encodesCRS(expectedCrs));
    }

    @Test
    public void testMixedCollection() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" outputFormat=\"application/json\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\" /> <wfs:Query typeName=\"sf:AggregateGeoFeature\" /> </wfs:GetFeature>";
        String out = this.postAsServletResponse("wfs", xml).getContentAsString();
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(1);
        Assert.assertTrue((boolean)aFeature.getString("id").substring(0, 19).equalsIgnoreCase("PrimitiveGeoFeature"));
        aFeature = featureCol.getJSONObject(6);
        Assert.assertTrue((boolean)aFeature.getString("id").substring(0, 19).equalsIgnoreCase("AggregateGeoFeature"));
        JSONObject aProperties = aFeature.getJSONObject("properties");
        JSONObject aGeometry = aProperties.getJSONObject("multiCurveProperty");
        Assert.assertEquals((Object)aGeometry.getString("type"), (Object)"MultiLineString");
    }

    @Test
    public void testCallbackFunction() throws Exception {
        JSONType.setJsonpEnabled((boolean)true);
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=1&outputformat=text/javascript&format_options=callback:myFunc");
        JSONType.setJsonpEnabled((boolean)false);
        String out = resp.getContentAsString();
        Assert.assertEquals((Object)"text/javascript", (Object)resp.getContentType());
        Assert.assertTrue((boolean)out.startsWith("myFunc("));
        Assert.assertTrue((boolean)out.endsWith(")"));
        out = out.substring(7, out.length() - 1);
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"surfaceProperty");
    }

    @Test
    public void testGetFeatureCountNoFilter() throws Exception {
        String out = this.getAsString("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=10&outputformat=application/json");
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("totalFeatures"), (Object)5);
    }

    @Test
    public void testGetFeatureCountFilter() throws Exception {
        String out2 = this.getAsString("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=10&outputformat=application/json&featureid=PrimitiveGeoFeature.f001");
        JSONObject rootObject2 = JSONObject.fromObject((Object)out2);
        Assert.assertEquals((Object)rootObject2.get("totalFeatures"), (Object)1);
    }

    @Test
    public void testGetFeatureCountMaxFeatures() throws Exception {
        String out3 = this.getAsString("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=1&outputformat=application/json&featureid=PrimitiveGeoFeature.f001,PrimitiveGeoFeature.f002");
        JSONObject rootObject3 = JSONObject.fromObject((Object)out3);
        Assert.assertEquals((Object)rootObject3.get("totalFeatures"), (Object)2);
    }

    @Test
    public void testGetFeatureCountMultipleFeatureTypes() throws Exception {
        String out4 = this.getAsString("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature,sf:AggregateGeoFeature&outputformat=application/json&featureid=PrimitiveGeoFeature.f001,PrimitiveGeoFeature.f002,AggregateGeoFeature.f009");
        JSONObject rootObject4 = JSONObject.fromObject((Object)out4);
        Assert.assertEquals((Object)rootObject4.get("totalFeatures"), (Object)3);
    }

    @Test
    public void testGetFeatureCountSpatialFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" outputFormat=\"application/json\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"sf:AggregateGeoFeature\" srsName=\"EPSG:900913\"> <ogc:Filter xmlns:ogc=\"http://www.opengis.net/ogc\"> <ogc:Intersects> <ogc:PropertyName></ogc:PropertyName> <gml:Polygon xmlns:gml=\"http://www.opengis.net/gml\" srsName=\"EPSG:900913\"> <gml:exterior> <gml:LinearRing> <gml:posList>7666573.330932751 3485566.812628661 8010550.557483965 3485566.812628661 8010550.557483965 3788277.001334882 7666573.330932751 3788277.001334882 7666573.330932751 3485566.812628661</gml:posList> </gml:LinearRing> </gml:exterior> </gml:Polygon> </ogc:Intersects> </ogc:Filter> </wfs:Query> </wfs:GetFeature>";
        String out5 = this.postAsServletResponse("wfs", xml).getContentAsString();
        JSONObject rootObject5 = JSONObject.fromObject((Object)out5);
        Assert.assertEquals((Object)rootObject5.get("totalFeatures"), (Object)1);
    }

    @Test
    public void testGetFeatureCountWfs20() throws Exception {
        String out = this.getAsString("wfs?request=GetFeature&version=2.0.0&typename=sf:PrimitiveGeoFeature&count=10&outputformat=application/json");
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("totalFeatures"), (Object)5);
        Assert.assertEquals((Object)rootObject.get("numberMatched"), (Object)5);
        Assert.assertNull((Object)rootObject.get("links"));
        String out2 = this.getAsString("wfs?request=GetFeature&version=2.0.0&typename=sf:PrimitiveGeoFeature&count=10&outputformat=application/json&featureid=PrimitiveGeoFeature.f001");
        JSONObject rootObject2 = JSONObject.fromObject((Object)out2);
        Assert.assertEquals((Object)rootObject2.get("totalFeatures"), (Object)1);
        Assert.assertEquals((Object)rootObject2.get("numberMatched"), (Object)1);
        Assert.assertNull((Object)rootObject2.get("links"));
        String out3 = this.getAsString("wfs?request=GetFeature&version=2.0.0&typename=sf:PrimitiveGeoFeature&count=1&outputformat=application/json&featureid=PrimitiveGeoFeature.f001,PrimitiveGeoFeature.f002");
        JSONObject rootObject3 = JSONObject.fromObject((Object)out3);
        Assert.assertEquals((Object)rootObject3.get("totalFeatures"), (Object)2);
        Assert.assertEquals((Object)rootObject3.get("numberMatched"), (Object)2);
        Assert.assertNull((Object)rootObject3.get("links"));
        String out4 = this.getAsString("wfs?request=GetFeature&version=2.0.0&typename=sf:PrimitiveGeoFeature,sf:AggregateGeoFeature&outputformat=application/json&featureid=PrimitiveGeoFeature.f001,PrimitiveGeoFeature.f002,AggregateGeoFeature.f009");
        JSONObject rootObject4 = JSONObject.fromObject((Object)out4);
        Assert.assertEquals((Object)rootObject4.get("totalFeatures"), (Object)3);
        Assert.assertEquals((Object)rootObject4.get("numberMatched"), (Object)3);
        Assert.assertNull((Object)rootObject4.get("links"));
    }

    @Test
    public void getGetFeatureWithPagingFirstPage() throws Exception {
        String out = this.getAsString("wfs?request=GetFeature&version=2.0.0&typename=sf:PrimitiveGeoFeature&startIndex=0&&count=2&outputformat=application/json");
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        Assert.assertEquals((Object)rootObject.get("totalFeatures"), (Object)5);
        Assert.assertEquals((Object)rootObject.get("numberMatched"), (Object)5);
        Assert.assertEquals((Object)rootObject.get("numberReturned"), (Object)2);
        JSONArray links = rootObject.getJSONArray("links");
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)1L, (long)links.size());
        JSONObject link = links.getJSONObject(0);
        this.assertLink(link, "next page", "application/json", "next", "http://localhost:8080/geoserver/wfs?TYPENAME=sf%3APrimitiveGeoFeature&REQUEST=GetFeature&OUTPUTFORMAT=application%2Fjson&VERSION=2.0.0&COUNT=2&STARTINDEX=2");
    }

    @Test
    public void getGetFeatureWithPagingMidPage() throws Exception {
        String out = this.getAsString("wfs?request=GetFeature&version=2.0.0&typename=sf:PrimitiveGeoFeature&startIndex=2&&count=2&outputformat=application/json");
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        this.print((JSON)rootObject);
        Assert.assertEquals((Object)rootObject.get("totalFeatures"), (Object)5);
        Assert.assertEquals((Object)rootObject.get("numberMatched"), (Object)5);
        Assert.assertEquals((Object)rootObject.get("numberReturned"), (Object)2);
        JSONArray links = rootObject.getJSONArray("links");
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)2L, (long)links.size());
        JSONObject prev = links.getJSONObject(0);
        this.assertLink(prev, "previous page", "application/json", "previous", "http://localhost:8080/geoserver/wfs?TYPENAME=sf%3APrimitiveGeoFeature&REQUEST=GetFeature&OUTPUTFORMAT=application%2Fjson&VERSION=2.0.0&COUNT=2&STARTINDEX=0");
        JSONObject next = links.getJSONObject(1);
        this.assertLink(next, "next page", "application/json", "next", "http://localhost:8080/geoserver/wfs?TYPENAME=sf%3APrimitiveGeoFeature&REQUEST=GetFeature&OUTPUTFORMAT=application%2Fjson&VERSION=2.0.0&COUNT=2&STARTINDEX=4");
    }

    @Test
    public void getGetFeatureWithPagingLastPage() throws Exception {
        String out = this.getAsString("wfs?request=GetFeature&version=2.0.0&typename=sf:PrimitiveGeoFeature&startIndex=4&&count=2&outputformat=application/json");
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        this.print((JSON)rootObject);
        Assert.assertEquals((Object)rootObject.get("totalFeatures"), (Object)5);
        Assert.assertEquals((Object)rootObject.get("numberMatched"), (Object)5);
        Assert.assertEquals((Object)rootObject.get("numberReturned"), (Object)1);
        JSONArray links = rootObject.getJSONArray("links");
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)1L, (long)links.size());
        JSONObject prev = links.getJSONObject(0);
        this.assertLink(prev, "previous page", "application/json", "previous", "http://localhost:8080/geoserver/wfs?TYPENAME=sf%3APrimitiveGeoFeature&REQUEST=GetFeature&OUTPUTFORMAT=application%2Fjson&VERSION=2.0.0&COUNT=2&STARTINDEX=2");
    }

    private void assertLink(JSONObject link, String title, String type, String rel, String href) {
        Assert.assertNotNull((Object)link);
        Assert.assertEquals((Object)title, (Object)link.getString("title"));
        Assert.assertEquals((Object)type, (Object)link.getString("type"));
        Assert.assertEquals((Object)rel, (Object)link.getString("rel"));
        Assert.assertEquals((Object)href, (Object)link.getString("href"));
    }

    @Test
    public void testGetFeatureLine3D() throws Exception {
        JSONObject collection = (JSONObject)this.getAsJSON("wfs?request=GetFeature&version=1.0.0&typename=" + this.getLayerId(LINE3D) + "&outputformat=" + "application/json");
        Assert.assertEquals((long)1L, (long)collection.getInt("totalFeatures"));
        JSONArray features = collection.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
        JSONObject feature = features.getJSONObject(0);
        JSONObject geometry = feature.getJSONObject("geometry");
        Assert.assertEquals((Object)"LineString", (Object)geometry.getString("type"));
        JSONArray coords = geometry.getJSONArray("coordinates");
        JSONArray c1 = coords.getJSONArray(0);
        Assert.assertEquals((long)0L, (long)c1.getInt(0));
        Assert.assertEquals((long)0L, (long)c1.getInt(1));
        Assert.assertEquals((long)50L, (long)c1.getInt(2));
        JSONArray c2 = coords.getJSONArray(1);
        Assert.assertEquals((long)120L, (long)c2.getInt(0));
        Assert.assertEquals((long)0L, (long)c2.getInt(1));
        Assert.assertEquals((long)100L, (long)c2.getInt(2));
        CoordinateReferenceSystem expectedCrs = CRS.decode((String)"EPSG:4327");
        JSONObject aCRS = collection.getJSONObject("crs");
        Assert.assertThat((Object)aCRS, this.encodesCRS(expectedCrs));
    }

    protected void doAxisSwapTest(QName layer, CRS.AxisOrder sourceOrder) throws Exception {
        Assert.assertThat((Object)CRS.getAxisOrder((CoordinateReferenceSystem)this.getCatalog().getFeatureTypeByName(layer.getPrefix(), layer.getLocalPart()).getCRS()), (Matcher)Matchers.is((Object)sourceOrder));
        JSONObject collection = (JSONObject)this.getAsJSON("wfs?request=GetFeature&version=1.0.0&typename=" + this.getLayerId(layer) + "&outputformat=" + "application/json");
        Assert.assertThat((Object)collection.getInt("totalFeatures"), (Matcher)Matchers.is((Object)3));
        JSONArray features = collection.getJSONArray("features");
        Assert.assertThat((Object)features, (Matcher)Matchers.hasSize((int)3));
        JSONObject feature = features.getJSONObject(0);
        JSONObject geometry = feature.getJSONObject("geometry");
        Assert.assertThat((Object)geometry.getString("type"), (Matcher)Matchers.is((Object)"Point"));
        JSONArray coords = geometry.getJSONArray("coordinates");
        Assert.assertThat((Object)coords, (Matcher)Matchers.contains((Object[])new Object[]{120, 0}));
        JSONArray bbox = collection.getJSONArray("bbox");
        Assert.assertThat((Object)bbox, (Matcher)Matchers.contains((Object[])new Object[]{-170, -30, 120, 45}));
        CoordinateReferenceSystem expectedCrs = CRS.decode((String)"EPSG:4326");
        JSONObject aCRS = collection.getJSONObject("crs");
        Assert.assertThat((Object)aCRS, this.encodesCRS(expectedCrs));
    }

    @Test
    public void testGetFeatureWhereLayerHasDecimalPointsSet() throws Exception {
        JSONObject collection = (JSONObject)this.getAsJSON("wfs?request=GetFeature&version=1.0.0&typename=" + this.getLayerId(POINT_REDUCED) + "&outputformat=" + "application/json");
        Assert.assertThat((Object)collection.getInt("totalFeatures"), (Matcher)Matchers.is((Object)3));
        JSONArray features = collection.getJSONArray("features");
        Assert.assertThat((Object)features, (Matcher)Matchers.hasSize((int)3));
        JSONObject feature = features.getJSONObject(0);
        JSONObject geometry = feature.getJSONObject("geometry");
        Assert.assertThat((Object)geometry.getString("type"), (Matcher)Matchers.is((Object)"Point"));
        JSONArray coords = geometry.getJSONArray("coordinates");
        Assert.assertThat((Object)coords, (Matcher)Matchers.contains((Object[])new Object[]{120.12, 0.56}));
        JSONArray bbox = collection.getJSONArray("bbox");
        Assert.assertThat((Object)bbox, (Matcher)Matchers.contains((Object[])new Object[]{-170.19, -30.13, 120.12, 45.23}));
        CoordinateReferenceSystem expectedCrs = CRS.decode((String)"EPSG:4326");
        JSONObject aCRS = collection.getJSONObject("crs");
        Assert.assertThat((Object)aCRS, this.encodesCRS(expectedCrs));
    }

    @Test
    public void testGetFeatureAxisSwap() throws Exception {
        this.doAxisSwapTest(POINT_LATLON, CRS.AxisOrder.NORTH_EAST);
    }

    @Test
    public void testGetFeatureNoAxisSwap() throws Exception {
        this.doAxisSwapTest(POINT_LONLAT, CRS.AxisOrder.EAST_NORTH);
    }

    @Test
    public void testGetFeatureCRS() throws Exception {
        QName layer = SystemTestData.LINES;
        JSONObject collection = (JSONObject)this.getAsJSON("wfs?request=GetFeature&version=1.0.0&typename=" + this.getLayerId(layer) + "&outputformat=" + "application/json");
        CoordinateReferenceSystem expectedCrs = this.getCatalog().getLayerByName(this.getLayerId(layer)).getResource().getCRS();
        JSONObject aCRS = collection.getJSONObject("crs");
        Assert.assertThat((Object)aCRS, this.encodesCRS(expectedCrs));
    }

    @Test
    public void testGeometryAndGeometryNameConsistency() throws Exception {
        JSONObject collection = (JSONObject)this.getAsJSON("wfs?request=GetFeature&version=1.0.0&typename=" + this.getLayerId(MULTI_GEOMETRIES_WITH_NULL) + "&outputformat=" + "application/json");
        this.print((JSON)collection);
        Assert.assertEquals((long)3L, (long)collection.getInt("totalFeatures"));
        JSONArray features = collection.getJSONArray("features");
        Assert.assertEquals((long)3L, (long)features.size());
        JSONObject feature = features.getJSONObject(0);
        Assert.assertEquals((Object)"MultiGeometriesWithNull.0", (Object)feature.getString("id"));
        Assert.assertEquals((String)"All geometries present, first geometry must be default", (Object)"geom_a", (Object)feature.getString("geometry_name"));
        JSONObject geometry = feature.getJSONObject("geometry");
        JSONArray coords = geometry.getJSONArray("coordinates");
        Assert.assertEquals((String)"geom_a has coodinate 1", (long)1L, (long)coords.getInt(0));
        JSONObject properties = feature.getJSONObject("properties");
        Assert.assertFalse((String)"geom_a must not be present, its the default geom", (boolean)properties.containsKey((Object)"geom_a"));
        JSONObject propertyGeomB = properties.getJSONObject("geom_b");
        coords = propertyGeomB.getJSONArray("coordinates");
        Assert.assertEquals((String)"geom_b has coodinate 2", (long)2L, (long)coords.getInt(0));
        JSONObject propertyGeomC = properties.getJSONObject("geom_c");
        coords = propertyGeomC.getJSONArray("coordinates");
        Assert.assertEquals((String)"geom_c has coodinate 3", (long)3L, (long)coords.getInt(0));
        feature = features.getJSONObject(1);
        Assert.assertEquals((Object)"MultiGeometriesWithNull.1", (Object)feature.getString("id"));
        Assert.assertEquals((String)"1st geometry null, still default", (Object)"geom_a", (Object)feature.getString("geometry_name"));
        geometry = feature.getJSONObject("geometry");
        Assert.assertTrue((boolean)geometry.isNullObject());
        properties = feature.getJSONObject("properties");
        Assert.assertFalse((String)"geom_a must not be present, its the default geom", (boolean)properties.containsKey((Object)"geom_a"));
        propertyGeomB = properties.getJSONObject("geom_b");
        coords = propertyGeomB.getJSONArray("coordinates");
        Assert.assertEquals((String)"geom_b has coodinate 2", (long)2L, (long)coords.getInt(0));
        propertyGeomC = properties.getJSONObject("geom_c");
        coords = propertyGeomC.getJSONArray("coordinates");
        Assert.assertEquals((String)"geom_c has coodinate 3", (long)3L, (long)coords.getInt(0));
        feature = features.getJSONObject(2);
        Assert.assertEquals((Object)"MultiGeometriesWithNull.2", (Object)feature.getString("id"));
        Assert.assertEquals((String)"no geometries present, 1st still default", (Object)"geom_a", (Object)feature.getString("geometry_name"));
        geometry = feature.getJSONObject("geometry");
        Assert.assertTrue((boolean)geometry.isNullObject());
        properties = feature.getJSONObject("properties");
        Assert.assertFalse((String)"geom_a must not be present, its the default geom", (boolean)properties.containsKey((Object)"geom_a"));
        propertyGeomB = properties.getJSONObject("geom_b");
        Assert.assertTrue((boolean)propertyGeomB.isNullObject());
        propertyGeomC = properties.getJSONObject("geom_c");
        Assert.assertTrue((boolean)propertyGeomC.isNullObject());
    }

    private Matcher<JSONObject> encodesCRS(final CoordinateReferenceSystem crs) {
        return new BaseMatcher<JSONObject>(){

            public boolean matches(Object item) {
                CoordinateReferenceSystem decodedDefault = GeoJSONTest.decodeCRS((JSONObject)item, false);
                if (CRS.equalsIgnoreMetadata((Object)crs, (Object)decodedDefault)) {
                    return true;
                }
                CoordinateReferenceSystem decodedXY = GeoJSONTest.decodeCRS((JSONObject)item, true);
                if (CRS.equalsIgnoreMetadata((Object)crs, (Object)decodedXY)) {
                    return true;
                }
                String identifier = ((JSONObject)item).getJSONObject("properties").getString("name");
                Pattern p = Pattern.compile("^urn:ogc:def:crs:EPSG:[^:]*:(\\d+)$");
                java.util.regex.Matcher m = p.matcher(identifier);
                if (m.matches()) {
                    CoordinateReferenceSystem decodedStripped;
                    String code = "EPSG:" + m.group(1);
                    try {
                        decodedStripped = CRS.decode((String)code, (boolean)true);
                    }
                    catch (FactoryException e) {
                        throw new IllegalStateException(e);
                    }
                    if (CRS.equalsIgnoreMetadata((Object)crs, (Object)decodedStripped)) {
                        return true;
                    }
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("JSON representation of CRS ");
                description.appendValue((Object)crs);
            }
        };
    }

    private static CoordinateReferenceSystem decodeCRS(JSONObject json, boolean forceXY) {
        if (!json.getString("type").equals("name")) {
            throw new IllegalArgumentException();
        }
        String identifier = json.getJSONObject("properties").getString("name");
        try {
            return CRS.decode((String)identifier, (boolean)forceXY);
        }
        catch (FactoryException e) {
            throw new IllegalStateException(e);
        }
    }
}

