/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;

public class GeoJSONBuilderTest {
    StringWriter writer;
    GeoJSONBuilder builder;

    @Before
    public void setUp() {
        this.writer = new StringWriter();
        this.builder = new GeoJSONBuilder((Writer)this.writer);
        this.builder.setEncodeMeasures(true);
    }

    @Test
    public void testWriteNormal() throws Exception {
        Geometry g = new WKTReader().read("MULTILINESTRING((0 0, 1 1))");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"MultiLineString\",\"coordinates\":[[[0,0],[1,1]]]}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteGeometrySubclass() throws Exception {
        this.builder.writeGeom((Geometry)new MyPoint(1.0, 2.0));
        Assert.assertEquals((Object)"{\"type\":\"Point\",\"coordinates\":[1,2]}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteDate() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        Date date = new Date(cal.getTimeInMillis());
        this.builder.object().key("date").value((Object)date).endObject();
        Assert.assertEquals((Object)"{\"date\":\"2011-10-25Z\"}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteTime() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(10, 15);
        cal.set(12, 48);
        cal.set(13, 5);
        Time date = new Time(cal.getTimeInMillis());
        this.builder.object().key("time").value((Object)date).endObject();
        Assert.assertEquals((Object)"{\"time\":\"15:48:05Z\"}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteDateTime() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        cal.set(10, 15);
        cal.set(12, 48);
        cal.set(13, 5);
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        this.builder.object().key("timestamp").value((Object)date).endObject();
        Assert.assertEquals((Object)"{\"timestamp\":\"2011-10-25T15:48:05Z\"}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteDateTimeMillis() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        cal.set(10, 15);
        cal.set(12, 48);
        cal.set(13, 5);
        cal.set(14, 223);
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        this.builder.object().key("timestamp").value((Object)date).endObject();
        Assert.assertEquals((Object)"{\"timestamp\":\"2011-10-25T15:48:05.223Z\"}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteJavaDate() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        cal.set(10, 15);
        cal.set(12, 48);
        cal.set(13, 5);
        cal.set(14, 223);
        java.util.Date date = new java.util.Date(cal.getTimeInMillis());
        this.builder.object().key("date").value((Object)date).endObject();
        Assert.assertEquals((Object)"{\"date\":\"2011-10-25T15:48:05.223Z\"}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteCalendar() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        this.builder.object().key("cal").value((Object)cal).endObject();
        Assert.assertEquals((Object)"{\"cal\":\"2011-10-25T00:00:00Z\"}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteCalendarTZ() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT-05:00"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        this.builder.object().key("cal").value((Object)cal).endObject();
        Assert.assertEquals((Object)"{\"cal\":\"2011-10-25T00:00:00-05:00\"}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteCalendarFull() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(1, 2011);
        cal.set(2, 9);
        cal.set(5, 25);
        cal.set(10, 15);
        cal.set(12, 48);
        cal.set(13, 5);
        cal.set(14, 223);
        this.builder.object().key("cal").value((Object)cal).endObject();
        Assert.assertEquals((Object)"{\"cal\":\"2011-10-25T15:48:05.223Z\"}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteGeomCollection() throws Exception {
        Geometry g = new WKTReader().read("GEOMETRYCOLLECTION(POINT(2 0),POINT(7 1))");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"GeometryCollection\",\"geometries\":[{\"type\":\"Point\",\"coordinates\":[2,0]},{\"type\":\"Point\",\"coordinates\":[7,1]}]}", (Object)this.writer.toString());
    }

    @Test
    public void testWrite3DPoint() throws Exception {
        Geometry g = new WKTReader().read("POINT(2 0 20)");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"Point\",\"coordinates\":[2,0,20]}", (Object)this.writer.toString());
    }

    @Test
    public void testWrite3DLine() throws Exception {
        Geometry g = new WKTReader().read("LINESTRING(0 0 0, 0 10 1, 10 10 2, 10 0 3, 0 0 0)");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"LineString\",\"coordinates\":[[0,0,0],[0,10,1],[10,10,2],[10,0,3],[0,0,0]]}", (Object)this.writer.toString());
    }

    @Test
    public void testWrite3DPolygon() throws Exception {
        Geometry g = new WKTReader().read("POLYGON((0 0 0, 0 10 1, 10 10 2, 10 0 3, 0 0 0),(1 1 4, 1 2 5, 2 2 6, 2 1 7, 1 1 4))");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"Polygon\",\"coordinates\":[[[0,0,0],[0,10,1],[10,10,2],[10,0,3],[0,0,0]],[[1,1,4],[1,2,5],[2,2,6],[2,1,7],[1,1,4]]]}", (Object)this.writer.toString());
    }

    @Test
    public void testNumberOfDecimalsFor3dPoint() throws Exception {
        this.builder.setNumberOfDecimals(2);
        Geometry g = new WKTReader().read("POINT(2.1234 0.1234 20.9999)");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"Point\",\"coordinates\":[2.12,0.12,21]}", (Object)this.writer.toString());
    }

    @Test
    public void testNumberOfDecimalsFor3dLine() throws Exception {
        this.builder.setNumberOfDecimals(3);
        Geometry g = new WKTReader().read("LINESTRING(1E-3 1E-4 1E-5, 0 10.12312321 1.000002, 10.1 10.2 2.0, 10 0 3, 0 0 0)");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"LineString\",\"coordinates\":[[0.001,0,0],[0,10.123,1],[10.1,10.2,2],[10,0,3],[0,0,0]]}", (Object)this.writer.toString());
    }

    @Test
    public void testNumberOfDecimalsFor3dPolygon() throws Exception {
        this.builder.setNumberOfDecimals(0);
        Geometry g = new WKTReader().read("POLYGON((0.1 0.2 0.3, 0.1 10.1 1.1, 10.2 10.3 2.4, 9.5 0.4 3, 0.1 0.2 0.3),(1 1 4, 1 2 5, 2 2 6, 2 1 7, 1 1 4))");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"Polygon\",\"coordinates\":[[[0,0,0],[0,10,1],[10,10,2],[10,0,3],[0,0,0]],[[1,1,4],[1,2,5],[2,2,6],[2,1,7],[1,1,4]]]}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteStrList() throws Exception {
        List<String> list = Arrays.asList("a", "b", "c", "d");
        this.builder.writeList(list);
        Assert.assertEquals((Object)"[\"a\",\"b\",\"c\",\"d\"]", (Object)this.writer.toString());
    }

    @Test
    public void testWriteIntList() throws Exception {
        List<Integer> list = Arrays.asList(Integer.MAX_VALUE, Integer.MIN_VALUE, 3, 4);
        this.builder.writeList(list);
        Assert.assertEquals((Object)("[" + Integer.toString(Integer.MAX_VALUE) + "," + Integer.toString(Integer.MIN_VALUE) + ",3,4]"), (Object)this.writer.toString());
    }

    @Test
    public void testWriteLongList() throws Exception {
        List<Long> list = Arrays.asList(Long.MAX_VALUE, Long.MIN_VALUE, 0L, -333L, 4L);
        this.builder.writeList(list);
        Assert.assertEquals((Object)("[" + Long.toString(Long.MAX_VALUE) + "," + Long.toString(Long.MIN_VALUE) + ",0,-333,4]"), (Object)this.writer.toString());
    }

    @Test
    public void testWriteFloatList() throws Exception {
        List<Float> list = Arrays.asList(Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE), Float.valueOf(0.0f), Float.valueOf(-333.2365f), Float.valueOf(0.23235656f));
        this.builder.writeList(list);
        Assert.assertEquals((Object)("[" + Float.toString(Float.MAX_VALUE) + "," + Float.toString(Float.MIN_VALUE) + ",0,-333.2365,0.23235656]"), (Object)this.writer.toString());
    }

    @Test
    public void testWriteDoubleList() throws Exception {
        List<Double> list = Arrays.asList(Double.MAX_VALUE, Double.MIN_VALUE, 0.0, -333.2365, 0.23235656);
        this.builder.writeList(list);
        Assert.assertEquals((Object)("[" + Double.toString(Double.MAX_VALUE) + "," + Double.toString(Double.MIN_VALUE) + ",0,-333.2365,0.23235656]"), (Object)this.writer.toString());
    }

    @Test
    public void testWriteUUIDList() throws Exception {
        UUID u1 = UUID.fromString("12345678-1234-1234-1234-123456781234");
        UUID u2 = UUID.fromString("00000000-0000-0000-0000-000000000000");
        List<UUID> list = Arrays.asList(u1, u2);
        this.builder.writeList(list);
        Assert.assertEquals((Object)("[\"" + u1.toString() + "\",\"" + u2.toString() + "\"]"), (Object)this.writer.toString());
    }

    @Test
    public void testWriteStringStringMap() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put("a", "1");
                this.put("b", "2");
                this.put("c", "3");
            }
        };
        this.builder.writeMap((Map)map);
        JSONObject root = JSONObject.fromObject((Object)this.writer.toString());
        Assert.assertEquals((long)3L, (long)root.size());
        Assert.assertEquals((Object)"1", (Object)root.get("a"));
        Assert.assertEquals((Object)"2", (Object)root.get("b"));
        Assert.assertEquals((Object)"3", (Object)root.get("c"));
    }

    @Test
    public void testWriteStringIntMap() throws Exception {
        HashMap<String, Integer> map = new HashMap<String, Integer>(){
            {
                this.put("a", Integer.MAX_VALUE);
                this.put("b", Integer.MIN_VALUE);
                this.put("c", 3);
            }
        };
        this.builder.writeMap((Map)map);
        JSONObject root = JSONObject.fromObject((Object)this.writer.toString());
        Assert.assertEquals((long)3L, (long)root.size());
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)root.get("a"));
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)root.get("b"));
        Assert.assertEquals((Object)3, (Object)root.get("c"));
    }

    @Test
    public void testWriteListOfMaps() throws Exception {
        final UUID u1 = UUID.fromString("12345678-1234-1234-1234-123456781234");
        HashMap<String, Object> tuple1 = new HashMap<String, Object>(){
            {
                this.put("a", 1);
                this.put("b", u1);
                this.put("c", "object1");
            }
        };
        final UUID u2 = UUID.fromString("00000000-0000-0000-0000-000000000000");
        HashMap<String, Object> tuple2 = new HashMap<String, Object>(){
            {
                this.put("a", 2);
                this.put("b", u2);
                this.put("c", "object2");
            }
        };
        List<Map> tupleList = Arrays.asList(tuple1, tuple2);
        this.builder.writeList(tupleList);
        JSONArray root = JSONArray.fromObject((Object)this.writer.toString());
        Assert.assertEquals((long)2L, (long)root.size());
        JSONObject o1 = root.getJSONObject(0);
        Assert.assertEquals((long)3L, (long)o1.size());
        Assert.assertEquals((Object)1, (Object)o1.get("a"));
        Assert.assertEquals((Object)u1.toString(), (Object)o1.get("b"));
        Assert.assertEquals((Object)"object1", (Object)o1.get("c"));
        JSONObject o2 = root.getJSONObject(1);
        Assert.assertEquals((long)3L, (long)o2.size());
        Assert.assertEquals((Object)2, (Object)o2.get("a"));
        Assert.assertEquals((Object)u2.toString(), (Object)o2.get("b"));
        Assert.assertEquals((Object)"object2", (Object)o2.get("c"));
    }

    @Test
    public void testWritePointZM() throws Exception {
        Geometry g = new WKTReader().read("POINT ZM (2 0 20 2)");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"Point\",\"coordinates\":[2,0,20,2]}", (Object)this.writer.toString());
    }

    @Test
    public void testWritePointM() throws Exception {
        Geometry g = new WKTReader().read("POINT M (2 0 20)");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"Point\",\"coordinates\":[2,0,0,20]}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteMultiPointZM() throws Exception {
        Geometry g = new WKTReader().read("MULTIPOINT ZM (2 0 20 2, 1 1 1 1)");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"MultiPoint\",\"coordinates\":[[2,0,20,2],[1,1,1,1]]}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteMultiPointM() throws Exception {
        Geometry g = new WKTReader().read("MULTIPOINT M (2 0 20, 1 1 1)");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"MultiPoint\",\"coordinates\":[[2,0,0,20],[1,1,0,1]]}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteLineZM() throws Exception {
        Geometry g = new WKTReader().read("LINESTRING ZM (0 0 0 0, 0 10 1 1, 10 10 2 2)");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"LineString\",\"coordinates\":[[0,0,0,0],[0,10,1,1],[10,10,2,2]]}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteMultiLineZM() throws Exception {
        Geometry g = new WKTReader().read("MULTILINESTRING ZM ((1 2 3 4,5 6 7 8))");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"MultiLineString\",\"coordinates\":[[[1,2,3,4],[5,6,7,8]]]}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteMultiLineM() throws Exception {
        Geometry g = new WKTReader().read("MULTILINESTRING M ((1 2 4,5 6 8))");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"MultiLineString\",\"coordinates\":[[[1,2,0,4],[5,6,0,8]]]}", (Object)this.writer.toString());
    }

    @Test
    public void testWritePolygonZM() throws Exception {
        Geometry g = new WKTReader().read("POLYGON ZM ((0 0 0 3, 0 10 1 3, 10 10 2 3, 10 0 3 3, 0 0 0 3),(1 1 4 3, 1 2 5 3, 2 2 6 3, 2 1 7 3, 1 1 4 3))");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"Polygon\",\"coordinates\":[[[0,0,0,3],[0,10,1,3],[10,10,2,3],[10,0,3,3],[0,0,0,3]],[[1,1,4,3],[1,2,5,3],[2,2,6,3],[2,1,7,3],[1,1,4,3]]]}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteMultiPolygonZM() throws Exception {
        Geometry g = new WKTReader().read("MULTIPOLYGON ZM (((0 0 3 1,1 1 7 2,1 0 7 3,0 0 3 1)))");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"MultiPolygon\",\"coordinates\":[[[[0,0,3,1],[1,1,7,2],[1,0,7,3],[0,0,3,1]]]]}", (Object)this.writer.toString());
    }

    @Test
    public void testWriteMultiPolygonM() throws Exception {
        Geometry g = new WKTReader().read("MULTIPOLYGON M (((0 0 1,1 1 2,1 0 3,0 0 1)))");
        this.builder.writeGeom(g);
        Assert.assertEquals((Object)"{\"type\":\"MultiPolygon\",\"coordinates\":[[[[0,0,0,1],[1,1,0,2],[1,0,0,3],[0,0,0,1]]]]}", (Object)this.writer.toString());
    }

    class MyPoint
    extends Point {
        public MyPoint(double x, double y) {
            super(new Coordinate(x, y), new PrecisionModel(), -1);
        }
    }
}

