/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.IsolatedWorkspacesTest;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public final class WfsIsolatedWorkspacesTest
extends IsolatedWorkspacesTest {
    private static final Map<String, String> NAMESPACES_WFS11 = new HashMap<String, String>();
    private static final Map<String, String> NAMESPACES_WFS20;

    @Test
    public void getFeatureInfoOnLayerFromIsolatedWorkspaces() throws Exception {
        Catalog catalog = this.getCatalog();
        this.createWorkspace("test_a1", "https://www.test_a.com", false);
        this.createWorkspace("test_a2", "https://www.test_a.com", true);
        WorkspaceInfo workspace1 = catalog.getWorkspaceByName("test_a1");
        NamespaceInfo namespace1 = catalog.getNamespaceByPrefix("test_a1");
        WorkspaceInfo workspace2 = catalog.getWorkspaceByName("test_a2");
        NamespaceInfo namespace2 = catalog.getNamespaceByPrefix("test_a2");
        LayerInfo clonedLayer1 = this.cloneVectorLayerIntoWorkspace(workspace1, namespace1, "Lines", "layer_e");
        LayerInfo clonedLayer2 = this.cloneVectorLayerIntoWorkspace(workspace2, namespace2, "Points", "layer_e");
        Assert.assertThat((Object)clonedLayer1.getId(), (Matcher)Matchers.not((Object)clonedLayer2.getId()));
        MockHttpServletResponse response = this.getAsServletResponse("test_a1/wfs?SERVICE=wfs&VERSION=1.1.0&REQUEST=getFeature&typeName=layer_e&maxFeatures=1");
        this.evaluateAndCheckXpath(this.mergeNamespaces(NAMESPACES_WFS11, "test_a1", "https://www.test_a.com"), response, "count(//wfs:FeatureCollection/gml:featureMembers/test_a1:layer_e/test_a1:lineStringProperty)", "1");
        response = this.getAsServletResponse("test_a2/wfs?SERVICE=wfs&VERSION=1.1.0&REQUEST=getFeature&typeName=layer_e&maxFeatures=1");
        this.evaluateAndCheckXpath(this.mergeNamespaces(NAMESPACES_WFS11, "test_a2", "https://www.test_a.com"), response, "count(//wfs:FeatureCollection/gml:featureMembers/test_a2:layer_e/test_a2:pointProperty)", "1");
    }

    private Map<String, String> mergeNamespaces(Map<String, String> namespaces, String ... extraNamespaces) {
        HashMap<String, String> finalNamespaces = new HashMap<String, String>();
        finalNamespaces.putAll(namespaces);
        for (int i = 0; i < extraNamespaces.length; i += 2) {
            finalNamespaces.put(extraNamespaces[i], extraNamespaces[i + 1]);
        }
        return finalNamespaces;
    }

    private void evaluateAndCheckXpath(Map<String, String> namespaces, MockHttpServletResponse response, String xpath, String expectResult) throws Exception {
        Document document = null;
        try (ByteArrayInputStream input = new ByteArrayInputStream(response.getContentAsString().getBytes());){
            document = this.dom(input, true);
        }
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        XpathEngine xpathEngine = XMLUnit.newXpathEngine();
        String result = xpathEngine.evaluate(xpath, document);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)expectResult));
    }

    static {
        NAMESPACES_WFS11.put("wfs", "http://www.opengis.net/wfs");
        NAMESPACES_WFS11.put("ows", "http://www.opengis.net/ows");
        NAMESPACES_WFS11.put("ogc", "http://www.opengis.net/ogc");
        NAMESPACES_WFS11.put("xs", "http://www.w3.org/2001/XMLSchema");
        NAMESPACES_WFS11.put("xsd", "http://www.w3.org/2001/XMLSchema");
        NAMESPACES_WFS11.put("gml", "http://www.opengis.net/gml");
        NAMESPACES_WFS11.put("xlink", "http://www.w3.org/1999/xlink");
        NAMESPACES_WFS11.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        NAMESPACES_WFS11.put("gs", "http://geoserver.org");
        NAMESPACES_WFS20 = new HashMap<String, String>();
        NAMESPACES_WFS20.put("wfs", "http://www.opengis.net/wfs/2.0");
        NAMESPACES_WFS20.put("ows", "http://www.opengis.net/ows/1.1");
        NAMESPACES_WFS20.put("fes", "http://www.opengis.net/fes/2.0");
        NAMESPACES_WFS20.put("gml", "http://www.opengis.net/gml/3.2");
        NAMESPACES_WFS20.put("ogc", "http://www.opengis.net/ogc");
        NAMESPACES_WFS20.put("xs", "http://www.w3.org/2001/XMLSchema");
        NAMESPACES_WFS20.put("xsd", "http://www.w3.org/2001/XMLSchema");
        NAMESPACES_WFS20.put("xlink", "http://www.w3.org/1999/xlink");
        NAMESPACES_WFS20.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        NAMESPACES_WFS20.put("gs", "http://geoserver.org");
    }
}

