/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.InputStream;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.WFSXStreamLoader;
import org.junit.Assert;
import org.junit.Test;

public class WFSXStreamLoaderTest
extends WFSTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Test
    public void testGmlCreateFromScratch() throws Exception {
        WFSXStreamLoader loader = (WFSXStreamLoader)GeoServerExtensions.bean(WFSXStreamLoader.class);
        WFSInfo wfs = loader.createServiceFromScratch(null);
        Assert.assertNotNull((Object)wfs);
        Assert.assertTrue((boolean)wfs.getGML().containsKey(WFSInfo.Version.V_10));
        Assert.assertTrue((boolean)wfs.getGML().containsKey(WFSInfo.Version.V_11));
        Assert.assertTrue((boolean)wfs.getGML().containsKey(WFSInfo.Version.V_20));
    }

    @Test
    public void testLoadVersion() throws Exception {
        XStreamPersisterFactory factory = (XStreamPersisterFactory)GeoServerExtensions.bean(XStreamPersisterFactory.class);
        XStreamPersister xp = factory.createXMLPersister();
        WFSXStreamLoader loader = (WFSXStreamLoader)GeoServerExtensions.bean(WFSXStreamLoader.class);
        loader.initXStreamPersister(xp, this.getGeoServer());
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("wfs-test.xml");){
            xp.load(is, WFSInfo.class);
        }
    }

    @Test
    public void testLoadMinimalConfig() throws Exception {
        XStreamPersisterFactory factory = (XStreamPersisterFactory)GeoServerExtensions.bean(XStreamPersisterFactory.class);
        XStreamPersister xp = factory.createXMLPersister();
        WFSXStreamLoader loader = (WFSXStreamLoader)GeoServerExtensions.bean(WFSXStreamLoader.class);
        loader.initXStreamPersister(xp, this.getGeoServer());
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("wfs-minimal.xml");){
            xp.load(is, WFSInfo.class);
        }
    }
}

