/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.junit.After;

public abstract class WFSTestSupport
extends GeoServerSystemTestSupport {
    protected Boolean citeCompliant;

    protected WFSInfo getWFS() {
        return (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
    }

    protected Service getServiceDescriptor10() {
        return (Service)GeoServerExtensions.bean((String)"wfsService-1.0.0");
    }

    protected Service getServiceDescriptor11() {
        return (Service)GeoServerExtensions.bean((String)"wfsService-1.1.0");
    }

    protected org.geoserver.wfs.xml.v1_0_0.WFSConfiguration getXmlConfiguration10() {
        return (org.geoserver.wfs.xml.v1_0_0.WFSConfiguration)applicationContext.getBean("wfsXmlConfiguration-1.0");
    }

    protected WFSConfiguration getXmlConfiguration11() {
        return (WFSConfiguration)applicationContext.getBean("wfsXmlConfiguration-1.1");
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("ows", "http://www.opengis.net/ows");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("xs", "http://www.w3.org/2001/XMLSchema");
        namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("gs", "http://geoserver.org");
        namespaces.put("soap12", "http://www.w3.org/2003/05/soap-envelope");
        CiteTestData.registerNamespaces(namespaces);
        this.setUpNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        this.setUpInternal(testData);
    }

    protected void setUpInternal(SystemTestData testData) throws Exception {
    }

    protected void setUpNamespaces(Map<String, String> namespaces) {
    }

    protected List<String> getSupportedSpatialOperatorsList(boolean wfs1_0_0) {
        return Arrays.asList("Disjoint", "Equals", "DWithin", "Beyond", "Intersect" + (wfs1_0_0 ? "" : "s"), "Touches", "Crosses", "Within", "Contains", "Overlaps", "BBOX");
    }

    protected void setCiteCompliant(boolean value) {
        WFSInfo wfs = this.getWFS();
        this.citeCompliant = wfs.isCiteCompliant();
        wfs.setCiteCompliant(value);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    @After
    public void resetCiteCompliant() {
        if (Objects.nonNull(this.citeCompliant)) {
            WFSInfo wfs = this.getWFS();
            wfs.setCiteCompliant(this.citeCompliant.booleanValue());
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    protected static void setMeasuresEncoding(Catalog catalog, String featureTypeName, boolean encodeMeasures) {
        FeatureTypeInfo featureTypeInfo = catalog.getFeatureTypeByName(featureTypeName);
        if (featureTypeInfo == null) {
            throw new RuntimeException(String.format("No feature type matching the provided name '%s' found.", featureTypeName));
        }
        featureTypeInfo.setEncodeMeasures(encodeMeasures);
        catalog.save((ResourceInfo)featureTypeInfo);
    }
}

