/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.UnsupportedEncodingException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.json.JSONType;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class WFSServiceExceptionTest
extends WFSTestSupport {
    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    @Test
    public void testJsonpException() throws Exception {
        this.testJsonpException("1.1.0");
    }

    @Test
    public void testJsonException() throws Exception {
        this.testJsonException("1.1.0");
    }

    @Test
    public void testJsonpException20() throws Exception {
        this.testJsonpException("2.0.0");
    }

    @Test
    public void testJsonException20() throws Exception {
        this.testJsonException("2.0.0");
    }

    private void testJsonpException(String wfsVersion) throws UnsupportedEncodingException, Exception {
        String path = this.getPath(wfsVersion);
        JSONType.setJsonpEnabled((boolean)true);
        MockHttpServletResponse response = this.getAsServletResponse(path + "&EXCEPTIONS=" + "text/javascript");
        JSONType.setJsonpEnabled((boolean)false);
        Assert.assertEquals((Object)"text/javascript", (Object)response.getContentType());
        String content = response.getContentAsString();
        WFSServiceExceptionTest.testJson(WFSServiceExceptionTest.testJsonP(content), wfsVersion);
    }

    private void testJsonException(String wfsVersion) throws UnsupportedEncodingException, Exception {
        String path = this.getPath(wfsVersion);
        MockHttpServletResponse response = this.getAsServletResponse(path + "&EXCEPTIONS=" + "application/json");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        String content = response.getContentAsString();
        WFSServiceExceptionTest.testJson(content, wfsVersion);
    }

    private String getPath(String wfsVersion) {
        String path = "wfs/?service=wfs&version=" + wfsVersion + "&request=DescribeFeatureType&typeName=foobar&format_options=" + "callback" + ":myMethod";
        return path;
    }

    private static String testJsonP(String content) {
        Assert.assertTrue((boolean)content.startsWith("myMethod("));
        Assert.assertTrue((boolean)content.endsWith(")"));
        content = content.substring("myMethod(".length(), content.length() - 1);
        return content;
    }

    private static void testJson(String content, String expectedVersion) {
        JSONObject jsonException = JSONObject.fromObject((Object)content);
        Assert.assertEquals((Object)jsonException.getString("version"), (Object)expectedVersion);
        JSONArray exceptions = jsonException.getJSONArray("exceptions");
        JSONObject exception = exceptions.getJSONObject(0);
        Assert.assertNotNull((Object)exception);
        Assert.assertNotNull((Object)exception.getString("code"));
        Assert.assertNotNull((Object)exception.getString("locator"));
        String exceptionText = exception.getString("text");
        Assert.assertNotNull((Object)exceptionText);
        Assert.assertEquals((Object)exceptionText, (Object)"Could not find type: {http://geoserver.org}foobar");
    }
}

