/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.awt.RenderingHints;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.referencing.CRS;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WFSReprojectionUtilTest {
    private final FeatureType featureType = WFSReprojectionUtilTest.createFeatureType();
    private final FilterFactory2 filterFactory = WFSReprojectionUtilTest.createFilterFactory();

    @BeforeClass
    public static void before() {
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)false);
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)true);
    }

    @AfterClass
    public static void after() {
        Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING);
    }

    private static FeatureType createFeatureType() {
        try {
            return DataUtilities.createType((String)"testType", (String)"geom:Point:srid=4326,line:LineString,name:String,id:int");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static FilterFactory2 createFilterFactory() {
        try {
            return CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Test
    public void testNullCheck() {
        CoordinateReferenceSystem crs = WFSReprojectionUtil.getDeclaredCrs((FeatureType)null, (String)"1.1.0");
        Assert.assertNull((Object)crs);
    }

    @Test
    public void testReprojectFilterWithTargetCrs() throws FactoryException {
        BBOX bbox = this.filterFactory.bbox((Expression)this.filterFactory.property("geom"), 10.0, 15.0, 20.0, 25.0, "EPSG:4326");
        Filter clone = WFSReprojectionUtil.reprojectFilter((Filter)bbox, (FeatureType)this.featureType, (CoordinateReferenceSystem)CRS.decode((String)"EPSG:3857"));
        Assert.assertNotSame((Object)bbox, (Object)clone);
        BBOX clonedBbox = (BBOX)clone;
        Assert.assertEquals((Object)bbox.getPropertyName(), (Object)clonedBbox.getPropertyName());
        Assert.assertEquals((double)1669792.3618991035, (double)clonedBbox.getMinX(), (double)0.1);
        Assert.assertEquals((double)1118889.9748579597, (double)clonedBbox.getMinY(), (double)0.1);
        Assert.assertEquals((double)2782987.269831839, (double)clonedBbox.getMaxX(), (double)0.1);
        Assert.assertEquals((double)2273030.926987689, (double)clonedBbox.getMaxY(), (double)0.1);
        Assert.assertEquals((Object)"EPSG:3857", (Object)clonedBbox.getSRS());
    }
}

