/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamPersisterInitializer;
import org.geoserver.wfs.WFSXStreamPersisterInitializer;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMapping;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingDefaultValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingExpressionValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.StoredQueryConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WFSCascadedStoredQueryConfigurationParserTest {
    private XStreamPersister persister;

    @Before
    public void setup() {
        XStreamPersisterFactory xpf = new XStreamPersisterFactory();
        WFSXStreamPersisterInitializer initializer = new WFSXStreamPersisterInitializer();
        xpf.addInitializer((XStreamPersisterInitializer)initializer);
        this.persister = xpf.createXMLPersister();
    }

    @Test
    public void testDeserialization() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<storedQueryConfiguration>\n  <storedQueryParameterMappings>\n    <storedQueryParameterMappingExpressionValue>\n      <parameterName>bbox</parameterName>\n      <expressionLanguage>CQL</expressionLanguage>\n      <expression>strConCat(numberFormat(&apos;0.00000000000&apos;, bboxMinY), strConCat(&apos;,&apos;, strConCat(numberFormat(&apos;0.00000000000&apos;, bboxMinX), strConCat(&apos;,&apos;, strConCat(numberFormat(&apos;0.00000000000&apos;, bboxMaxY), strConCat(&apos;,&apos;, strConCat(numberFormat(&apos;0.00000000000&apos;, bboxMaxX), &apos;,EPSG:4258&apos;)))))))</expression>\n    </storedQueryParameterMappingExpressionValue>\n    <storedQueryParameterMappingDefaultValue>\n      <parameterName>timestep</parameterName>\n      <defaultValue>720</defaultValue>\n    </storedQueryParameterMappingDefaultValue>\n  </storedQueryParameterMappings>\n</storedQueryConfiguration>";
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        StoredQueryConfiguration configuration = (StoredQueryConfiguration)this.persister.load((InputStream)bais, StoredQueryConfiguration.class);
        Assert.assertNotNull((Object)configuration);
        Assert.assertEquals((long)2L, (long)configuration.getStoredQueryParameterMappings().size());
        Assert.assertEquals(ParameterMappingExpressionValue.class, ((ParameterMapping)configuration.getStoredQueryParameterMappings().get(0)).getClass());
        Assert.assertEquals(ParameterMappingDefaultValue.class, ((ParameterMapping)configuration.getStoredQueryParameterMappings().get(1)).getClass());
        ParameterMappingExpressionValue map1 = (ParameterMappingExpressionValue)configuration.getStoredQueryParameterMappings().get(0);
        Assert.assertEquals((Object)"bbox", (Object)map1.getParameterName());
        Assert.assertEquals((Object)"CQL", (Object)map1.getExpressionLanguage());
        Assert.assertEquals((Object)"strConCat(numberFormat('0.00000000000', bboxMinY), strConCat(',', strConCat(numberFormat('0.00000000000', bboxMinX), strConCat(',', strConCat(numberFormat('0.00000000000', bboxMaxY), strConCat(',', strConCat(numberFormat('0.00000000000', bboxMaxX), ',EPSG:4258')))))))", (Object)map1.getExpression());
        ParameterMappingDefaultValue map2 = (ParameterMappingDefaultValue)configuration.getStoredQueryParameterMappings().get(1);
        Assert.assertEquals((Object)"timestep", (Object)map2.getParameterName());
        Assert.assertEquals((Object)"720", (Object)map2.getDefaultValue());
    }

    @Test
    public void testSerialization() throws Exception {
        StoredQueryConfiguration mockConfiguration = new StoredQueryConfiguration();
        ParameterMappingExpressionValue param1 = new ParameterMappingExpressionValue();
        param1.setParameterName("bbox");
        param1.setExpressionLanguage("CQL");
        param1.setExpression("strConCat(numberFormat('0.00000000000', bboxMinY), strConCat(',', strConCat(numberFormat('0.00000000000', bboxMinX), strConCat(',', strConCat(numberFormat('0.00000000000', bboxMaxY), strConCat(',', strConCat(numberFormat('0.00000000000', bboxMaxX), ',EPSG:4258')))))))");
        mockConfiguration.getStoredQueryParameterMappings().add(param1);
        ParameterMappingDefaultValue param2 = new ParameterMappingDefaultValue();
        param2.setParameterName("timestep");
        param2.setDefaultValue("720");
        mockConfiguration.getStoredQueryParameterMappings().add(param2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.persister.save((Object)mockConfiguration, (OutputStream)baos);
        baos.flush();
        String xml = new String(baos.toByteArray(), "UTF-8");
        System.err.println(xml);
        Assert.assertTrue((boolean)xml.contains("numberFormat"));
    }
}

