/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.List;
import net.opengis.wfs.DeleteElementType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.UpdateElementType;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListenerTester;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.w3c.dom.Document;

public class TransactionListenerTest
extends WFSTestSupport {
    TransactionListenerTester listener;

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wfs/TransactionListenerTestContext.xml");
    }

    @Before
    public void clearState() throws Exception {
        this.listener = (TransactionListenerTester)applicationContext.getBean("transactionListenerTester");
        this.listener.clear();
    }

    @Test
    public void testDelete() throws Exception {
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cgf:Points\"> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>cgf:id</ogc:PropertyName> <ogc:Literal>t0000</ogc:Literal> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        this.postAsDOM("wfs", delete);
        Assert.assertEquals((long)1L, (long)this.listener.events.size());
        TransactionEvent event = (TransactionEvent)this.listener.events.get(0);
        Assert.assertTrue((boolean)(event.getSource() instanceof DeleteElementType));
        Assert.assertEquals((Object)TransactionEventType.PRE_DELETE, (Object)event.getType());
        Assert.assertEquals((Object)CiteTestData.POINTS, (Object)event.getLayerName());
        Assert.assertEquals((long)1L, (long)this.listener.features.size());
        Feature deleted = (Feature)this.listener.features.get(0);
        Assert.assertEquals((Object)"t0000", (Object)deleted.getProperty("id").getValue());
    }

    @Test
    public void testInsert() throws Exception {
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:Lines></wfs:Insert></wfs:Transaction>";
        this.postAsDOM("wfs", insert);
        Assert.assertEquals((long)2L, (long)this.listener.events.size());
        TransactionEvent firstEvent = (TransactionEvent)this.listener.events.get(0);
        Assert.assertTrue((boolean)(firstEvent.getSource() instanceof InsertElementType));
        Assert.assertEquals((Object)TransactionEventType.PRE_INSERT, (Object)firstEvent.getType());
        Assert.assertEquals((Object)CiteTestData.LINES, (Object)firstEvent.getLayerName());
        Assert.assertEquals((long)2L, (long)this.listener.features.size());
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Lines\"> <ogc:PropertyName>id</ogc:PropertyName> <ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        String fid = dom.getElementsByTagName("cgf:Lines").item(0).getAttributes().item(0).getNodeValue();
        TransactionEvent secondEvent = (TransactionEvent)this.listener.events.get(1);
        Assert.assertTrue((boolean)(secondEvent.getSource() instanceof InsertElementType));
        Assert.assertEquals((Object)TransactionEventType.POST_INSERT, (Object)secondEvent.getType());
        Feature inserted = (Feature)this.listener.features.get(1);
        Assert.assertEquals((Object)fid, (Object)inserted.getIdentifier().getID());
    }

    @Test
    public void testUpdate() throws Exception {
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cgf:Polygons\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        this.postAsDOM("wfs", insert);
        Assert.assertEquals((long)2L, (long)this.listener.events.size());
        TransactionEvent firstEvent = (TransactionEvent)this.listener.events.get(0);
        Assert.assertTrue((boolean)(firstEvent.getSource() instanceof UpdateElementType));
        Assert.assertEquals((Object)TransactionEventType.PRE_UPDATE, (Object)firstEvent.getType());
        Assert.assertEquals((Object)CiteTestData.POLYGONS, (Object)firstEvent.getLayerName());
        Feature updatedBefore = (Feature)this.listener.features.get(0);
        Assert.assertEquals((Object)"t0002", (Object)updatedBefore.getProperty("id").getValue());
        TransactionEvent secondEvent = (TransactionEvent)this.listener.events.get(1);
        Assert.assertTrue((boolean)(secondEvent.getSource() instanceof UpdateElementType));
        Assert.assertEquals((Object)TransactionEventType.POST_UPDATE, (Object)secondEvent.getType());
        Assert.assertEquals((Object)CiteTestData.POLYGONS, (Object)secondEvent.getLayerName());
        Feature updatedAfter = (Feature)this.listener.features.get(1);
        Assert.assertEquals((Object)"t0003", (Object)updatedAfter.getProperty("id").getValue());
        Assert.assertEquals((long)2L, (long)this.listener.features.size());
    }
}

