/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.List;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.TransactionCallbackTester;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class TransactionCallbackWFS20Test
extends WFS20TestSupport {
    public static final String DELETE_ROAD_102 = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Delete typeName=\"cite:RoadSegments\">   <fes:Filter>     <fes:PropertyIsEqualTo>       <fes:ValueReference>FID</fes:ValueReference>       <fes:Literal>102</fes:Literal>     </fes:PropertyIsEqualTo>   </fes:Filter> </wfs:Delete></wfs:Transaction>";
    private TransactionCallbackTester plugin;

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wfs/TransactionCallbackTestContext.xml");
    }

    @Before
    public void clearState() throws Exception {
        this.revertLayer(MockData.ROAD_SEGMENTS);
        this.plugin = (TransactionCallbackTester)applicationContext.getBean("transactionCallbackTester");
        this.plugin.clear();
    }

    @Test
    public void testInsert() throws Exception {
        String insert = "<wfs:Transaction service='WFS' version='2.0.0' xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Insert > <cgf:Points><cgf:pointProperty><gml:Point><gml:pos>20 40</gml:pos></gml:Point></cgf:pointProperty><cgf:id>t0003</cgf:id></cgf:Points></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", insert);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalInserted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalUpdated", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalDeleted", (Document)dom);
        Assert.assertTrue((boolean)this.plugin.beforeCommitCalled);
        Assert.assertTrue((boolean)this.plugin.committed);
        Assert.assertTrue((boolean)this.plugin.dataStoreChanged);
        Assert.assertEquals((long)1L, (long)this.plugin.result.getTotalInserted().intValue());
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalUpdated().intValue());
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalDeleted().intValue());
        Document pointFeatures = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetFeature&typeName=cgf:Points&CQL_FILTER=id='t0003-modified'");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cgf:Points)", (Document)pointFeatures);
    }

    @Test
    public void testUpdate() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"2.0.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'> <wfs:Update typeName=\"cite:RoadSegments\">   <wfs:Property>     <wfs:ValueReference>cite:the_geom</wfs:ValueReference>     <wfs:Value>      <gml:MultiCurve>       <gml:curveMember>         <gml:LineString>            <gml:posList>4.2582 52.0643 4.2584 52.0648</gml:posList>         </gml:LineString>       </gml:curveMember>      </gml:MultiCurve>     </wfs:Value>   </wfs:Property>   <fes:Filter>     <fes:PropertyIsEqualTo>       <fes:ValueReference>FID</fes:ValueReference>       <fes:Literal>102</fes:Literal>     </fes:PropertyIsEqualTo>   </fes:Filter> </wfs:Update></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalInserted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalDeleted", (Document)dom);
        Assert.assertTrue((boolean)this.plugin.beforeCommitCalled);
        Assert.assertTrue((boolean)this.plugin.committed);
        Assert.assertTrue((boolean)this.plugin.dataStoreChanged);
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalInserted().intValue());
        Assert.assertEquals((long)1L, (long)this.plugin.result.getTotalUpdated().intValue());
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalDeleted().intValue());
        Document roadSegments = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=cite:RoadSegments&CQL_FILTER=FID=102");
        XMLAssert.assertXpathEvaluatesTo((String)"Folsom Street", (String)"//cite:RoadSegments/cite:NAME", (Document)roadSegments);
    }

    @Test
    public void testDelete() throws Exception {
        String xml = DELETE_ROAD_102;
        Document dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalInserted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalUpdated", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"//wfs:totalDeleted", (Document)dom);
        Assert.assertTrue((boolean)this.plugin.beforeCommitCalled);
        Assert.assertTrue((boolean)this.plugin.committed);
        Assert.assertTrue((boolean)this.plugin.dataStoreChanged);
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalInserted().intValue());
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalUpdated().intValue());
        Assert.assertEquals((long)4L, (long)this.plugin.result.getTotalDeleted().intValue());
        Document roadSegments = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=cite:RoadSegments");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:RoadSegments)", (Document)roadSegments);
        XMLAssert.assertXpathEvaluatesTo((String)"102", (String)"//cite:RoadSegments/cite:FID", (Document)roadSegments);
    }

    @Test
    public void testReplaceWithInsert() throws Exception {
        this.plugin.beforeTransaction = TransactionCallbackTester::replaceWithFixedRoadsInsert;
        String xml = DELETE_ROAD_102;
        Document dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalInserted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalUpdated", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalDeleted", (Document)dom);
        Assert.assertTrue((boolean)this.plugin.beforeCommitCalled);
        Assert.assertTrue((boolean)this.plugin.committed);
        Assert.assertTrue((boolean)this.plugin.dataStoreChanged);
        Assert.assertEquals((long)1L, (long)this.plugin.result.getTotalInserted().intValue());
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalUpdated().intValue());
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalDeleted().intValue());
        Document roadSegments = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=cite:RoadSegments");
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//cite:RoadSegments)", (Document)roadSegments);
        XMLAssert.assertXpathEvaluatesTo((String)"New Road", (String)"//cite:RoadSegments[cite:FID = 107]/cite:NAME", (Document)roadSegments);
    }

    @Test
    public void testReplaceWithUpdate() throws Exception {
        this.plugin.beforeTransaction = TransactionCallbackTester::replaceWithFixedRoadsUpdate;
        String xml = DELETE_ROAD_102;
        Document dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalInserted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalDeleted", (Document)dom);
        Assert.assertTrue((boolean)this.plugin.beforeCommitCalled);
        Assert.assertTrue((boolean)this.plugin.committed);
        Assert.assertTrue((boolean)this.plugin.dataStoreChanged);
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalInserted().intValue());
        Assert.assertEquals((long)1L, (long)this.plugin.result.getTotalUpdated().intValue());
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalDeleted().intValue());
        Document roadSegments = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=cite:RoadSegments");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(//cite:RoadSegments)", (Document)roadSegments);
        XMLAssert.assertXpathEvaluatesTo((String)"Clean Road", (String)"//cite:RoadSegments[cite:FID = 106]/cite:NAME", (Document)roadSegments);
    }

    @Test
    public void testReplaceWithDelete() throws Exception {
        this.plugin.beforeTransaction = TransactionCallbackTester::replaceWithFixedRoadsDelete;
        String xml = DELETE_ROAD_102;
        Document dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalInserted", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wfs:totalUpdated", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalDeleted", (Document)dom);
        Assert.assertTrue((boolean)this.plugin.beforeCommitCalled);
        Assert.assertTrue((boolean)this.plugin.committed);
        Assert.assertTrue((boolean)this.plugin.dataStoreChanged);
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalInserted().intValue());
        Assert.assertEquals((long)0L, (long)this.plugin.result.getTotalUpdated().intValue());
        Assert.assertEquals((long)1L, (long)this.plugin.result.getTotalDeleted().intValue());
        Document roadSegments = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=cite:RoadSegments");
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//cite:RoadSegments)", (Document)roadSegments);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//cite:RoadSegments[cite:FID = 106])", (Document)roadSegments);
    }
}

