/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import net.opengis.wfs20.StoredQueryDescriptionType;
import org.easymock.classextension.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StoredQueryProviderTest {
    public static final String MY_STORED_QUERY = "MyStoredQuery";
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    public static final String MY_STORED_QUERY_DEFINITION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wfs:StoredQueryDescription id='MyStoredQuery' xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\">>\n  <wfs:Parameter name='AreaOfInterest' type='gml:Polygon'/>\n  <wfs:QueryExpressionText\n   returnFeatureTypes='topp:states'\n   language='urn:ogc:def:queryLanguage:OGC-WFS::WFS_QueryExpression'\n   isPrivate='false'>\n    <wfs:Query typeNames='topp:states'>\n      <fes:Filter>\n        <fes:Within>\n          <fes:ValueReference>the_geom</fes:ValueReference>\n           ${AreaOfInterest}\n        </fes:Within>\n      </fes:Filter>\n    </wfs:Query>\n  </wfs:QueryExpressionText>\n</wfs:StoredQueryDescription>";
    private StoredQueryProvider storedQueryProvider;
    private File baseDirectory;
    private Catalog catalog;
    private GeoServerResourceLoader loader;

    @Before
    public void setup() throws IOException {
        this.baseDirectory = this.tmpFolder.newFolder();
        this.catalog = (Catalog)EasyMock.createMock(Catalog.class);
        this.loader = new GeoServerResourceLoader(this.baseDirectory);
        org.easymock.EasyMock.expect((Object)this.catalog.getResourceLoader()).andReturn((Object)this.loader);
        org.easymock.EasyMock.replay((Object[])new Object[]{this.catalog});
        this.storedQueryProvider = new StoredQueryProvider(this.catalog);
    }

    @Test
    public void whenNoStoredQueriesDefinedAGetFeatureByIdQueryIsReturned() {
        List queries = this.storedQueryProvider.listStoredQueries();
        Assert.assertThat((Object)queries, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((StoredQuery)queries.get(0)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"urn:ogc:def:query:OGC-WFS::GetFeatureById")));
        Assert.assertThat((Object)this.storedQueryProvider.getStoredQuery("urn:ogc:def:query:OGC-WFS::GetFeatureById"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void whenBogusStoredQueryDefinitionCreatedItIsNotReturnedInTheListOfStoredQueries() throws IOException {
        this.createMyStoredQueryDefinitionFile(this.storedQueryProvider.storedQueryDir().dir());
        this.createMyBogusStoredQueryDefinition();
        List queries = this.storedQueryProvider.listStoredQueries();
        Assert.assertThat((Object)queries, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.storedQueryProvider.getStoredQuery("urn:ogc:def:query:OGC-WFS::GetFeatureById"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)this.storedQueryProvider.getStoredQuery(MY_STORED_QUERY), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void whenStoredQueryDefinitionCreatedByFileItIsReturnedInTheListOfStoredQueries() throws IOException {
        this.createMyStoredQueryDefinitionFile(this.storedQueryProvider.storedQueryDir().dir());
        List queries = this.storedQueryProvider.listStoredQueries();
        Assert.assertThat((Object)queries, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.storedQueryProvider.getStoredQuery("urn:ogc:def:query:OGC-WFS::GetFeatureById"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)this.storedQueryProvider.getStoredQuery(MY_STORED_QUERY).getName(), (Matcher)Matchers.is((Object)MY_STORED_QUERY));
    }

    @Test
    public void whenStoredQueryDefinitionCreatedByDescriptionItIsReturnedInTheListOfStoredQueries() throws Exception {
        StoredQueryDescriptionType storedQueryDescriptionType = this.createMyStoredQueryDefinitionInStoredQueryDescriptionType();
        StoredQuery result = this.storedQueryProvider.createStoredQuery(storedQueryDescriptionType);
        Assert.assertThat((Object)result.getName(), (Matcher)Matchers.is((Object)MY_STORED_QUERY));
        Assert.assertThat((Object)this.storedQueryProvider.getStoredQuery(MY_STORED_QUERY).getName(), (Matcher)Matchers.is((Object)MY_STORED_QUERY));
    }

    @Test
    public void storedQueryDefinitionIsNotRewrittenByListingTheQueries() throws IOException {
        File myStoredQueryDefinition = this.createMyStoredQueryDefinitionFile(this.storedQueryProvider.storedQueryDir().dir());
        try {
            myStoredQueryDefinition.setReadOnly();
            List queries = this.storedQueryProvider.listStoredQueries();
            Assert.assertThat((Object)queries, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat((Object)this.storedQueryProvider.getStoredQuery("urn:ogc:def:query:OGC-WFS::GetFeatureById"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)this.storedQueryProvider.getStoredQuery(MY_STORED_QUERY).getName(), (Matcher)Matchers.is((Object)MY_STORED_QUERY));
        }
        finally {
            myStoredQueryDefinition.setWritable(true);
        }
    }

    @Test
    public void canRemoveStoredQueryDefinition() throws IOException {
        File myStoredQueryDefinition = this.createMyStoredQueryDefinitionFile(this.storedQueryProvider.storedQueryDir().dir());
        List queries = this.storedQueryProvider.listStoredQueries();
        Assert.assertThat((Object)queries, (Matcher)Matchers.hasSize((int)2));
        StoredQuery myStoredQuery = this.storedQueryProvider.getStoredQuery(MY_STORED_QUERY);
        Assert.assertThat((Object)myStoredQuery.getName(), (Matcher)Matchers.is((Object)MY_STORED_QUERY));
        this.storedQueryProvider.removeStoredQuery(myStoredQuery);
        Assert.assertThat((Object)myStoredQueryDefinition.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.storedQueryProvider.getStoredQuery(myStoredQuery.getName()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void canRemoveAllStoredQueryDefinitions() throws IOException {
        File myStoredQueryDefinition = this.createMyStoredQueryDefinitionFile(this.storedQueryProvider.storedQueryDir().dir());
        List queries = this.storedQueryProvider.listStoredQueries();
        Assert.assertThat((Object)queries, (Matcher)Matchers.hasSize((int)2));
        this.storedQueryProvider.removeAll();
        Assert.assertThat((Object)myStoredQueryDefinition.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.storedQueryProvider.getStoredQuery(MY_STORED_QUERY), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetLanguage() {
        Assert.assertThat((Object)this.storedQueryProvider.getLanguage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)StoredQueryProvider.LANGUAGE_20)));
    }

    private File createMyStoredQueryDefinitionFile(File storedQueryDir) throws IOException {
        File storedQueryDefinition = new File(storedQueryDir, "MyStoredQuery.xml");
        FileWriter writer = new FileWriter(storedQueryDefinition);
        writer.write(MY_STORED_QUERY_DEFINITION);
        ((Writer)writer).close();
        return storedQueryDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoredQueryDescriptionType createMyStoredQueryDefinitionInStoredQueryDescriptionType() throws Exception {
        Parser p = new Parser((Configuration)new WFSConfiguration());
        p.setRootElementType(WFS.StoredQueryDescriptionType);
        try (StringReader reader = new StringReader(MY_STORED_QUERY_DEFINITION);){
            StoredQueryDescriptionType storedQueryDescriptionType = (StoredQueryDescriptionType)p.parse((Reader)reader);
            return storedQueryDescriptionType;
        }
    }

    private File createMyBogusStoredQueryDefinition() throws IOException {
        File storedQueryDir = this.storedQueryProvider.storedQueryDir().dir();
        File storedQueryDefinition = new File(storedQueryDir, "MyBogusStoredQuery.xml");
        FileWriter writer = new FileWriter(storedQueryDefinition);
        writer.write("This is not a well-formed query");
        ((Writer)writer).close();
        return storedQueryDefinition;
    }
}

