/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessMode;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SecuredGetFeatureTest
extends WFSTestSupport {
    public static QName NULL_GEOMETRIES = new QName(SystemTestData.CITE_URI, "NullGeometries", SystemTestData.CITE_PREFIX);

    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        this.addUser("cite", "cite", null, Collections.singletonList("ROLE_CITE_READER"));
        this.addLayerAccessRule("*", "*", AccessMode.READ, new String[]{"ROLE_NO_ONE"});
        this.addLayerAccessRule("*", "*", AccessMode.WRITE, new String[]{"ROLE_NO_ONE"});
        this.addLayerAccessRule(SystemTestData.CITE_PREFIX, "*", AccessMode.READ, new String[]{"ROLE_CITE_READER"});
    }

    protected List<Filter> getFilters() {
        return Collections.singletonList((Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Test
    public void testGetNoAuthHide() throws Exception {
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        dao.setCatalogMode(CatalogMode.HIDE);
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        this.checkOws10Exception(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Unknown namespace [cite]", (String)"//ows:ExceptionText/text()", (Document)doc);
    }

    @Test
    public void testGetNoAuthChallenge() throws Exception {
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        dao.setCatalogMode(CatalogMode.CHALLENGE);
        dao.storeRules();
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        Assert.assertEquals((long)401L, (long)resp.getStatus());
        Assert.assertEquals((Object)"Basic realm=\"GeoServer Realm\"", (Object)resp.getHeader("WWW-Authenticate"));
    }

    @Test
    public void testInvalidAuthChallenge() throws Exception {
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        dao.setCatalogMode(CatalogMode.CHALLENGE);
        MockHttpServletRequest request = this.createRequest("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])"cite:wrongpassword".getBytes()))));
        MockHttpServletResponse resp = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)401L, (long)resp.getStatus());
        Assert.assertEquals((Object)"Basic realm=\"GeoServer Realm\"", (Object)resp.getHeader("WWW-Authenticate"));
    }

    @Test
    public void testValidAuth() throws Exception {
        this.checkValidAuth("cite", "cite");
    }

    @Test
    public void testValidAuthAdmin() throws Exception {
        this.checkValidAuth("admin", "geoserver");
    }

    private void checkValidAuth(String username, String password) throws Exception, ParserConfigurationException, SAXException, IOException, XpathException {
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        dao.setCatalogMode(CatalogMode.CHALLENGE);
        this.setRequestAuth(username, password);
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/wfs:FeatureCollection)", (Document)doc);
    }
}

