/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class ResourceAccessManagerWFSTest
extends WFSTestSupport {
    static final String INSERT_RESTRICTED_STREET = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\"\n  xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:cite=\"http://www.opengis.net/cite\"\n  xmlns:gml=\"http://www.opengis.net/gml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.0.0/WFS-transaction.xsd \">\n  <wfs:Insert>\n    <cite:Buildings fid=\"Buildings.123\">\n      <cite:the_geom>\n        <gml:MultiPolygon srsName=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">\n          <gml:polygonMember>\n            <gml:Polygon>\n              <gml:outerBoundaryIs>\n                <gml:LinearRing>\n                  <gml:coordinates cs=\",\" decimal=\".\"\n                    ts=\" \" xmlns:gml=\"http://www.opengis.net/gml\">0.0020,0.0008 0.0020,0.0010\n                    0.0024,0.0010 0.0024,0.0008 0.0020,0.0008</gml:coordinates>\n                </gml:LinearRing>\n              </gml:outerBoundaryIs>\n            </gml:Polygon>\n          </gml:polygonMember>\n        </gml:MultiPolygon>\n      </cite:the_geom>\n      <cite:FID>151</cite:FID>\n      <cite:ADDRESS>123 Restricted Street</cite:ADDRESS>\n    </cite:Buildings>\n  </wfs:Insert>\n</wfs:Transaction>";
    static final String UPDATE_ADDRESS = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\"\n  xmlns:cite=\"http://www.opengis.net/cite\"\n  xmlns:ogc=\"http://www.opengis.net/ogc\"\n  xmlns:wfs=\"http://www.opengis.net/wfs\">\n  <wfs:Update typeName=\"cite:Buildings\">\n    <wfs:Property>\n      <wfs:Name>ADDRESS</wfs:Name>\n      <wfs:Value>123 ABC Street</wfs:Value>\n    </wfs:Property>\n  </wfs:Update>\n</wfs:Transaction>";
    static final String DELETE_ADDRESS = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\"\n  xmlns:cite=\"http://www.opengis.net/cite\"\n  xmlns:ogc=\"http://www.opengis.net/ogc\"\n  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\">\n  <wfs:Delete typeName=\"cite:Buildings\">  <ogc:Filter>\n    <ogc:BBOX>\n        <ogc:PropertyName>the_geom</ogc:PropertyName>\n        <gml:Envelope srsName=\"http://www.opengis.net/gml/srs/epsg.xml#4326\">\n           <gml:lowerCorner>-180 -90</gml:lowerCorner>\n           <gml:upperCorner>180 90</gml:upperCorner>\n        </gml:Envelope>\n      </ogc:BBOX>\n  </ogc:Filter>\n  </wfs:Delete>\n</wfs:Transaction>";

    @Before
    public void revert() throws Exception {
        this.revertLayer(CiteTestData.BUILDINGS);
    }

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wfs/ResourceAccessManagerContext.xml");
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        this.addUser("cite", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        this.addUser("cite_readfilter", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        this.addUser("cite,ROLE_DUMMY", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        this.addUser("cite_readatts", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        this.addUser("cite_readattsnf", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        this.addUser("cite_insertfilter", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        this.addUser("cite_writefilter", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        this.addUser("cite_writeatts", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        this.addUser("cite_mixed", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo buildings = catalog.getFeatureTypeByName(this.getLayerId(SystemTestData.BUILDINGS));
        PropertyIsEqualTo fid113 = ff.equal((Expression)ff.property("FID"), (Expression)ff.literal((Object)"113"), false);
        tam.putLimits("cite_readfilter", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, (Filter)fid113, null, null));
        List<PropertyName> readAtts = Arrays.asList(ff.property("the_geom"), ff.property("FID"));
        tam.putLimits("cite_readatts", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, readAtts, (Filter)fid113, null, null));
        tam.putLimits("cite_readattsnf", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, readAtts, (Filter)Filter.INCLUDE, null, (Filter)Filter.INCLUDE));
        Not restrictedStreet = ff.not((Filter)ff.like((Expression)ff.property("ADDRESS"), "*Restricted Street*", "*", "?", "\\"));
        tam.putLimits("cite_insertfilter", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, null, null, (Filter)restrictedStreet));
        tam.putLimits("cite_writefilter", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, null, null, (Filter)fid113));
        List<PropertyName> writeAtts = Arrays.asList(ff.property("the_geom"), ff.property("FID"));
        tam.putLimits("cite_writeatts", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, null, writeAtts, null));
        tam.putLimits("cite_mixed", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.MIXED, null, (Filter)Filter.EXCLUDE, null, (Filter)Filter.EXCLUDE));
    }

    @Test
    public void testNoLimits() throws Exception {
        this.setRequestAuth("cite", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//cite:Buildings)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//cite:ADDRESS)", (Document)doc);
    }

    @Test
    public void testReadFilter() throws Exception {
        this.setRequestAuth("cite_readfilter", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"113", (String)"//cite:FID", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:ADDRESS)", (Document)doc);
    }

    @Test
    public void testReadFilterReproject() throws Exception {
        this.setRequestAuth("cite_readfilter", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS) + "&srsName=EPSG:4269");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"113", (String)"//cite:FID", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:ADDRESS)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.opengis.net/gml/srs/epsg.xml#4269", (String)"//gml:MultiPolygon/@srsName", (Document)doc);
    }

    @Test
    public void testFilterAttribute() throws Exception {
        this.setRequestAuth("cite_readatts", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"113", (String)"//cite:FID", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//cite:ADDRESS)", (Document)doc);
    }

    @Test
    public void testDescribeLimitedAttributes() throws Exception {
        this.setRequestAuth("admin", "geoserver");
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:element[@name='the_geom'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:element[@name='FID'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:element[@name='ADDRESS'])", (Document)doc);
        this.setRequestAuth("cite_readatts", "cite");
        doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:element[@name='the_geom'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:element[@name='FID'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//xsd:element[@name='ADDRESS'])", (Document)doc);
        this.setRequestAuth("admin", "geoserver");
        doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:element[@name='the_geom'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:element[@name='FID'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:element[@name='ADDRESS'])", (Document)doc);
    }

    @Test
    public void testCapabilitiesMixed() throws Exception {
        this.setRequestAuth("admin", "geoserver");
        Document doc = this.getAsDOM("cite/wfs?request=GetCapabilities&version=1.1.0&service=wfs");
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureType[wfs:Name='cite:Buildings'])", (Document)doc);
        this.setRequestAuth("cite_mixed", "cite");
        doc = this.getAsDOM("cite/wfs?request=GetCapabilities&version=1.1.0&service=wfs");
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wfs:FeatureType[wfs:Name='cite:Buildings'])", (Document)doc);
    }

    @Test
    public void testDescribeMixed() throws Exception {
        this.setRequestAuth("admin", "geoserver");
        Document doc = this.getAsDOM("cite/wfs?request=DescribeFeatureType&version=1.1.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:complexType[@name='BuildingsType'])", (Document)doc);
        this.setRequestAuth("cite_mixed", "cite");
        doc = this.getAsDOM("cite/wfs?request=DescribeFeatureType&version=1.1.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//xsd:complexType[@name='BuildingsType'])", (Document)doc);
        this.setRequestAuth("cite_mixed", "cite");
        MockHttpServletResponse response = this.getAsServletResponse("cite/wfs?request=DescribeFeatureType&version=1.1.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void testFilterRequestedAttribute() throws Exception {
        this.setRequestAuth("cite_readatts", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS) + "&propertyName=FID,ADDRESS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)doc);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String message = xpath.evaluate("//ows:ExceptionText", doc);
        Pattern pattern = Pattern.compile(".*ADDRESS.*not available.*", 40);
        junit.framework.Assert.assertTrue((boolean)pattern.matcher(message).matches());
    }

    @Test
    public void testExtraAttributesNoFilter() throws Exception {
        this.setRequestAuth("cite_readattsnf", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS) + "&propertyName=FID,ADDRESS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)doc);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String message = xpath.evaluate("//ows:ExceptionText", doc);
        Pattern pattern = Pattern.compile(".*ADDRESS.*not available.*", 40);
        junit.framework.Assert.assertTrue((boolean)pattern.matcher(message).matches());
    }

    @Test
    public void testLimitAttributesNoFilter() throws Exception {
        this.setRequestAuth("cite_readattsnf", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//cite:ADDRESS)", (Document)doc);
    }

    @Test
    public void testInsertNoLimits() throws Exception {
        this.setRequestAuth("cite", "cite");
        Document dom = this.postAsDOM("wfs", INSERT_RESTRICTED_STREET);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:WFS_TransactionResponse)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:FeatureId)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"new0", (String)"//ogc:FeatureId/@fid", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:Status/wfs:SUCCESS)", (Document)dom);
    }

    @Test
    public void testInsertRestricted() throws Exception {
        this.setRequestAuth("cite_insertfilter", "cite");
        Document dom = this.postAsDOM("wfs", INSERT_RESTRICTED_STREET);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:WFS_TransactionResponse)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:Status/wfs:FAILED)", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String message = xpath.evaluate("//wfs:Message", dom);
        junit.framework.Assert.assertTrue((boolean)message.matches(".*write restrictions.*"));
    }

    @Test
    public void testInsertAttributeRestricted() throws Exception {
        this.setRequestAuth("cite_writeatts", "cite");
        Document dom = this.postAsDOM("wfs", INSERT_RESTRICTED_STREET);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:WFS_TransactionResponse)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:Status/wfs:FAILED)", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String message = xpath.evaluate("//wfs:Message", dom);
        junit.framework.Assert.assertTrue((boolean)message.matches(".*write protected.*ADDRESS.*"));
    }

    @Test
    public void testUpdateNoLimits() throws Exception {
        this.setRequestAuth("cite", "cite");
        Document dom = this.postAsDOM("wfs", UPDATE_ADDRESS);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"//wfs:totalUpdated", (Document)dom);
    }

    @Test
    public void testUpdateLimitWrite() throws Exception {
        this.setRequestAuth("cite_writefilter", "cite");
        Document dom = this.postAsDOM("wfs", UPDATE_ADDRESS);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalUpdated", (Document)dom);
        this.setRequestAuth("cite", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"123 ABC Street", (String)"//cite:Buildings[cite:FID = '113']/cite:ADDRESS", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"215 Main Street", (String)"//cite:Buildings[cite:FID = '114']/cite:ADDRESS", (Document)doc);
    }

    @Test
    public void testUpdateAttributeRestricted() throws Exception {
        this.setRequestAuth("cite_writeatts", "cite");
        Document dom = this.postAsDOM("wfs", UPDATE_ADDRESS);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String message = xpath.evaluate("//ows:ExceptionText", dom);
        junit.framework.Assert.assertTrue((boolean)message.matches(".*write protected.*ADDRESS.*"));
    }

    @Test
    public void testDeleteLimitWrite() throws Exception {
        this.setRequestAuth("cite_writefilter", "cite");
        Document dom = this.postAsDOM("wfs", DELETE_ADDRESS);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wfs:totalDeleted", (Document)dom);
        this.setRequestAuth("cite", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(SystemTestData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//cite:Buildings[cite:FID = '113'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings[cite:FID = '114'])", (Document)doc);
    }
}

