/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReprojectionWriteTest
extends WFSTestSupport {
    private static final String TARGET_CRS_CODE = "EPSG:900913";
    public static QName NULL_GEOMETRIES = new QName(SystemTestData.CITE_URI, "NullGeometries", SystemTestData.CITE_PREFIX);
    public static QName GOOGLE = new QName(SystemTestData.CITE_URI, "GoogleFeatures", SystemTestData.CITE_PREFIX);
    MathTransform tx;

    @Before
    public void setUpTX() throws Exception {
        CoordinateReferenceSystem epsg4326 = CRS.decode((String)TARGET_CRS_CODE);
        CoordinateReferenceSystem epsg32615 = CRS.decode((String)"EPSG:32615");
        this.tx = CRS.findMathTransform((CoordinateReferenceSystem)epsg32615, (CoordinateReferenceSystem)epsg4326);
        this.revertLayer(SystemTestData.POLYGONS);
    }

    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        dataDirectory.addVectorLayer(NULL_GEOMETRIES, Collections.EMPTY_MAP, ((Object)((Object)this)).getClass(), this.getCatalog());
        HashMap<SystemTestData.LayerProperty, Object> extra = new HashMap<SystemTestData.LayerProperty, Object>();
        extra.put(SystemTestData.LayerProperty.PROJECTION_POLICY, ProjectionPolicy.REPROJECT_TO_DECLARED);
        extra.put(SystemTestData.LayerProperty.SRS, 900913);
        dataDirectory.addVectorLayer(GOOGLE, extra, ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testInsertSrsName() throws Exception {
        String q = "wfs?request=getfeature&service=wfs&version=1.0.0&typeName=" + SystemTestData.POLYGONS.getLocalPart();
        Document dom = this.getAsDOM(q);
        Element polygonProperty = this.getFirstElementByTagName(dom, "cgf:polygonProperty");
        Element posList = this.getFirstElementByTagName(polygonProperty, "gml:coordinates");
        double[] c = this.coordinates(posList.getFirstChild().getNodeValue());
        double[] cr = new double[c.length];
        this.tx.transform(c, 0, cr, 0, cr.length / 2);
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:cgf=\"" + SystemTestData.CGF_URI + "\"><wfs:Insert handle=\"insert-1\" srsName=\"" + TARGET_CRS_CODE + "\"> <cgf:Polygons><cgf:polygonProperty><gml:Polygon ><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates>";
        int i = 0;
        while (i < cr.length) {
            xml = xml + cr[i++] + "," + cr[i++];
            if (i >= cr.length - 1) continue;
            xml = xml + " ";
        }
        xml = xml + "</gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon></cgf:polygonProperty> </cgf:Polygons></wfs:Insert></wfs:Transaction>";
        this.postAsDOM("wfs", xml);
        dom = this.getAsDOM(q);
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName(SystemTestData.POLYGONS.getPrefix() + ":" + SystemTestData.POLYGONS.getLocalPart()).getLength());
    }

    @Test
    public void testInsertGeomSrsName() throws Exception {
        String q = "wfs?request=getfeature&service=wfs&version=1.0&typeName=" + SystemTestData.POLYGONS.getLocalPart();
        Document dom = this.getAsDOM(q);
        Element polygonProperty = this.getFirstElementByTagName(dom, "cgf:polygonProperty");
        Element posList = this.getFirstElementByTagName(polygonProperty, "gml:coordinates");
        double[] c = this.coordinates(posList.getFirstChild().getNodeValue());
        double[] cr = new double[c.length];
        this.tx.transform(c, 0, cr, 0, cr.length / 2);
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:cgf=\"" + SystemTestData.CGF_URI + "\"><wfs:Insert handle=\"insert-1\"> <cgf:Polygons><cgf:polygonProperty><gml:Polygon srsName=\"" + TARGET_CRS_CODE + "\"><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates>";
        int i = 0;
        while (i < cr.length) {
            xml = xml + cr[i++] + "," + cr[i++];
            if (i >= cr.length - 1) continue;
            xml = xml + " ";
        }
        xml = xml + "</gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon></cgf:polygonProperty> </cgf:Polygons></wfs:Insert></wfs:Transaction>";
        this.postAsDOM("wfs", xml);
        dom = this.getAsDOM(q);
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName(SystemTestData.POLYGONS.getPrefix() + ":" + SystemTestData.POLYGONS.getLocalPart()).getLength());
    }

    @Test
    public void testUpdate() throws Exception {
        String q = "wfs?request=getfeature&service=wfs&version=1.0&typeName=" + SystemTestData.POLYGONS.getLocalPart();
        Document dom = this.getAsDOM(q);
        Element polygonProperty = this.getFirstElementByTagName(dom, "cgf:polygonProperty");
        Element posList = this.getFirstElementByTagName(polygonProperty, "gml:coordinates");
        double[] c = this.coordinates(posList.getFirstChild().getNodeValue());
        double[] cr = new double[c.length];
        this.tx.transform(c, 0, cr, 0, cr.length / 2);
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cgf:Polygons\" > <wfs:Property><wfs:Name>polygonProperty</wfs:Name><wfs:Value><gml:Polygon srsName=\"EPSG:900913\"><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates>";
        int i = 0;
        while (i < cr.length) {
            xml = xml + cr[i++] + "," + cr[i++];
            if (i >= cr.length - 1) continue;
            xml = xml + " ";
        }
        xml = xml + "</gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon></wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:WFS_TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Element success = this.getFirstElementByTagName(dom, "wfs:SUCCESS");
        Assert.assertNotNull((Object)success);
        dom = this.getAsDOM(q);
        polygonProperty = this.getFirstElementByTagName(dom, "cgf:polygonProperty");
        posList = this.getFirstElementByTagName(polygonProperty, "gml:coordinates");
        double[] c1 = this.coordinates(posList.getFirstChild().getNodeValue());
        Assert.assertEquals((long)c.length, (long)c1.length);
        for (int i2 = 0; i2 < c.length; ++i2) {
            int x = (int)(c[i2] + 0.5);
            int y = (int)(c1[i2] + 0.5);
            Assert.assertEquals((long)x, (long)y);
        }
    }

    private double[] coordinates(String string) {
        StringTokenizer st = new StringTokenizer(string, " ");
        double[] coordinates = new double[st.countTokens() * 2];
        int i = 0;
        while (st.hasMoreTokens()) {
            String tuple = st.nextToken();
            coordinates[i++] = Double.parseDouble(tuple.split(",")[0]);
            coordinates[i++] = Double.parseDouble(tuple.split(",")[1]);
        }
        return coordinates;
    }
}

