/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetFeatureTest
extends WFSTestSupport {
    public static QName NULL_GEOMETRIES = new QName(SystemTestData.CITE_URI, "NullGeometries", SystemTestData.CITE_PREFIX);
    public static QName FIFTEEN_DUPLICATE = new QName(SystemTestData.CITE_URI, "Fifteen", SystemTestData.CITE_PREFIX);

    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        data.addVectorLayer(NULL_GEOMETRIES, Collections.EMPTY_MAP, ((Object)((Object)this)).getClass(), this.getCatalog());
        data.addVectorLayer(FIFTEEN_DUPLICATE, Collections.EMPTY_MAP, ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Before
    public void resetFifteen() throws IOException {
        this.revertLayer(MockData.FIFTEEN);
    }

    @Test
    public void testGet() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
    }

    @Test
    public void testPostForm() throws Exception {
        String contentType = "application/x-www-form-urlencoded; charset=UTF-8";
        String body = "request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs";
        MockHttpServletRequest request = this.createRequest("wfs");
        request.setMethod("POST");
        request.setContent(body.getBytes("UTF-8"));
        request.addParameter("request", "GetFeature");
        request.addParameter("typename", "cdf:Fifteen");
        request.addParameter("version", "1.0.0");
        request.addParameter("service", "wfs");
        request.setContentType(contentType);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(response.getContentAsByteArray());){
            Document doc = this.dom(bis);
            Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
            NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
            Assert.assertEquals((long)15L, (long)featureMembers.getLength());
        }
    }

    @Test
    public void testGetPropertyNameEmpty() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs&propertyname=");
    }

    @Test
    public void testGetFilterEmpty() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs&filter=");
    }

    @Test
    public void testGetPropertyNameStar() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs&propertyname=*");
    }

    private void testGetFifteenAll(String request) throws Exception {
        Document doc = this.getAsDOM(request);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertEquals((long)15L, (long)featureMembers.getLength());
    }

    @Test
    public void testGetMissingParams() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeNameWrongParam=cdf:Fifteen&version=1.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"MissingParameterValue", (String)"//ogc:ServiceException/@code", (Document)doc);
    }

    @Test
    public void testAlienNamespace() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=youdontknowme:Fifteen&version=1.0.0&service=wfs");
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testGetNullGeometies() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=" + this.getLayerId(NULL_GEOMETRIES) + "&version=1.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:NullGeometries[@fid=\"NullGeometries.1107531701010\"]/gml:boundedBy)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//cite:NullGeometries[@fid=\"NullGeometries.1107531701011\"]/boundedBy)", (Document)doc);
    }

    @Test
    public void testGetWithFeatureId() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=cdf:Fifteen&version=1.0.0&service=wfs&featureid=Fifteen.2");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:featureMember)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Fifteen.2", (String)"//wfs:FeatureCollection/gml:featureMember/cdf:Fifteen/@fid", (Document)doc);
        doc = this.getAsDOM("wfs?request=GetFeature&typeName=cite:NamedPlaces&version=1.0.0&service=wfs&featureId=NamedPlaces.1107531895891");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:featureMember)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"NamedPlaces.1107531895891", (String)"//wfs:FeatureCollection/gml:featureMember/cite:NamedPlaces/@fid", (Document)doc);
    }

    @Test
    public void testPost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <ogc:PropertyName>cdf:string2</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPostWithFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"cdf:Other\"> <ogc:PropertyName>cdf:string2</ogc:PropertyName> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>cdf:integers</ogc:PropertyName> <ogc:Add> <ogc:Literal>4</ogc:Literal> <ogc:Literal>3</ogc:Literal> </ogc:Add> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLax() throws Exception {
        String xml = "<GetFeature version='1.1.0' xmlns:gml=\"http://www.opengis.net/gml\"> <Query typeName=\"" + SystemTestData.BUILDINGS.getLocalPart() + "\">   <PropertyName>ADDRESS</PropertyName>   <Filter>     <PropertyIsEqualTo>       <PropertyName>ADDRESS</PropertyName>       <Literal>123 Main Street</Literal>     </PropertyIsEqualTo>   </Filter> </Query></GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("cite:Buildings");
        Assert.assertEquals((long)1L, (long)featureMembers.getLength());
    }

    @Test
    public void testMixed() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <ogc:PropertyName>cdf:string2</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs?request=GetFeature", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLikeMatchCase() throws Exception {
        String xml = "<GetFeature version='1.1.0' xmlns:gml=\"http://www.opengis.net/gml\"> <Query typeName=\"" + SystemTestData.BUILDINGS.getLocalPart() + "\">   <PropertyName>ADDRESS</PropertyName>   <Filter>     <PropertyIsLike wildCard=\"*\" singleChar=\".\" escapeChar=\"\\\" matchCase=\"false\">       <PropertyName>ADDRESS</PropertyName>       <Literal>* MAIN STREET</Literal>     </PropertyIsLike>   </Filter> </Query></GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("cite:Buildings");
        Assert.assertEquals((long)2L, (long)featureMembers.getLength());
        xml = "<GetFeature version='1.1.0' xmlns:gml=\"http://www.opengis.net/gml\"> <Query typeName=\"" + SystemTestData.BUILDINGS.getLocalPart() + "\">   <PropertyName>ADDRESS</PropertyName>   <Filter>     <PropertyIsLike wildCard=\"*\" singleChar=\".\" escapeChar=\"\\\" matchCase=\"true\">       <PropertyName>ADDRESS</PropertyName>       <Literal>* MAIN STREET</Literal>     </PropertyIsLike>   </Filter> </Query></GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        featureMembers = doc.getElementsByTagName("cite:Buildings");
        Assert.assertEquals((long)0L, (long)featureMembers.getLength());
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        this.testGetFifteenAll("cdf/wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        this.testGetFifteenAll("cdf/wfs?request=GetFeature&typename=Fifteen&version=1.0.0&service=wfs");
        Document doc = this.getAsDOM("sf/wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)doc);
    }

    @Test
    public void testLayerQualified() throws Exception {
        this.testGetFifteenAll("cdf/Fifteen/wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        this.testGetFifteenAll("cdf/Fifteen/wfs?request=GetFeature&typename=Fifteen&version=1.0.0&service=wfs");
        Document doc = this.getAsDOM("cdf/Fifteen/wfs?request=GetFeature&typename=cdf:Seven&version=1.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)doc);
    }

    @Test
    public void testMultiLayer() throws Exception {
        int i;
        Document doc = this.getAsDOM("/wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BASIC_POLYGONS) + "," + this.getLayerId(SystemTestData.BRIDGES) + "&version=1.0.0&service=wfs");
        XpathEngine engine = XMLUnit.newXpathEngine();
        String schemaLocation = engine.evaluate("wfs:FeatureCollection/@xsi:schemaLocation", doc);
        Assert.assertNotNull((Object)schemaLocation);
        String[] parsedLocations = schemaLocation.split("\\s+");
        for (i = 0; i < parsedLocations.length; i += 2) {
            if (!parsedLocations[i].equals("http://www.opengis.net/cite")) continue;
            Assert.assertEquals((Object)"http://localhost:8080/geoserver/wfs?service=WFS&version=1.0.0&request=DescribeFeatureType&typeName=cite%3ABasicPolygons,cite%3ABridges", (Object)parsedLocations[i + 1]);
            break;
        }
        if (i >= parsedLocations.length) {
            Assert.fail((String)"Could not find the http://www.opengis.net/cite schema location!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStrictComplianceBBoxValidator() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        WFSInfo service = (WFSInfo)geoServer.getService(WFSInfo.class);
        try {
            service.setCiteCompliant(true);
            geoServer.save((ServiceInfo)service);
            QName typeName = MockData.FORESTS;
            String path = "ows?service=WFS&version=1.1.0&request=GetFeature&typeName=" + this.getLayerId(typeName) + "&bbox=1818131,6142575,1818198,6142642,EPSG:3857&srsName=EPSG:4326";
            Document doc = this.getAsDOM(path);
            this.print(doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)doc);
        }
        finally {
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
        }
    }

    @Test
    public void testRequestDisabledResource() throws Exception {
        Catalog catalog = this.getCatalog();
        ResourceInfo fifteen = catalog.getResourceByName(this.getLayerId(MockData.FIFTEEN), ResourceInfo.class);
        fifteen.setEnabled(false);
        catalog.save(fifteen);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"//ogc:ServiceException/@code", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"typeName", (String)"//ogc:ServiceException/@locator", (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestDisabledStore() throws Exception {
        Catalog catalog = this.getCatalog();
        StoreInfo store = catalog.getStoreByName("cdf", DataStoreInfo.class);
        try {
            store.setEnabled(false);
            catalog.save(store);
            Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=GetFeature&typename=cdf:Fifteen");
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"//ogc:ServiceException/@code", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"typeName", (String)"//ogc:ServiceException/@locator", (Document)doc);
        }
        finally {
            store.setEnabled(true);
            catalog.save(store);
        }
    }

    @Test
    public void testCQLFilter() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wfs?request=GetFeature&typename=" + layer + "&version=1.0.0&service=wfs";
        Document doc = this.getAsDOM(request);
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertTrue((featureMembers.getLength() > 0 ? 1 : 0) != 0);
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(layer);
        info.setCqlFilter("NAME LIKE 'Red%'");
        this.getCatalog().save((ResourceInfo)info);
        doc = this.getAsDOM(request);
        featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertTrue((featureMembers.getLength() == 0 ? 1 : 0) != 0);
    }
}

