/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSCurvesTestSupport;
import org.geotools.measure.Measure;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import si.uom.SI;

public class GetFeatureCurvesTest
extends WFSCurvesTestSupport {
    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Test
    public void testLinearizeWFS10() throws Exception {
        Document dom = this.getAsDOM("wfs?service=wfs&version=1.0&request=GetFeature&typeName=" + this.getLayerId(this.CURVELINES));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//gml:featureMember/cite:curvelines[@fid='cp.1']/cite:geom/gml:LineString)", dom));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//gml:featureMember/cite:curvelines[@fid='cp.2']/cite:geom/gml:LineString)", dom));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//gml:featureMember/cite:curvelines[@fid='cp.3']/cite:geom/gml:LineString)", dom));
        String coords = this.xpath.evaluate("//gml:featureMember/cite:curvelines[@fid='cp.2']/cite:geom/gml:LineString/gml:coordinates", dom);
        int coordCountDefault = coords.split("\\s+").length;
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(this.getLayerId(this.CURVELINES));
        ft.setCircularArcPresent(true);
        ft.setLinearizationTolerance(new Measure(1.0, SI.METRE));
        this.getCatalog().save((ResourceInfo)ft);
        dom = this.getAsDOM("wfs?service=wfs&version=1.0&request=GetFeature&typeName=" + this.getLayerId(this.CURVELINES));
        int coordCount100m = this.countCoordinates(dom, this.xpath, "//gml:featureMember/cite:curvelines[@fid='cp.2']/cite:geom/gml:LineString/gml:coordinates");
        Assert.assertTrue((coordCount100m > coordCountDefault ? 1 : 0) != 0);
    }

    private int countCoordinates(Document dom, XpathEngine xpath, String path) throws XpathException {
        String coords = xpath.evaluate(path, dom);
        int coordCount = coords.split("\\s+").length;
        return coordCount;
    }

    @Test
    public void testCurveLineWFS11() throws Exception {
        Document dom = this.getAsDOM("wfs?service=wfs&version=1.1&request=GetFeature&typeName=" + this.getLayerId(this.CURVELINES));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvelines[@gml:id='cp.1']/cite:geom/gml:Curve/gml:segments/gml:ArcString)", dom));
        Assert.assertEquals((long)10L, (long)this.countCoordinates(dom, this.xpath, "//cite:curvelines[@gml:id='cp.1']/cite:geom/gml:Curve/gml:segments/gml:ArcString/gml:posList"));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvelines[@gml:id='cp.1']/cite:geom/gml:Curve/gml:segments/gml:LineStringSegment)", dom));
        Assert.assertEquals((long)8L, (long)this.countCoordinates(dom, this.xpath, "//cite:curvelines[@gml:id='cp.1']/cite:geom/gml:Curve/gml:segments/gml:LineStringSegment/gml:posList"));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvelines[@gml:id='cp.2']/cite:geom/gml:Curve/gml:segments/gml:ArcString)", dom));
        Assert.assertEquals((long)10L, (long)this.countCoordinates(dom, this.xpath, "//cite:curvelines[@gml:id='cp.2']/cite:geom/gml:Curve/gml:segments/gml:ArcString/gml:posList"));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvelines[@gml:id='cp.3']/cite:geom/gml:Curve/gml:segments/gml:ArcString)", dom));
        Assert.assertEquals((long)10L, (long)this.countCoordinates(dom, this.xpath, "//cite:curvelines[@gml:id='cp.3']/cite:geom/gml:Curve/gml:segments/gml:ArcString/gml:posList"));
    }

    @Test
    public void testCurveMultiLineWFS11() throws Exception {
        Document dom = this.getAsDOM("wfs?service=wfs&version=1.1&request=GetFeature&typeName=" + this.getLayerId(this.CURVEMULTILINES) + "&featureid=cp.1");
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvemultilines[@gml:id='cp.1']/cite:geom/gml:MultiCurve/gml:curveMember/gml:LineString)", dom));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvemultilines[@gml:id='cp.1']/cite:geom/gml:MultiCurve/gml:curveMember/gml:Curve)", dom));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvemultilines[@gml:id='cp.1']/cite:geom/gml:MultiCurve/gml:curveMember/gml:Curve/gml:segments/gml:ArcString)", dom));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvemultilines[@gml:id='cp.1']/cite:geom/gml:MultiCurve/gml:curveMember/gml:Curve/gml:segments/gml:ArcString)", dom));
    }

    @Test
    public void testCurvePolygons() throws Exception {
        Document dom = this.getAsDOM("wfs?service=wfs&version=1.1&request=GetFeature&typeName=" + this.getLayerId(this.CURVEPOLYGONS) + "&featureid=cp.1");
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvepolygons[@gml:id='cp.1']/cite:geom/gml:Polygon/gml:exterior/gml:Ring/gml:curveMember/gml:Curve/gml:segments/gml:ArcString)", dom));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvepolygons[@gml:id='cp.1']/cite:geom/gml:Polygon/gml:exterior/gml:Ring/gml:curveMember/gml:LineString)", dom));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvepolygons[@gml:id='cp.1']/cite:geom/gml:Polygon/gml:interior/gml:Ring/gml:curveMember/gml:Curve/gml:segments/gml:ArcString)", dom));
    }
}

