/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.List;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.GetFeatureCallbackTester;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.data.Query;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class GetFeatureCallbackTest
extends WFSTestSupport {
    private GetFeatureCallbackTester tester;

    @Before
    public void getTester() throws Exception {
        this.tester = (GetFeatureCallbackTester)applicationContext.getBean(GetFeatureCallbackTester.class);
        this.tester.clear();
    }

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wfs/GetFeatureCallbackTesterContext.xml");
    }

    @Test
    public void testNoOp() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)"count(//cdf:Fifteen)", (Document)doc);
    }

    @Test
    public void testAlterQuery() throws Exception {
        this.tester.contextConsumer = ctx -> {
            Query query = new Query(ctx.getQuery());
            try {
                query.setFilter(CQL.toFilter((String)"NAME = 'Main Street'"));
                ctx.setQuery(query);
            }
            catch (CQLException e) {
                throw new RuntimeException(e);
            }
        };
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&version=1.1.0&service=wfs");
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:RoadSegments)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Main Street", (String)"//cite:RoadSegments/cite:NAME", (Document)doc);
    }
}

