/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.CapabilitiesCacheHeadersCallback;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetCapabilitiesTest
extends WFSTestSupport {
    @Before
    public void revert() throws Exception {
        this.revertLayer(CiteTestData.UPDATES);
    }

    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        DataStoreInfo di = this.getCatalog().getDataStoreByName(CiteTestData.CITE_PREFIX);
        di.setEnabled(false);
        this.getCatalog().save((StoreInfo)di);
    }

    @Test
    public void testGet() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=getCapabilities");
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//wfs:FeatureType", doc).getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSkipMisconfiguredLayers() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        FeatureTypeInfo ftype = this.getCatalog().getFeatureTypeByName(CiteTestData.UPDATES.getLocalPart());
        ftype.setLatLonBoundingBox(null);
        this.getCatalog().save((ResourceInfo)ftype);
        Document doc = this.getAsDOM("wfs?version=1.0.0&service=WFS&request=getCapabilities");
        int count = 0;
        for (FeatureTypeInfo ft : this.getCatalog().getFeatureTypes()) {
            if (!ft.enabled()) continue;
            ++count;
        }
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(count - 1), (String)"count(//wfs:FeatureType)", (Document)doc);
    }

    @Test
    public void testNamespaceFilter() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=getCapabilities&namespace=sf");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[starts-with(., sf)]", doc).getLength() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[not(starts-with(., sf))]", doc).getLength());
        doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=getCapabilities&namespace=NotThere");
        e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wfs:FeatureType", doc).getLength());
    }

    @Test
    public void testPost() throws Exception {
        String xml = "<GetCapabilities service=\"WFS\" version=\"1.0.0\" xmlns=\"http://www.opengis.net/wfs\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xsi:schemaLocation=\"http://www.opengis.net/wfs  http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd\"/>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testOutputFormats() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=1.0.0");
        Element outputFormats = this.getFirstElementByTagName(doc, "ResultFormat");
        NodeList formats = outputFormats.getChildNodes();
        TreeSet<String> s1 = new TreeSet<String>();
        for (int i = 0; i < formats.getLength(); ++i) {
            String format = formats.item(i).getNodeName();
            s1.add(format);
        }
        List extensions = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class);
        TreeSet<String> s2 = new TreeSet<String>();
        for (WFSGetFeatureOutputFormat extension : extensions) {
            s2.add(extension.getCapabilitiesElementName());
        }
        Assert.assertEquals(s1, s2);
    }

    @Test
    public void testSupportedSpatialOperators() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=1.0.0");
        Element spatialOperators = this.getFirstElementByTagName(doc, "ogc:Spatial_Operators");
        NodeList ops = spatialOperators.getChildNodes();
        TreeSet<String> o = new TreeSet<String>();
        for (int i = 0; i < ops.getLength(); ++i) {
            String operator = ops.item(i).getLocalName();
            o.add(operator);
        }
        List<String> expectedSpatialOperators = this.getSupportedSpatialOperatorsList(true);
        Assert.assertEquals((long)expectedSpatialOperators.size(), (long)o.size());
        Assert.assertTrue((boolean)o.containsAll(expectedSpatialOperators));
    }

    @Test
    public void testTypeNameCount() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        List enabledTypes = this.getCatalog().getFeatureTypes();
        Iterator it = enabledTypes.iterator();
        while (it.hasNext()) {
            FeatureTypeInfo ft = (FeatureTypeInfo)it.next();
            if (ft.enabled()) continue;
            it.remove();
        }
        int enabledCount = enabledTypes.size();
        Assert.assertEquals((long)enabledCount, (long)xpath.getMatchingNodes("/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType", doc).getLength());
    }

    @Test
    public void testTypeNames() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=getCapabilities");
        this.print(doc);
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        List enabledTypes = this.getCatalog().getFeatureTypes();
        for (FeatureTypeInfo ft : enabledTypes) {
            if (!ft.enabled()) continue;
            String prefixedName = ft.getPrefixedName();
            String xpathExpr = "/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType/wfs:Name[text()=\"" + prefixedName + "\"]";
            XMLAssert.assertXpathExists((String)xpathExpr, (Document)doc);
        }
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        Document doc = this.getAsDOM("sf/wfs?service=WFS&version=1.0.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[starts-with(., sf)]", doc).getLength() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[not(starts-with(., sf))]", doc).getLength());
        Assert.assertEquals((long)6L, (long)xpath.getMatchingNodes("//wfs:Get[contains(@onlineResource,'sf/wfs')]", doc).getLength());
        Assert.assertEquals((long)6L, (long)xpath.getMatchingNodes("//wfs:Post[contains(@onlineResource,'sf/wfs')]", doc).getLength());
    }

    @Test
    public void testLayerQualified() throws Exception {
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wfs?service=WFS&version=1.0.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[starts-with(., sf)]", doc).getLength());
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[not(starts-with(., sf))]", doc).getLength());
        Assert.assertEquals((long)6L, (long)xpath.getMatchingNodes("//wfs:Get[contains(@onlineResource,'sf/PrimitiveGeoFeature/wfs')]", doc).getLength());
        Assert.assertEquals((long)6L, (long)xpath.getMatchingNodes("//wfs:Post[contains(@onlineResource,'sf/PrimitiveGeoFeature/wfs')]", doc).getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonAdvertisedLayer() throws Exception {
        String layerId = this.getLayerId(CiteTestData.MLINES);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        try {
            Document dom = this.getAsDOM("wfs?request=getCapabilities&version=1.0.0");
            XMLAssert.assertXpathExists((String)("//wfs:FeatureType[wfs:Name='" + layerId + "']"), (Document)dom);
            layer.setAdvertised(false);
            this.getCatalog().save(layer);
            dom = this.getAsDOM("wfs?request=getCapabilities&version=1.0.0");
            XMLAssert.assertXpathNotExists((String)("//wfs:FeatureType[wfs:Name = '" + layerId + "']"), (Document)dom);
        }
        finally {
            layer.setAdvertised(true);
            this.getCatalog().save(layer);
        }
    }

    @Test
    public void testCachingHeaders() throws Exception {
        MockHttpServletRequest request = this.createGetRequestWithHeaders("wfs?service=WFS&version=1.0.0&request=getCapabilities", new String[0]);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)HttpStatus.OK.value(), (long)response.getStatus());
        Assert.assertEquals((Object)"max-age=0, must-revalidate", (Object)response.getHeader("Cache-Control"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCachingHeadersDisabled() throws Exception {
        CapabilitiesCacheHeadersCallback callback = (CapabilitiesCacheHeadersCallback)GeoServerExtensions.bean(CapabilitiesCacheHeadersCallback.class);
        boolean backup = callback.isCapabilitiesCacheHeadersEnabled();
        try {
            callback.setCapabilitiesCacheHeadersEnabled(false);
            MockHttpServletRequest request = this.createGetRequestWithHeaders("wfs?service=WFS&version=1.0.0&request=getCapabilities", new String[0]);
            MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
            Assert.assertEquals((long)HttpStatus.OK.value(), (long)response.getStatus());
            Assert.assertNull((Object)response.getHeader("ETag"));
            Assert.assertNull((Object)response.getHeader("Cache-Control"));
        }
        finally {
            callback.setCapabilitiesCacheHeadersEnabled(backup);
        }
    }

    MockHttpServletRequest createGetRequestWithHeaders(String path, String ... headers) {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("GET");
        request.setContent(new byte[0]);
        for (int i = 0; i < headers.length - 1; i += 2) {
            request.addHeader(headers[i], (Object)headers[i + 1]);
        }
        return request;
    }
}

