/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.config.ServiceInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GeometrylessTest
extends WFSTestSupport {
    @Test
    public void testGetFeature10() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.0.0&service=wfs");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
        NodeList features = doc.getElementsByTagName("cite:Geometryless");
        Assert.assertEquals((long)3L, (long)featureMembers.getLength());
    }

    @Test
    public void testGetFeatureReproject10() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.0.0&service=wfs&srsName=EPSG:900913");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
        NodeList features = doc.getElementsByTagName("cite:Geometryless");
        Assert.assertEquals((long)3L, (long)featureMembers.getLength());
    }

    @Test
    public void testGetFeature11() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.1.0&service=wfs");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMembers");
        Assert.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
        NodeList features = doc.getElementsByTagName("cite:Geometryless");
        Assert.assertEquals((long)3L, (long)features.getLength());
    }

    @Test
    public void testGetFeatureReproject11() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.1.0&service=wfs&srsName=EPSG:900913");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMembers");
        Assert.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
        NodeList features = doc.getElementsByTagName("cite:Geometryless");
        Assert.assertEquals((long)3L, (long)features.getLength());
    }

    @Test
    public void testGetFeatureReprojectPost() throws Exception {
        String request = "<wfs:GetFeature service=\"WFS\" xmlns:wfs=\"http://www.opengis.net/wfs\" version=\"1.0.0\"  outputFormat=\"GML2\" xmlns:topp=\"http://www.openplans.org/topp\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd\"><wfs:Query typeName=\"cite:Geometryless\" srsName=\"EPSG:900913\"/></wfs:GetFeature>";
        System.out.println(request);
        Document doc = this.postAsDOM("wfs", request);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertEquals((long)3L, (long)featureMembers.getLength());
        NodeList features = doc.getElementsByTagName("cite:Geometryless");
        Assert.assertEquals((long)3L, (long)features.getLength());
    }
}

