/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.HashMap;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DescribeFeatureTest
extends WFSTestSupport {
    @Before
    public void revert() throws Exception {
        this.revertLayer(CiteTestData.AGGREGATEGEOFEATURE);
    }

    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        DataStoreInfo di = this.getCatalog().getDataStoreByName(CiteTestData.CITE_PREFIX);
        di.setEnabled(false);
        this.getCatalog().save((StoreInfo)di);
    }

    @Test
    public void testGet() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=DescribeFeatureType&version=1.0.0");
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testSkipMisconfiguredLayers() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=DescribeFeatureType&version=1.0.0");
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:import[contains(@schemaLocation, 'AggregateGeoFeature')])", (Document)doc);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        FeatureTypeInfo ftype = this.getCatalog().getFeatureTypeByName(CiteTestData.AGGREGATEGEOFEATURE.getLocalPart());
        ftype.setNativeName("NOT ACTUALLY THERE");
        this.getCatalog().save((ResourceInfo)ftype);
        doc = this.getAsDOM("wfs?service=WFS&request=DescribeFeatureType&version=1.0.0");
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//xsd:import[contains(@schemaLocation, 'AggregateGeoFeature')])", (Document)doc);
    }

    @Test
    public void testPost() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" />";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testPostDummyFeature() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:TypeName>cgf:DummyFeature</wfs:TypeName></wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testWithoutExplicitMapping() throws Exception {
        String xml = "<DescribeFeatureType xmlns='http://www.opengis.net/wfs' xmlns:gml='http://www.opengis.net/gml' xmlns:ogc='http://www.opengis.net/ogc' version='1.0.0' service='WFS'> <TypeName>cdf:Locks</TypeName> </DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("xsd:complexType").getLength());
    }

    @Test
    public void testWithoutTypeName() throws Exception {
        String[] expected;
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.0.0");
        NodeList nl = doc.getElementsByTagName("xsd:import");
        Assert.assertEquals((long)3L, (long)nl.getLength());
        HashMap imprts = new HashMap();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element imprt = (Element)nl.item(i);
            String namespace = imprt.getAttribute("namespace");
            String schemaLocation = imprt.getAttribute("schemaLocation");
            int query = schemaLocation.indexOf("?");
            schemaLocation = schemaLocation.substring(query + 1);
            String[] sp = schemaLocation.split("&");
            HashMap<String, String> params = new HashMap<String, String>();
            for (int j = 0; j < sp.length; ++j) {
                String[] sp1 = sp[j].split("=");
                params.put(sp1[0].toLowerCase(), sp1[1].toLowerCase());
            }
            imprts.put(namespace, params);
        }
        for (String namespace : expected = new String[]{CiteTestData.SF_URI, CiteTestData.CDF_URI, CiteTestData.CGF_URI}) {
            Assert.assertNotNull(imprts.get(namespace));
            HashMap params = (HashMap)imprts.get(namespace);
            Assert.assertEquals((Object)"wfs", params.get("service"));
            Assert.assertEquals((Object)"1.0.0", params.get("version"));
            Assert.assertEquals((Object)"describefeaturetype", params.get("request"));
            String types = (String)params.get("typename");
            Assert.assertNotNull((Object)types);
            Catalog cat = this.getCatalog();
            NamespaceInfo ns = cat.getNamespaceByURI(namespace);
            System.out.println(ns.getPrefix());
            Assert.assertEquals((long)cat.getFeatureTypesByNamespace(ns).size(), (long)types.split("%2c").length);
        }
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        Document doc = this.getAsDOM("sf/wfs?request=DescribeFeatureType&version=1.0.0");
        NodeList nl = doc.getElementsByTagName("xsd:complexType");
        Assert.assertEquals((long)3L, (long)nl.getLength());
        XMLAssert.assertXpathExists((String)"//xsd:complexType[@name = 'AggregateGeoFeatureType']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//xsd:complexType[@name = 'PrimitiveGeoFeatureType']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//xsd:complexType[@name = 'GenericEntityType']", (Document)doc);
        doc = this.getAsDOM("sf/wfs?request=DescribeFeatureType&version=1.0.0&typename=cdf:Fifteen");
        XMLAssert.assertXpathExists((String)"//ogc:ServiceException", (Document)doc);
    }

    @Test
    public void testMultipleNamespaceNoTargetNamespace() throws Exception {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.0.0&typeName=sf:PrimitiveGeoFeature,cgf:Points");
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("targetNamespace"));
    }

    @Test
    public void testMethodNameInjection() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=DescribeFeatureType%22%3E%3C/ServiceException%3E%3Cfoo%3EHello,%20World%3C/foo%3E%3CServiceException+foo=%22&typeName=sf:archsites");
        XMLAssert.assertXpathExists((String)"/ogc:ServiceExceptionReport/ogc:ServiceException", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"OperationNotSupported", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@code", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"DescribeFeatureType\"></ServiceException><foo>Hello, World</foo><ServiceException foo=\"", (String)"/ogc:ServiceExceptionReport/ogc:ServiceException/@locator", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//foo", (Document)dom);
    }
}

