/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.referencing.CRS;
import org.junit.Test;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.springframework.mock.web.MockHttpServletResponse;

public class RangeSubsetExtentionTest
extends WCSTestSupport {
    @Test
    public void testBasic() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsetting.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)1, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void mixed() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsettingInterval2.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)5, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void testWrong() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageWrongRangeSubsetting.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        this.checkOws20Exception(response, 404, WCS20Exception.WCS20ExceptionCode.NoSuchField.getExceptionCode(), "Band1");
    }

    @Test
    public void test9to3() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsetting9to3.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("gtiff", "gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:32611", (boolean)true)));
        TestCase.assertEquals((int)68, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)56, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)3, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("multiband").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void test9to4() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsetting9to4.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("gtiff", "gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:32611", (boolean)true)));
        TestCase.assertEquals((int)68, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)56, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)4, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("multiband").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void test9to7() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsetting9to7.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("gtiff", "gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:32611", (boolean)true)));
        TestCase.assertEquals((int)68, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)56, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)7, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("multiband").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }

    @Test
    public void testRange() throws Exception {
        File xml = new File("./src/test/resources/rangesubset/requestGetCoverageRangeSubsettingInterval.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader reader = new GeoTiffReader((Object)file);
        TestCase.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)reader.getCoordinateReferenceSystem(), (Object)CRS.decode((String)"EPSG:4326", (boolean)true)));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(0));
        TestCase.assertEquals((int)360, (int)reader.getOriginalGridRange().getSpan(1));
        GridCoverage2D coverage = reader.read(null);
        TestCase.assertEquals((int)3, (int)coverage.getSampleDimensions().length);
        GridCoverage2D sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
        RangeSubsetExtentionTest.assertEnvelopeEquals((Coverage)sourceCoverage, (Coverage)coverage);
        reader.dispose();
        this.scheduleForCleaning((GridCoverage)coverage);
        this.scheduleForCleaning((GridCoverage)sourceCoverage);
    }
}

