/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.io.ByteArrayInputStream;
import java.io.File;
import javax.imageio.stream.FileImageInputStream;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class InterpolationExtentionsTest
extends WCSTestSupport {
    @Test
    public void testInterpolationSingleLinearXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationLinear.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TestCase.assertEquals((int)360, (int)reader.getWidth(0));
        TestCase.assertEquals((int)360, (int)reader.getHeight(0));
        reader.dispose();
    }

    @Test
    public void testInterpolationSingleNearestXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationNearest.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TestCase.assertEquals((int)360, (int)reader.getWidth(0));
        TestCase.assertEquals((int)360, (int)reader.getHeight(0));
        reader.dispose();
    }

    @Test
    public void testInterpolationMixedSupportedXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationMixedSupported.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"image/tiff", (String)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TestCase.assertEquals((int)360, (int)reader.getWidth(0));
        TestCase.assertEquals((int)360, (int)reader.getHeight(0));
        reader.dispose();
    }

    @Test
    public void testInterpolationMixedTimeXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationMixedTime.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
    }

    @Test
    public void testInterpolationMixedUnsupportedXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationMixedUnsupported.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
    }

    @Test
    public void testInterpolationMixedDuplicatedXML() throws Exception {
        File xml = new File("./src/test/resources/requestGetCoverageInterpolationMixedDuplicated.xml");
        String request = FileUtils.readFileToString((File)xml);
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        TestCase.assertEquals((String)"application/xml", (String)response.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
    }
}

