/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.org.geoserver.wcs2_0.response;

import com.sun.media.jai.operator.ImageReadDescriptor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.media.jai.RenderedOp;
import org.geoserver.wcs2_0.response.GranuleStackImpl;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GranulStackImplTest {
    @Test
    public void testImageDispose() throws Exception {
        final AtomicBoolean readerDisposed = new AtomicBoolean(false);
        final AtomicBoolean streamDisposed = new AtomicBoolean(false);
        byte[] bytes = Base64.getDecoder().decode("R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");
        MemoryCacheImageInputStream is = new MemoryCacheImageInputStream(new ByteArrayInputStream(bytes)){

            @Override
            public void close() {
                streamDisposed.set(true);
            }
        };
        final ImageReader nativeReader = ImageIO.getImageReadersByFormatName("GIF").next();
        nativeReader.setInput(is);
        ImageReader reader = new ImageReader(null){

            @Override
            public int getNumImages(boolean allowSearch) throws IOException {
                return nativeReader.getNumImages(allowSearch);
            }

            @Override
            public int getWidth(int imageIndex) throws IOException {
                return nativeReader.getWidth(imageIndex);
            }

            @Override
            public int getHeight(int imageIndex) throws IOException {
                return nativeReader.getHeight(imageIndex);
            }

            @Override
            public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
                return nativeReader.getImageTypes(imageIndex);
            }

            @Override
            public IIOMetadata getStreamMetadata() throws IOException {
                return nativeReader.getStreamMetadata();
            }

            @Override
            public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
                return nativeReader.getImageMetadata(imageIndex);
            }

            @Override
            public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
                return nativeReader.read(imageIndex, param);
            }

            @Override
            public void dispose() {
                nativeReader.dispose();
                readerDisposed.set(true);
            }
        };
        RenderedOp image = ImageReadDescriptor.create((ImageInputStream)is, (Integer)0, (Boolean)false, (Boolean)false, (Boolean)false, null, null, null, (ImageReader)reader, null);
        GridCoverageFactory coverageFactory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D coverage = coverageFactory.create((CharSequence)"foo", (RenderedImage)image, (Envelope)new ReferencedEnvelope(0.0, 1.0, 0.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        GranuleStackImpl stack = new GranuleStackImpl((CharSequence)"fooBar", (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, null);
        stack.addCoverage(coverage);
        stack.dispose(true);
        Assert.assertTrue((boolean)streamDisposed.get());
        Assert.assertTrue((boolean)readerDisposed.get());
    }
}

