/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.util.HashMap;
import java.util.Map;
import net.opengis.wcs20.ExtensionItemType;
import net.opengis.wcs20.GetCoverageType;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.kvp.GetCoverageRequestReader;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geoserver.wcs2_0.WebCoverageService20;
import org.geoserver.wcs2_0.kvp.WCS20GetCoverageRequestReader;
import org.geotools.wcs.v1_1.WCSConfiguration;
import org.junit.Before;
import org.opengis.coverage.grid.GridCoverage;

public abstract class WCSKVPTestSupport
extends WCSTestSupport {
    static final double EPS = 4.0;
    WCSConfiguration configuration;
    GetCoverageRequestReader kvpreader;
    WebCoverageService20 service;

    protected GetCoverageType parse(String url) throws Exception {
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(KvpUtils.parseQueryString((String)url));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap(this.parseKvp((Map)rawKvp));
        WCS20GetCoverageRequestReader reader = new WCS20GetCoverageRequestReader();
        GetCoverageType gc = (GetCoverageType)reader.createRequest();
        return (GetCoverageType)reader.read((Object)gc, (Map)kvp, (Map)rawKvp);
    }

    protected Map<String, Object> getExtensionsMap(GetCoverageType gc) {
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        for (ExtensionItemType item : gc.getExtension().getContents()) {
            Object value = item.getSimpleContent() != null ? item.getSimpleContent() : item.getObjectContent();
            extensions.put(item.getNamespace() + ":" + item.getName(), value);
        }
        return extensions;
    }

    protected GridCoverage executeGetCoverage(String url) throws Exception {
        GridCoverage coverage = this.service.getCoverage(this.parse(url));
        super.scheduleForCleaning(coverage);
        return coverage;
    }

    @Override
    protected void setInputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxInputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    @Override
    protected void setOutputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxOutputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    @Before
    public void setup() {
        this.kvpreader = (GetCoverageRequestReader)applicationContext.getBean("wcs111GetCoverageRequestReader");
        this.service = (WebCoverageService20)applicationContext.getBean("wcs20ServiceTarget");
        this.configuration = new WCSConfiguration();
    }
}

