/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import net.opengis.wcs20.RangeItemType;
import net.opengis.wcs20.RangeSubsetType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.wcs2_0.kvp.RangeSubsetKvpParser;
import org.junit.Assert;
import org.junit.Test;

public class RangeSubsetKvpParserTest {
    RangeSubsetKvpParser parser = new RangeSubsetKvpParser();

    @Test
    public void testInvalidValues() throws Exception {
        try {
            this.parser.parse("axis::blah");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("band1,band2:band3:band4");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("band1,,band2");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
        try {
            this.parser.parse("band1,band2,");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (OWS20Exception e) {
            this.checkInvalidSyntaxException(e);
        }
    }

    private void checkInvalidSyntaxException(OWS20Exception e) {
        Assert.assertNotNull((Object)e.getHttpCode());
        Assert.assertEquals((long)400L, (long)e.getHttpCode().intValue());
        Assert.assertEquals((Object)"InvalidEncodingSyntax", (Object)e.getCode());
        Assert.assertEquals((Object)"rangeSubset", (Object)e.getLocator());
    }

    @Test
    public void testMixed() throws Exception {
        RangeSubsetType rs = (RangeSubsetType)this.parser.parse("band01,band03:band05,band10,band19:band21");
        EList items = rs.getRangeItems();
        Assert.assertEquals((long)4L, (long)items.size());
        RangeItemType i1 = (RangeItemType)items.get(0);
        Assert.assertEquals((Object)"band01", (Object)i1.getRangeComponent());
        RangeItemType i2 = (RangeItemType)items.get(1);
        Assert.assertEquals((Object)"band03", (Object)i2.getRangeInterval().getStartComponent());
        Assert.assertEquals((Object)"band05", (Object)i2.getRangeInterval().getEndComponent());
        RangeItemType i3 = (RangeItemType)items.get(2);
        Assert.assertEquals((Object)"band10", (Object)i3.getRangeComponent());
        RangeItemType i4 = (RangeItemType)items.get(3);
        Assert.assertEquals((Object)"band19", (Object)i4.getRangeInterval().getStartComponent());
        Assert.assertEquals((Object)"band21", (Object)i4.getRangeInterval().getEndComponent());
    }
}

