/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageInputStream;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import net.opengis.wcs20.GetCoverageType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs2_0.kvp.WCSKVPTestSupport;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.springframework.mock.web.MockHttpServletResponse;
import org.vfny.geoserver.wcs.WcsException;
import org.w3c.dom.Document;

public class GeoTiffKvpTest
extends WCSKVPTestSupport {
    static final TiffTagTest JPEG_TAG = new TiffTagTest("JPEG", Integer.toString(7));
    static final TiffTagTest DEFLATE_TAG = new TiffTagTest("Deflate", Integer.toString(32946));

    @Test
    public void extensionGeotiff() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&compression=JPEG&jpeg_quality=75&predictor=None&interleave=pixel&tiling=true&tileheight=256&tilewidth=256");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        Assert.assertEquals((Object)"JPEG", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:compression"));
        Assert.assertEquals((Object)"75", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:jpeg_quality"));
        Assert.assertEquals((Object)"None", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:predictor"));
        Assert.assertEquals((Object)"pixel", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:interleave"));
        Assert.assertEquals((Object)"true", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:tiling"));
        Assert.assertEquals((Object)"256", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:tileheight"));
        Assert.assertEquals((Object)"256", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:tilewidth"));
    }

    @Test
    public void extensionGeotiff2() throws Exception {
        String request = "wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&compression=Deflate&interleave=Pixel&tiling=true&tileheight=256&tilewidth=256";
        GetCoverageType gc = this.parse(request);
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        Assert.assertEquals((Object)"Deflate", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:compression"));
        Assert.assertEquals((Object)"Pixel", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:interleave"));
        Assert.assertEquals((Object)"true", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:tiling"));
        Assert.assertEquals((Object)"256", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:tileheight"));
        Assert.assertEquals((Object)"256", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:tilewidth"));
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        this.checkTiff(tiffContents, DEFLATE_TAG);
    }

    @Test
    public void extensionGeotiffPrefixed() throws Exception {
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=theCoverage&geotiff:compression=JPEG&geotiff:jpeg_quality=75&geotiff:predictor=None&geotiff:interleave=pixel&geotiff:tiling=true&geotiff:tileheight=256&geotiff:tilewidth=256");
        Map<String, Object> extensions = this.getExtensionsMap(gc);
        Assert.assertEquals((Object)"JPEG", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:compression"));
        Assert.assertEquals((Object)"75", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:jpeg_quality"));
        Assert.assertEquals((Object)"None", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:predictor"));
        Assert.assertEquals((Object)"pixel", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:interleave"));
        Assert.assertEquals((Object)"true", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:tiling"));
        Assert.assertEquals((Object)"256", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:tileheight"));
        Assert.assertEquals((Object)"256", (Object)extensions.get("http://www.opengis.net/wcs/geotiff/1.0:tilewidth"));
    }

    @Test
    public void wrongJPEGQuality() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&compression=JPEG&jpeg_quality=-2&predictor=None&interleave=pixel&tiling=true&tileheight=256&tilewidth=256");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.JpegQualityInvalid.toString(), "-2");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&compression=JPEG&jpeg_quality=101&predictor=None&interleave=pixel&tiling=true&tileheight=256&tilewidth=256");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.JpegQualityInvalid.toString(), "101");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&compression=JPEG&jpeg_quality=101&predictor=aaa&interleave=pixel&tiling=true&tileheight=256&tilewidth=256");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.JpegQualityInvalid.toString(), "101");
    }

    @Test
    public void jpeg() throws Exception {
        this.jpeg(false);
    }

    @Test
    public void jpegPrefix() throws Exception {
        this.jpeg(true);
    }

    private void jpeg(boolean prefix) throws Exception {
        String params = "compression=JPEG&jpeg_quality=75";
        if (prefix) {
            params = "geotiff:compression=JPEG&geotiff:jpeg_quality=75";
        }
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&" + params);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        this.checkTiff(tiffContents, JPEG_TAG);
    }

    @Test
    public void jpegMediaType() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&compression=JPEG&jpeg_quality=75&mediaType=multipart/related");
        Assert.assertEquals((Object)"multipart/related", (Object)response.getContentType());
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart xmlPart = multipart.getBodyPart(0);
        Assert.assertEquals((Object)"application/gml+xml", (Object)xmlPart.getHeader("Content-Type")[0]);
        Assert.assertEquals((Object)"wcs", (Object)xmlPart.getHeader("Content-ID")[0]);
        Document gml = this.dom(xmlPart.getInputStream());
        XMLAssert.assertXpathEvaluatesTo((String)"fileReference", (String)"//gml:rangeSet/gml:File/gml:rangeParameters/@xlink:arcrole", (Document)gml);
        XMLAssert.assertXpathEvaluatesTo((String)"cid:/coverages/wcs__BlueMarble.tif", (String)"//gml:rangeSet/gml:File/gml:rangeParameters/@xlink:href", (Document)gml);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.opengis.net/spec/GMLCOV_geotiff-coverages/1.0/conf/geotiff-coverage", (String)"//gml:rangeSet/gml:File/gml:rangeParameters/@xlink:role", (Document)gml);
        XMLAssert.assertXpathEvaluatesTo((String)"cid:/coverages/wcs__BlueMarble.tif", (String)"//gml:rangeSet/gml:File/gml:fileReference", (Document)gml);
        XMLAssert.assertXpathEvaluatesTo((String)"image/tiff", (String)"//gml:rangeSet/gml:File/gml:mimeType", (Document)gml);
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"/coverages/wcs__BlueMarble.tif", (Object)coveragePart.getHeader("Content-ID")[0]);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
        byte[] tiffContents = IOUtils.toByteArray((InputStream)coveragePart.getInputStream());
        this.checkTiff(tiffContents, JPEG_TAG);
    }

    private void checkTiff(byte[] tiffContents, TiffTagTest tiffTagTest) throws IOException, FileNotFoundException, IIOException {
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TIFFImageMetadata metadata = (TIFFImageMetadata)reader.getImageMetadata(0);
        Assert.assertNotNull((Object)metadata);
        IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(0).getAsTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        IIOMetadataNode field = this.getTiffField(root, 259);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)tiffTagTest.tagString, (Object)field.getFirstChild().getFirstChild().getAttributes().item(1).getNodeValue());
        Assert.assertEquals((Object)tiffTagTest.tagValue, (Object)field.getFirstChild().getFirstChild().getAttributes().item(0).getNodeValue());
        IIOMetadataNode node = metadata.getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    @Test
    public void interleaving() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&interleave=pixel");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TIFFImageMetadata metadata = (TIFFImageMetadata)reader.getImageMetadata(0);
        Assert.assertNotNull((Object)metadata);
        IIOMetadataNode node = metadata.getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&interleave=band");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.InterleavingNotSupported.toString(), "band");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&interleave=asds");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.InterleavingInvalid.toString(), "asds");
    }

    @Test
    public void deflate() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&compression=DEFLATE");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TIFFImageMetadata metadata = (TIFFImageMetadata)reader.getImageMetadata(0);
        Assert.assertNotNull((Object)metadata);
        IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(0).getAsTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        IIOMetadataNode field = this.getTiffField(root, 259);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"Deflate", (Object)field.getFirstChild().getFirstChild().getAttributes().item(1).getNodeValue());
        Assert.assertEquals((Object)"32946", (Object)field.getFirstChild().getFirstChild().getAttributes().item(0).getNodeValue());
        IIOMetadataNode node = metadata.getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    @Test
    public void lzw() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&compression=LZW&jpeg_quality=75");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        TIFFImageMetadata metadata = (TIFFImageMetadata)reader.getImageMetadata(0);
        Assert.assertNotNull((Object)metadata);
        IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(0).getAsTree("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        IIOMetadataNode field = this.getTiffField(root, 259);
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"LZW", (Object)field.getFirstChild().getFirstChild().getAttributes().item(1).getNodeValue());
        Assert.assertEquals((Object)"5", (Object)field.getFirstChild().getFirstChild().getAttributes().item(0).getNodeValue());
        IIOMetadataNode node = metadata.getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    @Test
    public void tiling() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&tiling=true&tileheight=256&tilewidth=256");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        TIFFImageReader reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(file));
        Assert.assertTrue((boolean)reader.isImageTiled(0));
        Assert.assertEquals((long)256L, (long)reader.getTileHeight(0));
        Assert.assertEquals((long)256L, (long)reader.getTileWidth(0));
        IIOMetadataNode node = ((TIFFImageMetadata)reader.getImageMetadata(0)).getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&interleave=pixel&tiling=true&tileheight=13&tilewidth=256");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.TilingInvalid.toString(), "13");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&interleave=pixel&tiling=true&tileheight=13&tilewidth=11");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.TilingInvalid.toString(), "11");
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&tiling=true");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        tiffContents = this.getBinary(response);
        file = File.createTempFile("bm_gtiff", "bm_gtiff.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        reader.setInput((Object)new FileImageInputStream(file));
        Assert.assertTrue((boolean)reader.isImageTiled(0));
        Assert.assertEquals((long)368L, (long)reader.getTileHeight(0));
        Assert.assertEquals((long)368L, (long)reader.getTileWidth(0));
        node = ((TIFFImageMetadata)reader.getImageMetadata(0)).getStandardDataNode();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"PlanarConfiguration", (Object)node.getFirstChild().getNodeName());
        Assert.assertEquals((Object)"PixelInterleaved", (Object)node.getFirstChild().getAttributes().item(0).getNodeValue());
        reader.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void overviewPolicy() throws Exception {
        MockHttpServletResponse response = null;
        byte[] tiffContents = null;
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&overviewPolicy=IGNORE&scalesize=http://www.opengis.net/def/axis/OGC/1/i(180),http://www.opengis.net/def/axis/OGC/1/j(180)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        tiffContents = this.getBinary(response);
        File fileNative = File.createTempFile("native", "native.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)fileNative, (byte[])tiffContents);
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&overviewPolicy=NEAREST&scalesize=http://www.opengis.net/def/axis/OGC/1/i(180),http://www.opengis.net/def/axis/OGC/1/j(180)");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        tiffContents = this.getBinary(response);
        File fileOverviewTS = File.createTempFile("overviewTS", "overviewTS.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)fileOverviewTS, (byte[])tiffContents);
        response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&overviewPolicy=NEAREST&SCALEFACTOR=0.5");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        tiffContents = this.getBinary(response);
        File fileOverviewSF = File.createTempFile("overviewSF", "overviewSF.tiff", new File("./target"));
        FileUtils.writeByteArrayToFile((File)fileOverviewSF, (byte[])tiffContents);
        TIFFImageReaderSpi spi = new TIFFImageReaderSpi();
        TIFFImageReader readerNative = null;
        TIFFImageReader readerOverviewTS = null;
        TIFFImageReader readerOverviewSF = null;
        FileImageInputStream streamNative = null;
        FileImageInputStream streamOverviewTS = null;
        FileImageInputStream streamOverviewSF = null;
        try {
            streamNative = new FileImageInputStream(fileNative);
            readerNative = (TIFFImageReader)spi.createReaderInstance();
            readerNative.setInput((Object)streamNative);
            streamOverviewTS = new FileImageInputStream(fileOverviewTS);
            readerOverviewTS = (TIFFImageReader)spi.createReaderInstance();
            readerOverviewTS.setInput((Object)streamOverviewTS);
            streamOverviewSF = new FileImageInputStream(fileOverviewSF);
            readerOverviewSF = (TIFFImageReader)spi.createReaderInstance();
            readerOverviewSF.setInput((Object)streamOverviewSF);
            BufferedImage riNative = readerNative.read(0);
            Raster rasterNative = riNative.getData();
            Assert.assertEquals((long)180L, (long)rasterNative.getWidth());
            Assert.assertEquals((long)180L, (long)rasterNative.getHeight());
            int refX = 11;
            int refY = 65;
            int r1 = rasterNative.getSample(11, 65, 0);
            int g1 = rasterNative.getSample(11, 65, 1);
            int b1 = rasterNative.getSample(11, 65, 2);
            BufferedImage riOverviewTS = readerOverviewTS.read(0);
            Raster rasterOverviewTS = riOverviewTS.getData();
            Assert.assertEquals((long)180L, (long)rasterOverviewTS.getWidth());
            Assert.assertEquals((long)180L, (long)rasterOverviewTS.getHeight());
            int r2 = rasterOverviewTS.getSample(11, 65, 0);
            int g2 = rasterOverviewTS.getSample(11, 65, 1);
            int b2 = rasterOverviewTS.getSample(11, 65, 2);
            BufferedImage riOverviewSF = readerOverviewSF.read(0);
            Raster rasterOverviewSF = riOverviewSF.getData();
            Assert.assertEquals((long)180L, (long)rasterOverviewSF.getWidth());
            Assert.assertEquals((long)180L, (long)rasterOverviewSF.getHeight());
            int r3 = rasterOverviewSF.getSample(11, 65, 0);
            int g3 = rasterOverviewSF.getSample(11, 65, 1);
            int b3 = rasterOverviewSF.getSample(11, 65, 2);
            Assert.assertTrue((r1 != r2 ? 1 : 0) != 0);
            Assert.assertTrue((g1 != g2 ? 1 : 0) != 0);
            Assert.assertTrue((b1 != b2 ? 1 : 0) != 0);
            Assert.assertEquals((long)r2, (long)r3);
            Assert.assertEquals((long)g2, (long)g3);
            Assert.assertEquals((long)b2, (long)b3);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(streamOverviewTS);
            IOUtils.closeQuietly(streamOverviewSF);
            IOUtils.closeQuietly((Closeable)streamNative);
            if (readerOverviewTS != null) {
                try {
                    readerOverviewTS.dispose();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            if (readerOverviewSF != null) {
                try {
                    readerOverviewSF.dispose();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
            }
            if (readerNative != null) {
                try {
                    readerNative.dispose();
                }
                catch (Throwable throwable4) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)streamOverviewTS);
        IOUtils.closeQuietly((Closeable)streamOverviewSF);
        IOUtils.closeQuietly((Closeable)streamNative);
        if (readerOverviewTS != null) {
            try {
                readerOverviewTS.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (readerOverviewSF != null) {
            try {
                readerOverviewSF.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (readerNative != null) {
            try {
                readerNative.dispose();
            }
            catch (Throwable throwable) {}
        }
    }

    @Test
    public void wrongCompression() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble&compression=aaaG&predictor=None&interleave=pixel&tiling=true&tileheight=256&tilewidth=256");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        this.checkOws20Exception(response, 404, WcsException.WcsExceptionCode.CompressionInvalid.toString(), "aaaG");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getFullCoverageKVP() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = new File("./target/bm_full.tiff");
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file);
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getGridGeometry().getGridRange(), (Object)targetCoverage.getGridGeometry().getGridRange());
            Assert.assertEquals((Object)sourceCoverage.getCoordinateReferenceSystem(), (Object)targetCoverage.getCoordinateReferenceSystem());
            Assert.assertEquals((Object)sourceCoverage.getEnvelope(), (Object)targetCoverage.getEnvelope());
        }
        catch (Throwable throwable) {
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            readerTarget.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.scheduleForCleaning((GridCoverage)targetCoverage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.scheduleForCleaning((GridCoverage)sourceCoverage);
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getFullCoverageLatLon() throws Exception {
        WCSInfo wcsInfo = this.getWCS();
        boolean oldLatLon = wcsInfo.isLatLon();
        wcsInfo.setLatLon(true);
        this.getGeoServer().save((ServiceInfo)wcsInfo);
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = new File("./target/bm_full.tiff");
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        Hints hints = new Hints();
        hints.put((Object)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"EPSG");
        hints.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.FALSE);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file, hints);
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getGridGeometry().getGridRange(), (Object)targetCoverage.getGridGeometry().getGridRange());
            Assert.assertEquals((Object)CRS.getAxisOrder((CoordinateReferenceSystem)targetCoverage.getCoordinateReferenceSystem()), (Object)CRS.AxisOrder.NORTH_EAST);
            GeneralEnvelope transformedEnvelope = CRS.transform((MathTransform)((AffineTransform2D)CoverageUtilities.AXES_SWAP), (Envelope)targetCoverage.getEnvelope());
            transformedEnvelope.setCoordinateReferenceSystem(sourceCoverage.getCoordinateReferenceSystem());
            Assert.assertEquals((Object)sourceCoverage.getEnvelope(), (Object)transformedEnvelope);
        }
        finally {
            wcsInfo.setLatLon(oldLatLon);
            this.getGeoServer().save((ServiceInfo)wcsInfo);
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getFullCoverageLonLat() throws Exception {
        WCSInfo wcsInfo = this.getWCS();
        boolean oldLatLon = wcsInfo.isLatLon();
        wcsInfo.setLatLon(false);
        this.getGeoServer().save((ServiceInfo)wcsInfo);
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=wcs__BlueMarble");
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        byte[] tiffContents = this.getBinary(response);
        File file = new File("./target/bm_fullLonLat.tiff");
        FileUtils.writeByteArrayToFile((File)file, (byte[])tiffContents);
        Hints hints = new Hints();
        hints.put((Object)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"EPSG");
        hints.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        GeoTiffReader readerTarget = new GeoTiffReader((Object)file, hints);
        GridCoverage2D targetCoverage = null;
        GridCoverage2D sourceCoverage = null;
        try {
            targetCoverage = readerTarget.read(null);
            sourceCoverage = (GridCoverage2D)this.getCatalog().getCoverageByName("BlueMarble").getGridCoverageReader(null, null).read(null);
            Assert.assertEquals((Object)sourceCoverage.getGridGeometry().getGridRange(), (Object)targetCoverage.getGridGeometry().getGridRange());
            Assert.assertEquals((Object)CRS.getAxisOrder((CoordinateReferenceSystem)targetCoverage.getCoordinateReferenceSystem()), (Object)CRS.AxisOrder.EAST_NORTH);
            Assert.assertEquals((Object)sourceCoverage.getEnvelope(), (Object)targetCoverage.getEnvelope());
        }
        finally {
            wcsInfo.setLatLon(oldLatLon);
            this.getGeoServer().save((ServiceInfo)wcsInfo);
            try {
                readerTarget.dispose();
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)targetCoverage);
            }
            catch (Exception exception) {}
            try {
                this.scheduleForCleaning((GridCoverage)sourceCoverage);
            }
            catch (Exception exception) {}
        }
    }

    static class TiffTagTest {
        String tagString;
        String tagValue;

        public TiffTagTest(String tagString, String tagValue) {
            this.tagString = tagString;
            this.tagValue = tagValue;
        }
    }
}

