/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.wms.WMSInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class WMSSettingsControllerTest
extends CatalogRESTTestSupport {
    @After
    public void revertChanges() {
        this.revertService(WMSInfo.class, null);
    }

    @Test
    public void testGetASJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/services/wms/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmsinfo = (JSONObject)jsonObject.get("wms");
        Assert.assertEquals((Object)"true", (Object)wmsinfo.get("enabled").toString().trim());
        Assert.assertEquals((Object)"WMS", (Object)wmsinfo.get("name"));
        JSONObject watermark = (JSONObject)wmsinfo.get("watermark");
        Assert.assertEquals((Object)"false", (Object)watermark.get("enabled").toString().trim());
        Assert.assertEquals((Object)"Nearest", (Object)wmsinfo.get("interpolation"));
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/services/wms/settings.xml");
        Assert.assertEquals((Object)"wms", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("name").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wms/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WMS", (String)"/wms/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wms/watermark/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Nearest", (String)"/wms/interpolation", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/services/wms/settings.html");
    }

    @Test
    public void testPutAsJSON() throws Exception {
        String json = "{'wms': {'id':'wms','enabled':'false','name':'WMS'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wms/settings/", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/services/wms/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmsinfo = (JSONObject)jsonObject.get("wms");
        Assert.assertEquals((Object)"false", (Object)wmsinfo.get("enabled").toString().trim());
        Assert.assertEquals((Object)"WMS", (Object)wmsinfo.get("name"));
    }

    @Test
    public void testPutAsXML() throws Exception {
        String xml = "<wms><id>wms</id><enabled>false</enabled><name>WMS</name><title>GeoServer Web Map Service</title><maintainer>http://geoserver.org/comm</maintainer></wms>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wms/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wms/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wms/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WMS", (String)"/wms/name", (Document)dom);
    }

    @Test
    public void testRoundTripJSON() throws Exception {
        JSONObject original = (JSONObject)this.getAsJSON("/rest/services/wms/settings.json");
        Assert.assertNotNull((Object)original);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wms/settings/", original.toString(), "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON updated = this.getAsJSON("/rest/services/wms/settings.json");
        Assert.assertEquals((Object)original, (Object)updated);
    }

    @Test
    public void testRoundTripXML() throws Exception {
        Document original = this.getAsDOM("/rest/services/wms/settings.xml");
        Assert.assertEquals((Object)"wms", (Object)original.getDocumentElement().getLocalName());
        String originalString = this.documentToString(original);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wms/settings", originalString, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document updated = this.getAsDOM("/rest/services/wms/settings.xml");
        Assert.assertEquals((Object)originalString, (Object)this.documentToString(updated));
    }

    private String documentToString(Document doc) throws Exception {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        WMSInfo i = (WMSInfo)geoServer.getService(WMSInfo.class);
        i.setEnabled(true);
        geoServer.save((ServiceInfo)i);
        String xml = "<wms><id>wms</id><name>WMS</name><title>GeoServer Web Map Service</title><maintainer>http://geoserver.org/comm</maintainer></wms>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wms/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wms/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wms/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WMS", (String)"/wms/name", (Document)dom);
        i = (WMSInfo)geoServer.getService(WMSInfo.class);
        Assert.assertTrue((boolean)i.isEnabled());
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/services/wms/settings").getStatus());
    }
}

