/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.ResourceStore;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ResourceStoreFactory
implements FactoryBean<ResourceStore>,
ApplicationContextAware {
    final Logger LOGGER = Logging.getLogger((String)"org.geoserver.platform");
    private ApplicationContext applicationContext;

    public ResourceStore getObject() throws Exception {
        ResourceStore resourceStore = null;
        try {
            resourceStore = (ResourceStore)GeoServerExtensions.bean("resourceStoreImpl", this.applicationContext);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.LOGGER.log(Level.FINER, "No resourceStoreImpl beans found, falling back to DataDirectoryResourceStore");
        }
        if (resourceStore == null) {
            resourceStore = (ResourceStore)GeoServerExtensions.bean("dataDirectoryResourceStore", this.applicationContext);
        }
        return resourceStore;
    }

    public Class<?> getObjectType() {
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

