/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.prefs.Preferences;
import org.geotools.util.LineWriter;
import org.geotools.util.logging.Logging;

public class Log4JFormatter
extends Formatter {
    private static final String PREFIX = "[";
    private static final String SUFFIX = "] ";
    private static long startMillis;
    private final String lineSeparator;
    private String bodyLineSeparator;
    private final StringBuffer buffer;
    private final LineWriter writer;

    public Log4JFormatter(String base) {
        this.bodyLineSeparator = this.lineSeparator = System.getProperty("line.separator", "\n");
        startMillis = System.currentTimeMillis();
        StringWriter str = new StringWriter();
        this.writer = new LineWriter((Writer)str);
        this.buffer = str.getBuffer();
    }

    @Override
    public synchronized String format(LogRecord record) {
        String recordLevel = record.getLevel().getLocalizedName();
        try {
            this.buffer.setLength(1);
            Long millis = record.getMillis() - startMillis;
            this.writer.write(millis.toString());
            this.writer.write(" ");
            this.writer.write(PREFIX);
            this.writer.write(recordLevel);
            this.writer.write(SUFFIX);
            if (record.getSourceClassName() != null) {
                this.writer.write(record.getSourceClassName());
            }
            this.writer.write(" - ");
            this.writer.setLineSeparator(this.bodyLineSeparator);
            if (record.getMessage() == null) {
                record.setMessage("null");
            }
            this.writer.write(this.formatMessage(record));
            this.writer.setLineSeparator(this.lineSeparator);
            this.writer.write(10);
            if (record.getThrown() != null) {
                try {
                    this.writer.write(this.getStackTrace(record.getThrown()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.writer.flush();
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        return this.buffer.toString();
    }

    private String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static void init(String base, Level filterLevel) {
        Handler handler;
        Log4JFormatter log4j = null;
        Logger logger = Logging.getLogger((String)base);
        if (!logger.getUseParentHandlers()) {
            logger.setLevel(filterLevel);
            if (logger.getHandlers().length > 0 && (handler = logger.getHandlers()[0]) != null) {
                handler.setLevel(filterLevel);
            }
        }
        Logger parent = logger;
        while (parent.getUseParentHandlers() && (parent = parent.getParent()) != null) {
            Handler[] handlers = parent.getHandlers();
            if (handlers == null) continue;
            for (int i = 0; i < handlers.length; ++i) {
                Formatter formatter;
                Handler handler2 = handlers[i];
                if (handler2.getClass().equals(ConsoleHandler.class) && (formatter = handler2.getFormatter()).getClass().equals(SimpleFormatter.class)) {
                    if (log4j == null) {
                        log4j = new Log4JFormatter(base);
                    }
                    try {
                        logger.removeHandler(handler2);
                        handler2 = new Stdout(handler2, (Formatter)log4j);
                        handler2.setLevel(filterLevel);
                    }
                    catch (UnsupportedEncodingException exception) {
                        Log4JFormatter.unexpectedException(exception);
                    }
                    catch (SecurityException exception) {
                        Log4JFormatter.unexpectedException(exception);
                    }
                }
                if (handler2.getClass().equals(Stdout.class)) {
                    handler2.setLevel(filterLevel);
                }
                logger.addHandler(handler2);
                logger.setLevel(filterLevel);
            }
        }
        if (0 == logger.getHandlers().length) {
            log4j = new Log4JFormatter(base);
            handler = new Stdout();
            handler.setFormatter(log4j);
            handler.setLevel(filterLevel);
            logger.addHandler(handler);
        }
        logger.setUseParentHandlers(false);
    }

    private static void unexpectedException(Exception e) {
        Logging.unexpectedException((String)"org.geotools.resources", Log4JFormatter.class, (String)"init", (Throwable)e);
    }

    static void setHeaderWidth(int margin) {
        Preferences.userNodeForPackage(Log4JFormatter.class).putInt("logging.header", margin);
    }

    private static final class Stdout
    extends StreamHandler {
        public Stdout() {
        }

        public Stdout(Handler handler, Formatter formatter) throws UnsupportedEncodingException {
            super(System.out, formatter);
            this.setErrorManager(handler.getErrorManager());
            this.setFilter(handler.getFilter());
            this.setLevel(handler.getLevel());
            this.setEncoding(handler.getEncoding());
        }

        @Override
        public void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

