/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.util.CacheProvider;
import org.geotools.util.logging.Logging;

public class DefaultCacheProvider
implements CacheProvider {
    private static final Logger LOGGER = Logging.getLogger(DefaultCacheProvider.class);
    public static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    public static final int DEFAULT_EXPIRATION_MINUTES = 20;
    public static final int DEFAULT_MAX_ENTRIES = 25000;
    public static final String BEAN_NAME_PROPERTY = "GEOSERVER_DEFAULT_CACHE_PROVIDER";

    @Override
    public <K extends Serializable, V extends Serializable> Cache<K, V> getCache(String cacheName) {
        Cache cache = CacheBuilder.newBuilder().weakValues().concurrencyLevel(4).expireAfterAccess(20L, TimeUnit.MINUTES).maximumSize(25000L).build();
        return cache;
    }

    public static CacheProvider findProvider() {
        CacheProvider cacheProvider = null;
        String providerNames = GeoServerExtensions.getProperty((String)BEAN_NAME_PROPERTY);
        if (providerNames != null) {
            for (String providerName : providerNames.split("\\s*,\\s*")) {
                cacheProvider = (CacheProvider)GeoServerExtensions.bean((String)providerName);
                if (cacheProvider == null) continue;
                LOGGER.log(Level.INFO, "Using specified Cache Provider ", providerName);
                break;
            }
            if (cacheProvider == null) {
                LOGGER.log(Level.INFO, "{0} was specified but no beans matched it.", BEAN_NAME_PROPERTY);
            }
        }
        if (cacheProvider == null) {
            try {
                cacheProvider = (CacheProvider)GeoServerExtensions.bean(CacheProvider.class);
            }
            catch (GeoServerExtensions.MultipleBeansException ex) {
                String providerName = (String)ex.getAvailableBeans().iterator().next();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    String available = StringUtils.join((Iterable)ex.getAvailableBeans(), (String)", ");
                    LOGGER.log(Level.WARNING, "Multiple Cache Providers in context: {0}\n\tUsing {1}.  Override by setting system property {2}", new Object[]{available, providerName, BEAN_NAME_PROPERTY});
                }
                cacheProvider = (CacheProvider)GeoServerExtensions.bean((String)providerName);
            }
        }
        if (cacheProvider == null) {
            cacheProvider = new DefaultCacheProvider();
        }
        return cacheProvider;
    }
}

