/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeoServerTemplateLoader
implements TemplateLoader {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.template");
    FileTemplateLoader fileTemplateLoader;
    ClassTemplateLoader classTemplateLoader;
    GeoServerDataDirectory dd;
    protected ResourceInfo resource;
    SimpleFeatureType featureType;
    WorkspaceInfo workspace;
    private String coverageName;
    private Catalog catalog;

    public GeoServerTemplateLoader(Class caller) throws IOException {
        this(caller, (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class));
    }

    public GeoServerTemplateLoader(Class caller, GeoServerResourceLoader rl) throws IOException {
        this(caller, new GeoServerDataDirectory(rl));
    }

    public GeoServerTemplateLoader(Class caller, GeoServerDataDirectory dd) throws IOException {
        this.dd = dd;
        this.fileTemplateLoader = new FileTemplateLoader(dd.root());
        this.catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        if (caller != null) {
            this.classTemplateLoader = new ClassTemplateLoader(caller, "");
        }
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByName(featureType.getName());
        if (ft == null) {
            return;
        }
        this.setFeatureType(ft);
    }

    public void setFeatureType(FeatureTypeInfo ft) {
        this.resource = ft;
    }

    public void setWMSLayer(WMSLayerInfo wms) {
        this.resource = wms;
    }

    public void setWMTSLayer(WMTSLayerInfo wmts) {
        this.resource = wmts;
    }

    public void setCoverageName(String coverageName) {
        this.coverageName = coverageName;
        CoverageInfo c = this.catalog.getCoverageByName(coverageName);
        if (c == null) {
            return;
        }
        this.setCoverage(c);
    }

    public void setCoverage(CoverageInfo c) {
        this.resource = c;
    }

    public void setResource(ResourceInfo resource) {
        this.resource = resource;
    }

    public void setWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    public Object findTemplateSource(String path) throws IOException {
        Object source;
        File template = null;
        if (this.resource != null) {
            template = this.dd.findSuppResourceFile(this.resource, path);
            if (template == null) {
                template = this.dd.findSuppStoreFile(this.resource.getStore(), path);
            }
            if (template == null) {
                template = this.dd.findSuppWorkspaceFile(this.resource.getStore().getWorkspace(), path);
            }
            if (template == null) {
                template = this.dd.findSuppWorkspacesFile(this.resource.getStore().getWorkspace(), path);
            }
            if (template != null) {
                return template;
            }
        }
        if (this.workspace != null) {
            if (template == null) {
                template = this.dd.findSuppWorkspaceFile(this.workspace, path);
            }
            if (template == null) {
                template = this.dd.findSuppWorkspacesFile(this.workspace, path);
            }
            if (template != null) {
                return template;
            }
        }
        if ((template = this.findTemplateSourceLegacy(path)) != null) {
            return template;
        }
        template = (File)this.fileTemplateLoader.findTemplateSource("templates" + File.separator + path);
        if (template != null) {
            return template;
        }
        if (this.classTemplateLoader != null && (source = this.classTemplateLoader.findTemplateSource(path)) != null) {
            return new ClassTemplateSource(path, source);
        }
        return null;
    }

    File findTemplateSourceLegacy(String path) throws IOException {
        File template = null;
        try {
            String dirName;
            String baseDirName;
            if (this.featureType != null) {
                String metadata;
                NamespaceInfo nsInfo;
                baseDirName = "featureTypes";
                String name = this.featureType.getTypeName();
                String namespace = this.featureType.getName().getNamespaceURI();
                ResourceInfo ftInfo = null;
                if (this.catalog != null && namespace != null && (nsInfo = this.catalog.getNamespaceByURI(namespace)) != null) {
                    ftInfo = this.catalog.getFeatureTypeByName(nsInfo.getPrefix(), name);
                }
                if (this.catalog != null && ftInfo == null) {
                    ftInfo = this.catalog.getFeatureTypeByName(name);
                }
                dirName = ftInfo != null ? ((metadata = ftInfo.getMetadata().get("dirName", String.class)) != null ? metadata : ftInfo.getNamespace().getPrefix() + "_" + ftInfo.getName()) : null;
            } else if (this.coverageName != null) {
                baseDirName = "coverages";
                CoverageInfo coverageInfo = this.catalog.getCoverageByName(this.coverageName);
                dirName = coverageInfo.getMetadata().get("dirName", String.class);
            } else {
                baseDirName = "featureTypes";
                dirName = "";
            }
            template = (File)this.fileTemplateLoader.findTemplateSource(baseDirName + File.separator + dirName + File.separator + path);
            if (template != null) {
                return template;
            }
            if (this.featureType != null) {
                NamespaceInfo nsInfo = null;
                if (this.featureType.getName().getNamespaceURI() != null) {
                    nsInfo = this.catalog.getNamespaceByURI(this.featureType.getName().getNamespaceURI());
                }
                if (nsInfo != null) {
                    template = (File)this.fileTemplateLoader.findTemplateSource("templates" + File.separator + nsInfo.getPrefix() + File.separator + path);
                }
            }
            if (template != null) {
                return template;
            }
            template = (File)this.fileTemplateLoader.findTemplateSource(baseDirName + File.separator + path);
            if (template != null) {
                return template;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    public long getLastModified(Object source) {
        if (source instanceof File) {
            return this.fileTemplateLoader.getLastModified(source);
        }
        ClassTemplateSource wrapper = (ClassTemplateSource)source;
        return this.classTemplateLoader.getLastModified(wrapper.source);
    }

    public Reader getReader(Object source, String encoding) throws IOException {
        if (source instanceof File) {
            return this.fileTemplateLoader.getReader(source, encoding);
        }
        ClassTemplateSource wrapper = (ClassTemplateSource)source;
        return this.classTemplateLoader.getReader(wrapper.source, encoding);
    }

    public void closeTemplateSource(Object source) throws IOException {
        if (source instanceof File) {
            this.fileTemplateLoader.closeTemplateSource(source);
        } else {
            ClassTemplateSource wrapper = (ClassTemplateSource)source;
            this.classTemplateLoader.closeTemplateSource(wrapper.source);
            wrapper.path = null;
            wrapper.source = null;
        }
    }

    static class ClassTemplateSource {
        String path;
        Object source;

        public ClassTemplateSource(String path, Object source) {
            this.path = path;
            this.source = source;
        }
    }
}

