/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.io.IOException;
import java.util.Arrays;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.KeyStoreProvider;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.password.AbstractGeoserverPasswordEncoder;
import org.geoserver.security.password.JasyptPBEPasswordEncoderWrapper;
import org.geoserver.security.password.PasswordEncodingType;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.crypto.password.PasswordEncoder;

public class GeoServerPBEPasswordEncoder
extends AbstractGeoserverPasswordEncoder {
    StandardPBEStringEncryptor stringEncrypter;
    StandardPBEByteEncryptor byteEncrypter;
    private String providerName;
    private String algorithm;
    private String keyAliasInKeyStore = "config:password:key";
    private KeyStoreProvider keystoreProvider;

    @Override
    public void initialize(GeoServerSecurityManager securityManager) throws IOException {
        this.keystoreProvider = securityManager.getKeyStoreProvider();
    }

    @Override
    public void initializeFor(GeoServerUserGroupService service) throws IOException {
        if (!this.keystoreProvider.hasUserGroupKey(service.getName())) {
            throw new IOException("No key alias: " + this.keystoreProvider.aliasForGroupService(service.getName()) + " in key store: " + this.keystoreProvider.getResource().path());
        }
        this.keyAliasInKeyStore = this.keystoreProvider.aliasForGroupService(service.getName());
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyAliasInKeyStore() {
        return this.keyAliasInKeyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PasswordEncoder createStringEncoder() {
        byte[] password = this.lookupPasswordFromKeyStore();
        char[] chars = SecurityUtils.toChars(password);
        try {
            this.stringEncrypter = new StandardPBEStringEncryptor();
            this.stringEncrypter.setPasswordCharArray(chars);
            if (this.getProviderName() != null && !this.getProviderName().isEmpty()) {
                this.stringEncrypter.setProviderName(this.getProviderName());
            }
            this.stringEncrypter.setAlgorithm(this.getAlgorithm());
            JasyptPBEPasswordEncoderWrapper encoder = new JasyptPBEPasswordEncoderWrapper();
            encoder.setPbeStringEncryptor((PBEStringEncryptor)this.stringEncrypter);
            JasyptPBEPasswordEncoderWrapper jasyptPBEPasswordEncoderWrapper = encoder;
            return jasyptPBEPasswordEncoderWrapper;
        }
        finally {
            SecurityUtils.scramble(password);
            SecurityUtils.scramble(chars);
        }
    }

    @Override
    protected AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder createCharEncoder() {
        byte[] password = this.lookupPasswordFromKeyStore();
        char[] chars = SecurityUtils.toChars(password);
        this.byteEncrypter = new StandardPBEByteEncryptor();
        this.byteEncrypter.setPasswordCharArray(chars);
        if (this.getProviderName() != null && !this.getProviderName().isEmpty()) {
            this.byteEncrypter.setProviderName(this.getProviderName());
        }
        this.byteEncrypter.setAlgorithm(this.getAlgorithm());
        return new AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPasswordValid(String encPass, char[] rawPass, Object salt) {
                byte[] decoded = Base64.decode((byte[])encPass.getBytes());
                byte[] decrypted = GeoServerPBEPasswordEncoder.this.byteEncrypter.decrypt(decoded);
                char[] chars = SecurityUtils.toChars(decrypted);
                try {
                    boolean bl = Arrays.equals(chars, rawPass);
                    return bl;
                }
                finally {
                    SecurityUtils.scramble(decrypted);
                    SecurityUtils.scramble(chars);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String encodePassword(char[] rawPass, Object salt) {
                byte[] bytes = SecurityUtils.toBytes(rawPass);
                try {
                    String string = new String(Base64.encode((byte[])GeoServerPBEPasswordEncoder.this.byteEncrypter.encrypt(bytes)));
                    return string;
                }
                finally {
                    SecurityUtils.scramble(bytes);
                }
            }
        };
    }

    byte[] lookupPasswordFromKeyStore() {
        try {
            if (!this.keystoreProvider.containsAlias(this.getKeyAliasInKeyStore())) {
                throw new RuntimeException("Keystore: " + this.keystoreProvider.getResource().path() + " does not contain alias: " + this.getKeyAliasInKeyStore());
            }
            return this.keystoreProvider.getSecretKey(this.getKeyAliasInKeyStore()).getEncoded();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find alias: " + this.getKeyAliasInKeyStore() + " in " + this.keystoreProvider.getResource().path());
        }
    }

    @Override
    public PasswordEncodingType getEncodingType() {
        return PasswordEncodingType.ENCRYPT;
    }

    @Override
    public String decode(String encPass) throws UnsupportedOperationException {
        if (this.stringEncrypter == null) {
            this.getStringEncoder();
        }
        return this.stringEncrypter.decrypt(this.removePrefix(encPass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] decodeToCharArray(String encPass) throws UnsupportedOperationException {
        if (this.byteEncrypter == null) {
            this.getCharEncoder();
        }
        byte[] decoded = Base64.decode((byte[])this.removePrefix(encPass).getBytes());
        byte[] bytes = this.byteEncrypter.decrypt(decoded);
        try {
            char[] cArray = SecurityUtils.toChars(bytes);
            return cArray;
        }
        finally {
            SecurityUtils.scramble(bytes);
        }
    }

    public String encode(CharSequence rawPassword) {
        return this.createCharEncoder().encodePassword(this.decodeToCharArray(rawPassword.toString()), null);
    }
}

