/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geotools.data.DataAccessFactory;
import org.geotools.util.logging.Logging;

public class ConfigurationPasswordEncryptionHelper {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    protected static Map<Class<? extends DataAccessFactory>, Set<String>> CACHE = new HashMap<Class<? extends DataAccessFactory>, Set<String>>();
    GeoServerSecurityManager securityManager;

    public ConfigurationPasswordEncryptionHelper(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public Catalog getCatalog() {
        return (Catalog)GeoServerExtensions.bean((String)"rawCatalog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEncryptedFields(StoreInfo info) {
        DataAccessFactory factory;
        if (!(info instanceof DataStoreInfo)) {
            return Collections.emptySet();
        }
        try {
            factory = this.getCatalog().getResourcePool().getDataStoreFactory((DataStoreInfo)info);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error looking up factory for store : " + info + ". Unable to encrypt connection parameters.", e);
            return Collections.emptySet();
        }
        if (factory == null) {
            LOGGER.warning("Could not find factory for store : " + info + ". Unable to encrypt connection parameters.");
            return Collections.emptySet();
        }
        if (factory.getParametersInfo() == null) {
            return Collections.emptySet();
        }
        Set<String> toEncrypt = CACHE.get(factory.getClass());
        if (toEncrypt != null) {
            return toEncrypt;
        }
        Map<Class<? extends DataAccessFactory>, Set<String>> map = CACHE;
        synchronized (map) {
            toEncrypt = CACHE.get(info.getClass());
            if (toEncrypt != null) {
                return toEncrypt;
            }
            toEncrypt = Collections.emptySet();
            if (info != null && info.getConnectionParameters() != null) {
                toEncrypt = new HashSet<String>(3);
                for (DataAccessFactory.Param p : factory.getParametersInfo()) {
                    if (!p.isPassword()) continue;
                    toEncrypt.add(p.getName());
                }
            }
            CACHE.put(factory.getClass(), toEncrypt);
        }
        return toEncrypt;
    }

    public String encode(String value) {
        String encoderName = this.securityManager.getSecurityConfig().getConfigPasswordEncrypterName();
        if (encoderName != null) {
            GeoServerPasswordEncoder pwEncoder = this.securityManager.loadPasswordEncoder(encoderName);
            if (pwEncoder != null) {
                String prefix = pwEncoder.getPrefix();
                if (value.startsWith(prefix + ":")) {
                    throw new RuntimeException("Cannot encode a password with prefix: " + prefix + ":");
                }
                value = pwEncoder.encodePassword(value, null);
            }
        } else {
            LOGGER.warning("Encryption disabled, no password encoder set");
        }
        return value;
    }

    public void decode(StoreInfo info) {
        List<GeoServerPasswordEncoder> encoders = this.securityManager.loadPasswordEncoders(null, true, null);
        Set<String> encryptedFields = this.getEncryptedFields(info);
        if (info.getConnectionParameters() != null) {
            for (String key : info.getConnectionParameters().keySet()) {
                String value;
                if (!encryptedFields.contains(key) || (value = (String)((Object)info.getConnectionParameters().get(key))) == null) continue;
                info.getConnectionParameters().put(key, (Serializable)((Object)this.decode(value, encoders)));
            }
        }
    }

    public String decode(String value) {
        return this.decode(value, this.securityManager.loadPasswordEncoders(null, true, null));
    }

    String decode(String value, List<GeoServerPasswordEncoder> encoders) {
        for (GeoServerPasswordEncoder encoder : encoders) {
            if (!encoder.isReversible() || !encoder.isResponsibleForEncoding(value)) continue;
            return encoder.decode(value);
        }
        return value;
    }
}

