/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.impl.AbstractUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.UserGroupStoreHelper;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.validation.PasswordValidatorImpl;
import org.geotools.util.logging.Logging;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class AbstractUserGroupStore
implements GeoServerUserGroupStore {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    private boolean modified = false;
    protected AbstractUserGroupService service;
    protected UserGroupStoreHelper helper = new UserGroupStoreHelper();

    protected AbstractUserGroupStore() {
    }

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public void setName(String name) {
        this.service.setName(name);
    }

    @Override
    public GeoServerSecurityManager getSecurityManager() {
        return this.service.getSecurityManager();
    }

    @Override
    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.service.setSecurityManager(securityManager);
    }

    @Override
    public boolean canCreateStore() {
        return this.service.canCreateStore();
    }

    @Override
    public String getPasswordEncoderName() {
        return this.service.getPasswordEncoderName();
    }

    @Override
    public String getPasswordValidatorName() {
        return this.service.getPasswordValidatorName();
    }

    @Override
    public GeoServerUserGroupStore createStore() throws IOException {
        return this.service.createStore();
    }

    @Override
    public void registerUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.service.registerUserGroupLoadedListener(listener);
    }

    @Override
    public void unregisterUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.service.unregisterUserGroupLoadedListener(listener);
    }

    @Override
    public GeoServerUser getUserByUsername(String username) throws IOException {
        return this.helper.getUserByUsername(username);
    }

    @Override
    public GeoServerUserGroup getGroupByGroupname(String groupname) throws IOException {
        return this.helper.getGroupByGroupname(groupname);
    }

    @Override
    public SortedSet<GeoServerUser> getUsers() throws IOException {
        return this.helper.getUsers();
    }

    @Override
    public SortedSet<GeoServerUserGroup> getUserGroups() throws IOException {
        return this.helper.getUserGroups();
    }

    @Override
    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        return this.service.createGroupObject(groupname, isEnabled);
    }

    @Override
    public SortedSet<GeoServerUserGroup> getGroupsForUser(GeoServerUser user) throws IOException {
        return this.helper.getGroupsForUser(user);
    }

    @Override
    public SortedSet<GeoServerUser> getUsersForGroup(GeoServerUserGroup group) throws IOException {
        return this.helper.getUsersForGroup(group);
    }

    @Override
    public void load() throws IOException {
        this.deserialize();
    }

    public Resource getConfigRoot() throws IOException {
        return this.service.getConfigRoot();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.service.loadUserByUsername(username);
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public void setModified(Boolean value) {
        this.modified = value;
    }

    protected void preparePassword(GeoServerUser user) throws IOException, PasswordPolicyException {
        char[] passwordArray;
        char[] cArray = passwordArray = user.getPassword() != null ? user.getPassword().toCharArray() : null;
        if (PasswordValidatorImpl.passwordStartsWithEncoderPrefix(passwordArray) != null) {
            return;
        }
        this.getSecurityManager().loadPasswordValidator(this.getPasswordValidatorName()).validatePassword(passwordArray);
        GeoServerPasswordEncoder enc = this.getSecurityManager().loadPasswordEncoder(this.getPasswordEncoderName());
        enc.initializeFor(this);
        user.setPassword(enc.encodePassword(user.getPassword(), null));
    }

    @Override
    public void addUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        if (this.helper.userMap.containsKey(user.getUsername())) {
            throw new IllegalArgumentException("The user " + user.getUsername() + " already exists");
        }
        this.preparePassword(user);
        this.helper.userMap.put(user.getUsername(), user);
        this.addUserToPropertyMap(user);
        this.setModified(true);
    }

    protected void addUserToPropertyMap(GeoServerUser user) {
        for (Object key : user.getProperties().keySet()) {
            SortedSet<GeoServerUser> users = this.helper.propertyMap.get(key);
            if (users == null) {
                users = new TreeSet<GeoServerUser>();
                this.helper.propertyMap.put((String)key, users);
            }
            users.add(user);
        }
    }

    protected void removeUserFromPropertyMap(GeoServerUser user) {
        for (SortedSet<GeoServerUser> users : this.helper.propertyMap.values()) {
            users.remove(user);
        }
    }

    @Override
    public void addGroup(GeoServerUserGroup group) throws IOException {
        if (this.helper.groupMap.containsKey(group.getGroupname())) {
            throw new IllegalArgumentException("The group " + group.getGroupname() + " already exists");
        }
        this.helper.groupMap.put(group.getGroupname(), group);
        this.setModified(true);
    }

    @Override
    public void updateUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        if (!this.helper.userMap.containsKey(user.getUsername())) {
            throw new IllegalArgumentException("The user " + user.getUsername() + " does not exist");
        }
        this.preparePassword(user);
        this.helper.userMap.put(user.getUsername(), user);
        this.removeUserFromPropertyMap(user);
        this.addUserToPropertyMap(user);
        this.setModified(true);
    }

    @Override
    public void updateGroup(GeoServerUserGroup group) throws IOException {
        if (!this.helper.groupMap.containsKey(group.getGroupname())) {
            throw new IllegalArgumentException("The group " + group.getGroupname() + " does not exist");
        }
        this.helper.groupMap.put(group.getGroupname(), group);
        this.setModified(true);
    }

    @Override
    public boolean removeUser(GeoServerUser user) throws IOException {
        boolean retValue;
        Collection groups = this.helper.user_groupMap.get(user);
        if (groups != null) {
            ArrayList toBeRemoved = new ArrayList();
            toBeRemoved.addAll(groups);
            for (GeoServerUserGroup group : toBeRemoved) {
                this.disAssociateUserFromGroup(user, group);
            }
        }
        boolean bl = retValue = this.helper.userMap.remove(user.getUsername()) != null;
        if (retValue) {
            this.setModified(true);
            this.removeUserFromPropertyMap(user);
        }
        return retValue;
    }

    @Override
    public boolean removeGroup(GeoServerUserGroup group) throws IOException {
        boolean retval;
        Collection users = this.helper.group_userMap.get(group);
        if (users != null) {
            ArrayList toBeRemoved = new ArrayList();
            toBeRemoved.addAll(users);
            for (GeoServerUser user : toBeRemoved) {
                this.disAssociateUserFromGroup(user, group);
            }
        }
        boolean bl = retval = this.helper.groupMap.remove(group.getGroupname()) != null;
        if (retval) {
            this.setModified(true);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() throws IOException {
        if (this.isModified()) {
            LOGGER.info("Start storing user/groups for service named " + this.getName());
            AbstractUserGroupService abstractUserGroupService = this.service;
            synchronized (abstractUserGroupService) {
                this.serialize();
            }
            this.setModified(false);
            LOGGER.info("Storing user/groups successful for service named " + this.getName());
            this.service.load();
        } else {
            LOGGER.info("Storing unnecessary, no change for user and groups");
        }
    }

    @Override
    public void associateUserToGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        SortedSet<GeoServerUserGroup> groups;
        this.checkUser(user);
        this.checkGroup(group);
        boolean changed = false;
        SortedSet<GeoServerUser> users = this.helper.group_userMap.get(group);
        if (users == null) {
            users = new TreeSet<GeoServerUser>();
            this.helper.group_userMap.put(group, users);
        }
        if (!users.contains(user)) {
            users.add(user);
            changed = true;
        }
        if ((groups = this.helper.user_groupMap.get(user)) == null) {
            groups = new TreeSet<GeoServerUserGroup>();
            this.helper.user_groupMap.put(user, groups);
        }
        if (!groups.contains(group)) {
            groups.add(group);
            changed = true;
        }
        if (changed) {
            this.setModified(true);
        }
    }

    @Override
    public void disAssociateUserFromGroup(GeoServerUser user, GeoServerUserGroup group) throws IOException {
        SortedSet<GeoServerUserGroup> groups;
        this.checkUser(user);
        this.checkGroup(group);
        boolean changed = false;
        SortedSet<GeoServerUser> users = this.helper.group_userMap.get(group);
        if (users != null) {
            changed |= users.remove(user);
            if (users.isEmpty()) {
                this.helper.group_userMap.remove(group);
            }
        }
        if ((groups = this.helper.user_groupMap.get(user)) != null) {
            changed |= groups.remove(group);
            if (groups.isEmpty()) {
                this.helper.user_groupMap.remove(user);
            }
        }
        if (changed) {
            this.setModified(true);
        }
    }

    protected abstract void serialize() throws IOException;

    @Override
    public void clear() throws IOException {
        this.clearMaps();
        this.setModified(true);
    }

    @Override
    public void initializeFromService(GeoServerUserGroupService service) throws IOException {
        this.service = (AbstractUserGroupService)service;
        this.load();
    }

    protected void clearMaps() {
        this.helper.clearMaps();
    }

    protected void deserialize() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(this.service.helper.userMap);
        oout.writeObject(this.service.helper.groupMap);
        oout.writeObject(this.service.helper.user_groupMap);
        oout.writeObject(this.service.helper.group_userMap);
        oout.writeObject(this.service.helper.propertyMap);
        byte[] bytes = out.toByteArray();
        oout.close();
        this.clearMaps();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            this.helper.userMap = (TreeMap)oin.readObject();
            this.helper.groupMap = (TreeMap)oin.readObject();
            this.helper.user_groupMap = (TreeMap)oin.readObject();
            this.helper.group_userMap = (TreeMap)oin.readObject();
            this.helper.propertyMap = (TreeMap)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.setModified(false);
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.service.initializeFromConfig(config);
    }

    @Override
    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        return this.service.createUserObject(username, password, isEnabled);
    }

    protected void checkUser(GeoServerUser user) throws IOException {
        if (!this.helper.userMap.containsKey(user.getUsername())) {
            throw new IOException("User: " + user.getUsername() + " does not exist");
        }
    }

    protected void checkGroup(GeoServerUserGroup group) throws IOException {
        if (!this.helper.groupMap.containsKey(group.getGroupname())) {
            throw new IOException("Group: " + group.getGroupname() + " does not exist");
        }
    }

    @Override
    public int getUserCount() throws IOException {
        return this.helper.getUserCount();
    }

    @Override
    public int getGroupCount() throws IOException {
        return this.helper.getGroupCount();
    }

    @Override
    public SortedSet<GeoServerUser> getUsersHavingProperty(String propname) throws IOException {
        return this.helper.getUsersHavingProperty(propname);
    }

    @Override
    public int getUserCountHavingProperty(String propname) throws IOException {
        return this.helper.getUserCountHavingProperty(propname);
    }

    @Override
    public SortedSet<GeoServerUser> getUsersNotHavingProperty(String propname) throws IOException {
        return this.helper.getUsersNotHavingProperty(propname);
    }

    @Override
    public int getUserCountNotHavingProperty(String propname) throws IOException {
        return this.helper.getUserCountNotHavingProperty(propname);
    }

    @Override
    public SortedSet<GeoServerUser> getUsersHavingPropertyValue(String propname, String propvalue) throws IOException {
        return this.helper.getUsersHavingPropertyValue(propname, propvalue);
    }

    @Override
    public int getUserCountHavingPropertyValue(String propname, String propvalue) throws IOException {
        return this.helper.getUserCountHavingPropertyValue(propname, propvalue);
    }
}

