/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.event.UserGroupLoadedEvent;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.RoleCalculator;
import org.geoserver.security.impl.UserGroupStoreHelper;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class AbstractUserGroupService
extends AbstractGeoServerSecurityService
implements GeoServerUserGroupService {
    protected Set<UserGroupLoadedListener> listeners = Collections.synchronizedSet(new HashSet());
    protected String passwordEncoderName;
    protected String passwordValidatorName;
    protected UserGroupStoreHelper helper = new UserGroupStoreHelper();

    protected AbstractUserGroupService() {
    }

    @Override
    public String getPasswordEncoderName() {
        return this.passwordEncoderName;
    }

    @Override
    public String getPasswordValidatorName() {
        return this.passwordValidatorName;
    }

    @Override
    public GeoServerUserGroupStore createStore() throws IOException {
        return null;
    }

    @Override
    public void registerUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public GeoServerUser getUserByUsername(String username) throws IOException {
        return this.helper.getUserByUsername(username);
    }

    @Override
    public GeoServerUserGroup getGroupByGroupname(String groupname) throws IOException {
        return this.helper.getGroupByGroupname(groupname);
    }

    @Override
    public SortedSet<GeoServerUser> getUsers() throws IOException {
        return this.helper.getUsers();
    }

    @Override
    public SortedSet<GeoServerUserGroup> getUserGroups() throws IOException {
        return this.helper.getUserGroups();
    }

    @Override
    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        GeoServerUser user = new GeoServerUser(username);
        user.setEnabled(isEnabled);
        user.setPassword(password);
        return user;
    }

    @Override
    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        GeoServerUserGroup group = new GeoServerUserGroup(groupname);
        group.setEnabled(isEnabled);
        return group;
    }

    @Override
    public SortedSet<GeoServerUserGroup> getGroupsForUser(GeoServerUser user) throws IOException {
        return this.helper.getGroupsForUser(user);
    }

    @Override
    public SortedSet<GeoServerUser> getUsersForGroup(GeoServerUserGroup group) throws IOException {
        return this.helper.getUsersForGroup(group);
    }

    protected abstract void deserialize() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException {
        LOGGER.info("Start reloading user/groups for service named " + this.getName());
        AbstractUserGroupService abstractUserGroupService = this;
        synchronized (abstractUserGroupService) {
            this.deserialize();
        }
        LOGGER.info("Reloading user/groups successful for service named " + this.getName());
        this.fireUserGroupLoadedEvent();
    }

    protected void fireUserGroupLoadedEvent() {
        UserGroupLoadedEvent event = new UserGroupLoadedEvent(this);
        for (UserGroupLoadedListener listener : this.listeners) {
            listener.usersAndGroupsChanged(event);
        }
    }

    protected void clearMaps() {
        this.helper.clearMaps();
    }

    public Resource getConfigRoot() throws IOException {
        return this.getSecurityManager().userGroup().get(this.getName());
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        GeoServerUser user = null;
        try {
            user = this.getUserByUsername(username);
            if (user == null) {
                throw new UsernameNotFoundException(this.userNotFoundMessage(username));
            }
            RoleCalculator calculator = new RoleCalculator(this, this.getSecurityManager().getActiveRoleService());
            user.setAuthorities(calculator.calculateRoles(user));
        }
        catch (IOException e) {
            throw new UsernameNotFoundException(this.userNotFoundMessage(username), (Throwable)e);
        }
        return user;
    }

    protected String userNotFoundMessage(String username) {
        return "User  " + username + " not found in usergroupservice: " + this.getName();
    }

    @Override
    public int getUserCount() throws IOException {
        return this.helper.getUserCount();
    }

    @Override
    public int getGroupCount() throws IOException {
        return this.helper.getGroupCount();
    }

    @Override
    public SortedSet<GeoServerUser> getUsersHavingProperty(String propname) throws IOException {
        return this.helper.getUsersHavingProperty(propname);
    }

    @Override
    public int getUserCountHavingProperty(String propname) throws IOException {
        return this.helper.getUserCountHavingProperty(propname);
    }

    @Override
    public SortedSet<GeoServerUser> getUsersNotHavingProperty(String propname) throws IOException {
        return this.helper.getUsersNotHavingProperty(propname);
    }

    @Override
    public int getUserCountNotHavingProperty(String propname) throws IOException {
        return this.helper.getUserCountNotHavingProperty(propname);
    }

    @Override
    public SortedSet<GeoServerUser> getUsersHavingPropertyValue(String propname, String propvalue) throws IOException {
        return this.helper.getUsersHavingPropertyValue(propname, propvalue);
    }

    @Override
    public int getUserCountHavingPropertyValue(String propname, String propvalue) throws IOException {
        return this.helper.getUserCountHavingPropertyValue(propname, propvalue);
    }
}

