/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.PropertyFileWatcher;
import org.geoserver.util.IOUtils;
import org.geotools.util.logging.Logging;

public abstract class AbstractAccessRuleDAO<R extends Comparable<?>> {
    private static final Logger LOGGER = Logging.getLogger(AbstractAccessRuleDAO.class);
    protected Set<R> rules;
    PropertyFileWatcher watcher;
    protected long lastModified;
    Resource securityDir;
    String propertyFileName;
    GeoServerDataDirectory dd;

    protected AbstractAccessRuleDAO(GeoServerDataDirectory dd, String propertyFileName) throws IOException {
        this.dd = dd;
        this.securityDir = dd.getSecurity(new String[0]);
        this.propertyFileName = propertyFileName;
    }

    protected AbstractAccessRuleDAO(Resource securityDirectory, String propertyFileName) {
        this.securityDir = securityDirectory;
        this.propertyFileName = propertyFileName;
        this.dd = (GeoServerDataDirectory)GeoServerExtensions.bean(GeoServerDataDirectory.class);
    }

    public List<R> getRules() {
        this.checkPropertyFile(false);
        return new ArrayList<R>(this.rules);
    }

    public boolean addRule(R rule) {
        this.lastModified = System.currentTimeMillis();
        return this.rules.add(rule);
    }

    public void reload() {
        this.checkPropertyFile(true);
    }

    public void clear() {
        this.rules.clear();
        this.lastModified = System.currentTimeMillis();
    }

    public boolean removeRule(R rule) {
        this.lastModified = System.currentTimeMillis();
        return this.rules.remove(rule);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isModified() {
        return this.watcher != null && this.watcher.isStale();
    }

    public void storeRules() throws IOException {
        try (OutputStream os = null;){
            Properties p = this.toProperties();
            Resource propFile = this.securityDir.get(this.propertyFileName);
            os = propFile.out();
            p.store(os, null);
            this.lastModified = System.currentTimeMillis();
        }
    }

    protected void checkPropertyFile(boolean force) {
        try {
            if (this.rules == null || force) {
                if (this.securityDir == null || this.securityDir.getType() == Resource.Type.UNDEFINED) {
                    this.rules = new TreeSet<R>();
                } else {
                    InputStream in;
                    Resource layers = this.securityDir.get(this.propertyFileName);
                    if (layers.getType() == Resource.Type.UNDEFINED && (in = this.getClass().getResourceAsStream(this.propertyFileName + ".template")) != null) {
                        IOUtils.copy((InputStream)in, (OutputStream)layers.out());
                    }
                    if (layers.getType() == Resource.Type.UNDEFINED) {
                        this.rules = new TreeSet<R>();
                    } else {
                        this.watcher = new PropertyFileWatcher(layers);
                        this.loadRules(this.watcher.getProperties());
                    }
                }
                this.lastModified = System.currentTimeMillis();
            } else if (this.isModified()) {
                this.loadRules(this.watcher.getProperties());
                this.lastModified = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to reload data access rules from layers.properties, keeping old rules", e);
        }
    }

    protected abstract void loadRules(Properties var1);

    protected abstract Properties toProperties();

    protected Set<String> parseRoles(String roleCsv) {
        String[] rolesArray = roleCsv.split("[\\s,]+");
        HashSet<String> roles = new HashSet<String>(rolesArray.length);
        roles.addAll(Arrays.asList(rolesArray));
        for (String role : roles) {
            if (!"*".equals(role)) continue;
            return Collections.singleton("*");
        }
        return roles;
    }
}

