/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.config.SecurityContextPersistenceFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerCompositeFilter;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.SecurityContextRepository;

public class GeoServerSecurityContextPersistenceFilter
extends GeoServerCompositeFilter {
    public static final String ALLOWSESSIONCREATION_ATTR = "_allowSessionCreation";
    Boolean isAllowSessionCreation;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        SecurityContextPersistenceFilterConfig pConfig = (SecurityContextPersistenceFilterConfig)config;
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        SecurityContextPersistenceFilter filter = new SecurityContextPersistenceFilter((SecurityContextRepository)repo){

            public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
                req.setAttribute(GeoServerSecurityContextPersistenceFilter.ALLOWSESSIONCREATION_ATTR, (Object)GeoServerSecurityContextPersistenceFilter.this.isAllowSessionCreation);
                if (GeoServerSecurityContextPersistenceFilter.this.isAllowSessionCreation.booleanValue()) {
                    ((HttpServletRequest)req).getSession();
                }
                req.setAttribute("org.geoserver.security.enabled", (Object)Boolean.TRUE);
                super.doFilter(req, res, chain);
            }
        };
        this.isAllowSessionCreation = pConfig.isAllowSessionCreation();
        repo.setAllowSessionCreation(pConfig.isAllowSessionCreation());
        filter.setForceEagerSessionCreation(false);
        try {
            filter.afterPropertiesSet();
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.getNestedFilters().add((Filter)filter);
    }
}

