/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.AuthenticationCachingFilter;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public abstract class GeoServerPreAuthenticationFilter
extends GeoServerSecurityFilter
implements AuthenticationCachingFilter,
GeoServerAuthenticationFilter {
    private AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    protected AuthenticationEntryPoint aep;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.aep = new Http403ForbiddenEntryPoint();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String cacheKey = this.authenticateFromCache(this, (HttpServletRequest)request);
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            this.doAuthenticate((HttpServletRequest)request, (HttpServletResponse)response);
            Authentication postAuthentication = SecurityContextHolder.getContext().getAuthentication();
            if (postAuthentication != null && cacheKey != null && this.cacheAuthentication(postAuthentication, (HttpServletRequest)request)) {
                this.getSecurityManager().getAuthenticationCache().put(this.getName(), cacheKey, postAuthentication);
            }
        }
        request.setAttribute("_AUTHENTICATION_ENTRY_POINT_HEADER", (Object)this.aep);
        chain.doFilter(request, response);
    }

    protected abstract String getPreAuthenticatedPrincipal(HttpServletRequest var1);

    protected abstract Collection<GeoServerRole> getRoles(HttpServletRequest var1, String var2) throws IOException;

    protected void doAuthenticate(HttpServletRequest request, HttpServletResponse response) {
        String principal = this.getPreAuthenticatedPrincipal(request);
        if (principal == null || principal.trim().length() == 0) {
            return;
        }
        LOGGER.log(Level.FINE, "preAuthenticatedPrincipal = " + principal + ", trying to authenticate");
        PreAuthenticatedAuthenticationToken result = null;
        if ("root".equals(principal)) {
            result = new PreAuthenticatedAuthenticationToken((Object)principal, null, Collections.singleton(GeoServerRole.ADMIN_ROLE));
        } else {
            Collection<GeoServerRole> roles = null;
            try {
                roles = this.getRoles(request, principal);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!roles.contains(GeoServerRole.AUTHENTICATED_ROLE)) {
                roles.add(GeoServerRole.AUTHENTICATED_ROLE);
            }
            result = new PreAuthenticatedAuthenticationToken((Object)principal, null, roles);
        }
        result.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        SecurityContextHolder.getContext().setAuthentication((Authentication)result);
    }

    public AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> getAuthenticationDetailsSource() {
        return this.authenticationDetailsSource;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, WebAuthenticationDetails> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    @Override
    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.aep;
    }

    protected boolean cacheAuthentication(Authentication auth, HttpServletRequest request) {
        return request.getSession(false) == null;
    }

    @Override
    public String getCacheKey(HttpServletRequest request) {
        if (request.getSession(false) != null) {
            return null;
        }
        String retval = this.getPreAuthenticatedPrincipal(request);
        if ("root".equals(retval)) {
            return null;
        }
        return retval;
    }

    @Override
    public boolean applicableForHtml() {
        return true;
    }

    @Override
    public boolean applicableForServices() {
        return true;
    }
}

