/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerRoleConverter;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerPreAuthenticationFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.RoleCalculator;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public abstract class GeoServerPreAuthenticatedUserNameFilter
extends GeoServerPreAuthenticationFilter {
    private RoleSource roleSource;
    private String rolesHeaderAttribute;
    private String userGroupServiceName;
    private String roleConverterName;
    private String roleServiceName;
    private GeoServerRoleConverter converter;
    protected static final String UserNameAlreadyRetrieved = "org.geoserver.security.filter.usernameAlreadyRetrieved";
    protected static final String UserName = "org.geoserver.security.filter.username";

    public RoleSource getRoleSource() {
        return this.roleSource;
    }

    public void setRoleSource(RoleSource roleSource) {
        this.roleSource = roleSource;
    }

    public String getRolesHeaderAttribute() {
        return this.rolesHeaderAttribute;
    }

    public void setRolesHeaderAttribute(String rolesHeaderAttribute) {
        this.rolesHeaderAttribute = rolesHeaderAttribute;
    }

    public String getUserGroupServiceName() {
        return this.userGroupServiceName;
    }

    public void setUserGroupServiceName(String userGroupServiceName) {
        this.userGroupServiceName = userGroupServiceName;
    }

    public String getRoleConverterName() {
        return this.roleConverterName;
    }

    public void setRoleConverterName(String roleConverterName) {
        this.roleConverterName = roleConverterName;
    }

    public String getRoleServiceName() {
        return this.roleServiceName;
    }

    public void setRoleServiceName(String roleServiceName) {
        this.roleServiceName = roleServiceName;
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        PreAuthenticatedUserNameFilterConfig authConfig = (PreAuthenticatedUserNameFilterConfig)config;
        this.roleSource = authConfig.getRoleSource();
        this.rolesHeaderAttribute = authConfig.getRolesHeaderAttribute();
        this.userGroupServiceName = authConfig.getUserGroupServiceName();
        this.roleConverterName = authConfig.getRoleConverterName();
        this.roleServiceName = authConfig.getRoleServiceName();
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header.equals(this.getRoleSource())) {
            String converterName = authConfig.getRoleConverterName();
            if (converterName == null || converterName.length() == 0) {
                this.setConverter((GeoServerRoleConverter)GeoServerExtensions.bean(GeoServerRoleConverter.class));
            } else {
                this.setConverter((GeoServerRoleConverter)GeoServerExtensions.bean((String)converterName));
            }
        }
    }

    @Override
    protected String getPreAuthenticatedPrincipal(HttpServletRequest request) {
        if (request.getAttribute(UserNameAlreadyRetrieved) != null) {
            return (String)request.getAttribute(UserName);
        }
        String principal = this.getPreAuthenticatedPrincipalName(request);
        if (principal != null && principal.trim().length() == 0) {
            principal = null;
        }
        try {
            GeoServerUserGroupService service;
            GeoServerUser u;
            if (principal != null && PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService.equals(this.getRoleSource()) && (u = (service = this.getSecurityManager().loadUserGroupService(this.getUserGroupServiceName())).getUserByUsername(principal)) != null && !u.isEnabled()) {
                principal = null;
                this.handleDisabledUser(u, request);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        request.setAttribute(UserNameAlreadyRetrieved, (Object)Boolean.TRUE);
        if (principal != null) {
            request.setAttribute(UserName, (Object)principal);
        }
        return principal;
    }

    protected void handleDisabledUser(GeoServerUser u, HttpServletRequest request) {
    }

    @Override
    protected Collection<GeoServerRole> getRoles(HttpServletRequest request, String principal) throws IOException {
        Collection<GeoServerRole> roles;
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService.equals(this.getRoleSource())) {
            roles = this.getRolesFromRoleService(request, principal);
        } else if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService.equals(this.getRoleSource())) {
            roles = this.getRolesFromUserGroupService(request, principal);
        } else if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header.equals(this.getRoleSource())) {
            roles = this.getRolesFromHttpAttribute(request, principal);
        } else {
            throw new RuntimeException("Never should reach this point");
        }
        LOGGER.log(Level.FINE, "Got roles {0} from {1} for principal {2}", new Object[]{roles, this.getRoleSource(), principal});
        return roles;
    }

    protected Collection<GeoServerRole> getRolesFromRoleService(HttpServletRequest request, String principal) throws IOException {
        boolean useActiveService = this.getRoleServiceName() == null || this.getRoleServiceName().trim().length() == 0;
        GeoServerRoleService service = useActiveService ? this.getSecurityManager().getActiveRoleService() : this.getSecurityManager().loadRoleService(this.getRoleServiceName());
        RoleCalculator calc = new RoleCalculator(service);
        return calc.calculateRoles(principal);
    }

    protected Collection<GeoServerRole> getRolesFromUserGroupService(HttpServletRequest request, String principal) throws IOException {
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(this.getUserGroupServiceName());
        UserDetails details = null;
        try {
            details = service.loadUserByUsername(principal);
        }
        catch (UsernameNotFoundException ex) {
            LOGGER.log(Level.WARNING, "User " + principal + " not found in " + this.getUserGroupServiceName());
        }
        if (details != null) {
            for (GrantedAuthority auth : details.getAuthorities()) {
                roles.add((GeoServerRole)auth);
            }
        }
        return roles;
    }

    protected Collection<GeoServerRole> getRolesFromHttpAttribute(HttpServletRequest request, String principal) throws IOException {
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        String rolesString = request.getHeader(this.getRolesHeaderAttribute());
        if (rolesString == null || rolesString.trim().length() == 0) {
            LOGGER.log(Level.WARNING, "No roles in header attribute: " + this.getRolesHeaderAttribute());
            return roles;
        }
        roles.addAll(this.getConverter().convertRolesFromString(rolesString, principal));
        LOGGER.log(Level.FINE, "for principal " + principal + " found roles " + StringUtils.collectionToCommaDelimitedString(roles) + " in header " + this.getRolesHeaderAttribute());
        return roles;
    }

    @Override
    public String getCacheKey(HttpServletRequest request) {
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header.equals(this.getRoleSource())) {
            return null;
        }
        return super.getCacheKey(request);
    }

    public GeoServerRoleConverter getConverter() {
        return this.converter;
    }

    public void setConverter(GeoServerRoleConverter converter) {
        this.converter = converter;
    }

    protected abstract String getPreAuthenticatedPrincipalName(HttpServletRequest var1);
}

