/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.file;

import java.io.File;
import java.io.IOException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.event.UserGroupLoadedEvent;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.file.FileWatcher;

public class UserGroupFileWatcher
extends FileWatcher
implements UserGroupLoadedListener {
    protected GeoServerUserGroupService service;

    public UserGroupFileWatcher(Resource resource, GeoServerUserGroupService service) {
        super(resource);
        this.service = service;
        this.checkAndConfigure();
    }

    public UserGroupFileWatcher(File file, GeoServerUserGroupService service) {
        super(file);
        this.service = service;
        this.checkAndConfigure();
    }

    public UserGroupFileWatcher(Resource resource, GeoServerUserGroupService service, long lastModified) {
        super(resource);
        this.service = service;
        this.lastModified = lastModified;
        this.checkAndConfigure();
    }

    public UserGroupFileWatcher(File file, GeoServerUserGroupService service, long lastModified) {
        super(file);
        this.service = service;
        this.lastModified = lastModified;
        this.checkAndConfigure();
    }

    public synchronized GeoServerUserGroupService getService() {
        return this.service;
    }

    public synchronized void setService(GeoServerUserGroupService service) {
        this.service = service;
    }

    @Override
    protected void doOnChange() {
        GeoServerUserGroupService theService = this.getService();
        try {
            if (theService != null) {
                theService.load();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String serviceName = this.service == null ? "UNKNOWN" : this.service.getName();
        buff.append("FileWatcher for ").append(serviceName);
        buff.append(", ").append(this.getFileInfo());
        return buff.toString();
    }

    @Override
    public void usersAndGroupsChanged(UserGroupLoadedEvent event) {
        this.setLastModified(this.resource.lastmodified());
        LOGGER.info("Adjusted last modified for file: " + this.path);
    }
}

